/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.pgp.transport;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import org.subshare.core.pgp.transport.PgpTransportFactory;
import org.subshare.core.pgp.transport.PgpTransportFactoryRegistry;

public class PgpTransportFactoryRegistryImpl
implements PgpTransportFactoryRegistry {
    private List<PgpTransportFactory> pgpTransportFactories;

    public static PgpTransportFactoryRegistry getInstance() {
        return PgpTransportFactoryRegistryHolder.instance;
    }

    protected PgpTransportFactoryRegistryImpl() {
    }

    @Override
    public PgpTransportFactory getPgpTransportFactoryOrFail(URL url) {
        PgpTransportFactory pgpTransportFactory = this.getPgpTransportFactory(url);
        if (pgpTransportFactory == null) {
            throw new IllegalStateException("There is no PgpTransportFactory supporting this URL: " + url);
        }
        return pgpTransportFactory;
    }

    @Override
    public PgpTransportFactory getPgpTransportFactory(URL remoteRoot) {
        for (PgpTransportFactory factory : this.getPgpTransportFactories()) {
            if (!factory.isSupported(remoteRoot)) continue;
            return factory;
        }
        return null;
    }

    @Override
    public List<PgpTransportFactory> getPgpTransportFactories(URL remoteRoot) {
        ArrayList<PgpTransportFactory> result = new ArrayList<PgpTransportFactory>();
        for (PgpTransportFactory factory : this.getPgpTransportFactories()) {
            if (!factory.isSupported(remoteRoot)) continue;
            result.add(factory);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public synchronized List<PgpTransportFactory> getPgpTransportFactories() {
        List<PgpTransportFactory> pgpTransportFactories = this.pgpTransportFactories;
        if (pgpTransportFactories == null) {
            pgpTransportFactories = PgpTransportFactoryRegistryImpl.loadPgpTransportFactoriesViaServiceLoader();
            PgpTransportFactoryRegistryImpl.sortPgpTransportFactories(pgpTransportFactories);
            this.pgpTransportFactories = pgpTransportFactories = Collections.unmodifiableList(pgpTransportFactories);
        }
        return pgpTransportFactories;
    }

    private static List<PgpTransportFactory> loadPgpTransportFactoriesViaServiceLoader() {
        ArrayList<PgpTransportFactory> pgpTransportFactories = new ArrayList<PgpTransportFactory>();
        ServiceLoader<PgpTransportFactory> sl = ServiceLoader.load(PgpTransportFactory.class);
        Iterator<PgpTransportFactory> it = sl.iterator();
        while (it.hasNext()) {
            pgpTransportFactories.add(it.next());
        }
        pgpTransportFactories.trimToSize();
        return pgpTransportFactories;
    }

    protected static int _compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private static void sortPgpTransportFactories(List<PgpTransportFactory> pgpTransportFactories) {
        Collections.sort(pgpTransportFactories, new Comparator<PgpTransportFactory>(){

            @Override
            public int compare(PgpTransportFactory o1, PgpTransportFactory o2) {
                String name2;
                int result = -1 * PgpTransportFactoryRegistryImpl._compare(o1.getPriority(), o2.getPriority());
                if (result != 0) {
                    return result;
                }
                String name1 = o1.getName() == null ? "" : o1.getName();
                result = name1.compareTo(name2 = o2.getName() == null ? "" : o2.getName());
                if (result != 0) {
                    return result;
                }
                return o1.getClass().getName().compareTo(o2.getClass().getName());
            }
        });
    }

    @Override
    public <F extends PgpTransportFactory> F getPgpTransportFactoryOrFail(Class<F> factoryClass) {
        F pgpTransportFactory = this.getPgpTransportFactory(factoryClass);
        if (pgpTransportFactory == null) {
            throw new IllegalArgumentException("There is no factory registered implementing this interface or extending this class: " + factoryClass.getName());
        }
        return pgpTransportFactory;
    }

    @Override
    public <F extends PgpTransportFactory> F getPgpTransportFactory(Class<F> factoryClass) {
        Objects.requireNonNull(factoryClass, "factoryClass");
        List<PgpTransportFactory> pgpTransportFactories = this.getPgpTransportFactories();
        for (PgpTransportFactory pgpTransportFactory : pgpTransportFactories) {
            if (!factoryClass.isInstance(pgpTransportFactory)) continue;
            return (F)((PgpTransportFactory)factoryClass.cast(pgpTransportFactory));
        }
        return null;
    }

    private static class PgpTransportFactoryRegistryHolder {
        public static final PgpTransportFactoryRegistryImpl instance = new PgpTransportFactoryRegistryImpl();

        private PgpTransportFactoryRegistryHolder() {
        }
    }
}

