/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.sign;

import co.codewizards.cloudstore.core.util.DateUtil;
import co.codewizards.cloudstore.core.util.IOUtil;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Objects;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Signer;
import org.subshare.core.crypto.CryptoConfigUtil;
import org.subshare.core.sign.SignerTransformation;
import org.subshare.core.sign.VerifierInputStream;
import org.subshare.core.user.UserRepoKey;
import org.subshare.crypto.CryptoRegistry;

public class SignerOutputStream
extends FilterOutputStream {
    public static final int MAGIC_BYTE = 204;
    private boolean closed;
    private boolean closeUnderlyingStream = true;
    private final UserRepoKey userRepoKey;
    private final SignerTransformation signerTransformation;
    private final Signer signer;
    private final Date signatureCreated;

    public SignerOutputStream(OutputStream out, UserRepoKey signingUserRepoKey) throws IOException {
        this(out, signingUserRepoKey, DateUtil.now());
    }

    public SignerOutputStream(OutputStream out, UserRepoKey signingUserRepoKey, Date signatureCreated) throws IOException {
        super(out);
        this.userRepoKey = Objects.requireNonNull(signingUserRepoKey, "signingUserRepoKey");
        this.signerTransformation = CryptoConfigUtil.getSignerTransformation();
        this.signatureCreated = signatureCreated;
        try {
            this.signer = CryptoRegistry.getInstance().createSigner(this.signerTransformation.getTransformation());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        this.signer.init(true, (CipherParameters)signingUserRepoKey.getKeyPair().getPrivate());
        this.writeHeader();
    }

    private void writeHeader() throws IOException {
        this.out.write(204);
        this.out.write(1);
        int signerTransformationNumeric = this.signerTransformation.ordinal();
        if (signerTransformationNumeric > 65535) {
            throw new IllegalStateException("signerTransformationNumeric > 65535");
        }
        this.out.write(signerTransformationNumeric);
        this.out.write(signerTransformationNumeric >>> 8);
        byte[] signingUserRepoKeyIdBytes = this.userRepoKey.getUserRepoKeyId().toBytes();
        if (signingUserRepoKeyIdBytes.length != 16) {
            throw new IllegalStateException(String.format("signingUserRepoKeyIdBytes.length != 16 :: %s != 16", signingUserRepoKeyIdBytes.length));
        }
        this.out.write(signingUserRepoKeyIdBytes);
        byte[] signatureCreatedBytes = IOUtil.longToBytes((long)this.signatureCreated.getTime());
        if (signatureCreatedBytes.length != 8) {
            throw new IllegalStateException(String.format("signatureCreatedBytes.length != 8 :: %s != 8", signatureCreatedBytes.length));
        }
        this.signer.update(signatureCreatedBytes, 0, signatureCreatedBytes.length);
        this.out.write(signatureCreatedBytes);
    }

    private void writeSignature() throws DataLengthException, CryptoException, IOException {
        byte[] signatureBytes = this.signer.generateSignature();
        int footerLength = signatureBytes.length + 4;
        if (footerLength > VerifierInputStream.MAX_FOOTER_LENGTH) {
            throw new IllegalStateException(String.format("footerLength > MAX_FOOTER_LENGTH :: %s > %s", footerLength, VerifierInputStream.MAX_FOOTER_LENGTH));
        }
        this.out.write(signatureBytes);
        int signatureBytesLength = signatureBytes.length;
        this.out.write(signatureBytesLength);
        this.out.write(signatureBytesLength >>> 8);
        this.out.write(signatureBytesLength >>> 16);
        this.out.write(signatureBytesLength >>> 24);
    }

    @Override
    public void write(int b) throws IOException {
        this.assertNotClosed();
        this.signer.update((byte)b);
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.assertNotClosed();
        this.signer.update(b, off, len);
        this.out.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            try {
                this.writeSignature();
            }
            catch (CryptoException | DataLengthException e) {
                throw new IOException(e);
            }
            if (this.isCloseUnderlyingStream()) {
                this.out.close();
            }
        }
    }

    public boolean isCloseUnderlyingStream() {
        return this.closeUnderlyingStream;
    }

    public void setCloseUnderlyingStream(boolean closeUnderlyingStream) {
        this.closeUnderlyingStream = closeUnderlyingStream;
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("SignerOutputStream already closed!");
        }
    }
}

