/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import co.codewizards.cloudstore.core.appid.AppIdRegistry;
import co.codewizards.cloudstore.core.config.ConfigDir;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.updater.CloudStoreUpdaterCore;
import co.codewizards.cloudstore.core.util.DateUtil;
import co.codewizards.cloudstore.core.util.DebugUtil;
import co.codewizards.cloudstore.core.util.DerbyUtil;
import co.codewizards.cloudstore.core.util.MainArgsUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.core.version.Version;
import co.codewizards.cloudstore.ls.client.LocalServerClient;
import co.codewizards.cloudstore.ls.server.LocalServer;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.image.Image;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpKeyId;
import org.subshare.core.pgp.man.PgpPrivateKeyPassphraseStore;
import org.subshare.gui.ExitCode;
import org.subshare.gui.backup.exp.ExportBackupWizard;
import org.subshare.gui.error.ErrorHandler;
import org.subshare.gui.ls.LocalServerInitLs;
import org.subshare.gui.ls.PgpLs;
import org.subshare.gui.ls.PgpPrivateKeyPassphraseManagerLs;
import org.subshare.gui.pgp.privatekeypassphrase.PgpPrivateKeyPassphrasePromptDialog;
import org.subshare.gui.splash.SplashPane;
import org.subshare.gui.util.PlatformUtil;
import org.subshare.gui.util.ResourceBundleUtil;
import org.subshare.gui.welcome.ServerWizard;
import org.subshare.gui.welcome.Welcome;
import org.subshare.gui.welcome.pgp.privatekeypassphrase.IntroWizard;
import org.subshare.gui.wizard.WizardDialog;
import org.subshare.gui.wizard.WizardState;
import org.subshare.ls.server.SsLocalServer;
import org.subshare.ls.server.cproc.SsLocalServerProcessLauncher;

public class SubShareGui
extends Application {
    private static final Logger logger = LoggerFactory.getLogger(SubShareGui.class);
    private volatile SsLocalServer localServer;
    private Stage primaryStage;
    private Stage splashStage;
    private SplashPane splashPane;
    private volatile File localServerStopFile;
    private volatile ExitCode exitCode = ExitCode.SUCCESS;
    private static final List<Image> icons = Collections.unmodifiableList(Arrays.asList(SubShareGui.loadImage("subshare_16x16.png"), SubShareGui.loadImage("subshare_32x32.png"), SubShareGui.loadImage("subshare_48x48.png"), SubShareGui.loadImage("subshare_256x256.png")));
    private volatile boolean updaterDirAlreadyCreated;
    private final Timer localServerStopFileTimer = new Timer("localServerStopFileTimer", true);
    private TimerTask localServerStopFileTimerTask;

    private static final Image loadImage(String fileName) {
        URL url = SubShareGui.class.getResource(fileName);
        if (url == null) {
            throw new IllegalArgumentException(String.format("Resource '%s' not found!", fileName));
        }
        return new Image(url.toExternalForm());
    }

    public void init() throws Exception {
        super.init();
    }

    public void start(Stage primaryStage) throws Exception {
        this.primaryStage = primaryStage;
        primaryStage.getIcons().addAll(icons);
        primaryStage.setTitle("subshare");
        if (this.isAfterUpdateHook()) {
            this.createUpdaterCore().getUpdaterDir().deleteRecursively();
            this.showUpdateDoneDialog();
            System.exit(1);
        }
        this.showSplash();
        this.startInitThread();
    }

    private boolean isAfterUpdateHook() {
        for (String parameter : this.getParameters().getRaw()) {
            if (!"afterUpdateHook".equals(parameter)) continue;
            return true;
        }
        return false;
    }

    private void showSplash() {
        this.splashPane = new SplashPane();
        Scene scene = new Scene((Parent)this.splashPane, 400.0, 300.0);
        scene.setFill(null);
        this.splashStage = new Stage(StageStyle.TRANSPARENT);
        this.splashStage.getIcons().addAll(icons);
        this.splashStage.setScene(scene);
        this.splashStage.setTitle("subshare");
        this.splashStage.show();
    }

    private void startInitThread() {
        new Thread(){
            {
                this.setName("Initialisation");
            }

            @Override
            public void run() {
                try {
                    Thread.setDefaultUncaughtExceptionHandler(ErrorHandler.getUncaughtExceptionHandler());
                    SubShareGui.initLogging();
                    CloudStoreUpdaterCore updaterCore = SubShareGui.this.createUpdaterCore();
                    if (updaterCore.createUpdaterDirIfUpdateNeeded()) {
                        SubShareGui.this.updaterDirAlreadyCreated = true;
                        PlatformUtil.runAndWait(() -> SubShareGui.this.showUpdateStartingDialog(updaterCore));
                        SubShareGui.this.stopLater();
                        return;
                    }
                    new SsLocalServerProcessLauncher().start();
                    SubShareGui.this.localServer = new SsLocalServer();
                    if (!SubShareGui.this.localServer.start()) {
                        SubShareGui.this.localServer = null;
                    }
                    LocalServerInitLs.initPrepare();
                    if (LocalServerClient.getInstance().isLocalServerInSeparateProcess()) {
                        SubShareGui.this.createLocalServerStopFileTimerTask();
                    }
                    Set pgpKeyIdsHavingPrivateKeyBeforeRestore = SubShareGui.this.getIdsOfMasterKeysWithPrivateKey();
                    SubShareGui.this.tryPgpKeysNoPassphrase();
                    PlatformUtil.runAndWait(() -> SubShareGui.this.promptPgpKeyPassphrases(SubShareGui.this.getWindow()));
                    if (SubShareGui.this.exitCode != ExitCode.SUCCESS) {
                        SubShareGui.this.stopLater();
                        return;
                    }
                    Welcome welcome = new Welcome(SubShareGui.this.getWindow());
                    if (!welcome.welcome()) {
                        SubShareGui.this.exitCode = ExitCode.WELCOME_WIZARD_ABORTED;
                        SubShareGui.this.stopLater();
                        return;
                    }
                    if (!SubShareGui.this.getIdsOfMasterKeysWithPrivateKey().equals(pgpKeyIdsHavingPrivateKeyBeforeRestore)) {
                        SubShareGui.this.tryPgpKeysNoPassphrase();
                        PlatformUtil.runAndWait(() -> SubShareGui.this.promptPgpKeyPassphrases(SubShareGui.this.getWindow()));
                    }
                    PlatformUtil.runAndWait(() -> SubShareGui.this.backupIfNeeded());
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Parent root = (Parent)FXMLLoader.load((URL)SubShareGui.class.getResource("MainPane.fxml"), (ResourceBundle)ResourceBundleUtil.getMessages(SubShareGui.class));
                                Scene scene = new Scene(root, 800.0, 600.0);
                                scene.getStylesheets().add((Object)this.getClass().getResource("application.css").toExternalForm());
                                SubShareGui.this.splashStage.hide();
                                SubShareGui.this.splashPane = null;
                                SubShareGui.this.primaryStage.setScene(scene);
                                SubShareGui.this.primaryStage.show();
                                SubShareGui.this.splashPane = null;
                                LocalServerInitLs.initFinish();
                            }
                            catch (Exception x) {
                                ErrorHandler.handleError(x);
                                SubShareGui.this.exitCode = ExitCode.EXCEPTION_CAUGHT;
                                SubShareGui.this.stopLater();
                            }
                        }
                    });
                }
                catch (Exception x) {
                    ErrorHandler.handleError(x);
                    SubShareGui.this.exitCode = ExitCode.EXCEPTION_CAUGHT;
                    SubShareGui.this.stopLater();
                }
            }
        }.start();
    }

    protected Window getWindow() {
        Scene scene;
        Stage stage = this.primaryStage;
        Scene scene2 = scene = stage == null ? null : stage.getScene();
        if (scene == null) {
            stage = this.splashStage;
            scene = stage == null ? null : stage.getScene();
        }
        return scene == null ? null : scene.getWindow();
    }

    private Set<PgpKeyId> getIdsOfMasterKeysWithPrivateKey() {
        Collection masterKeysWithPrivateKey = PgpLs.getPgpOrFail().getMasterKeysWithSecretKey();
        HashSet<PgpKeyId> pgpKeyIds = new HashSet<PgpKeyId>(masterKeysWithPrivateKey.size());
        for (PgpKey pgpKey : masterKeysWithPrivateKey) {
            pgpKeyIds.add(pgpKey.getPgpKeyId());
        }
        return pgpKeyIds;
    }

    protected void stopLater() {
        Platform.runLater(() -> {
            try {
                this.stop();
            }
            catch (Exception x) {
                logger.error("stopLater: " + x, (Throwable)x);
            }
        });
    }

    protected void backupIfNeeded() {
        ExportBackupWizard wizard = new ExportBackupWizard();
        if (wizard.isNeeded()) {
            new WizardDialog(this.getWindow(), wizard).showAndWait();
        }
    }

    public void stop() throws Exception {
        PlatformUtil.assertFxApplicationThread();
        if (!this.updaterDirAlreadyCreated) {
            CloudStoreUpdaterCore updaterCore;
            if (this.exitCode == ExitCode.SUCCESS) {
                this.backupIfNeeded();
            }
            if ((updaterCore = this.createUpdaterCore()).createUpdaterDirIfUpdateNeeded()) {
                this.showUpdateStartingDialog(updaterCore);
            }
        }
        PlatformUtil.notifyExiting();
        SsLocalServer _localServer = this.localServer;
        this.localServer = null;
        super.stop();
        new Thread((LocalServer)_localServer){
            final /* synthetic */ LocalServer val$_localServer;
            {
                this.val$_localServer = localServer;
                this.setName(SubShareGui.class.getSimpleName() + ".StopThread");
            }

            @Override
            public void run() {
                LocalServerClient.getInstance().close();
                if (this.val$_localServer != null) {
                    this.val$_localServer.stop();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Util.doNothing();
                }
                System.exit(SubShareGui.this.exitCode.getNumericCode());
            }
        }.start();
    }

    private CloudStoreUpdaterCore createUpdaterCore() {
        return new CloudStoreUpdaterCore();
    }

    public static void main(String[] args) {
        args = MainArgsUtil.extractAndApplySystemPropertiesReturnOthers((String[])args);
        SubShareGui.launch((String[])args);
    }

    private void tryPgpKeysNoPassphrase() throws InterruptedException {
        Pgp pgp = PgpLs.getPgpOrFail();
        PgpPrivateKeyPassphraseStore pgpPrivateKeyPassphraseStore = PgpPrivateKeyPassphraseManagerLs.getPgpPrivateKeyPassphraseStore();
        Date now = DateUtil.now();
        for (PgpKey pgpKey : pgp.getMasterKeysWithSecretKey()) {
            PgpKeyId pgpKeyId;
            if (!pgpKey.isValid(now) || pgpPrivateKeyPassphraseStore.hasPassphrase(pgpKeyId = pgpKey.getPgpKeyId()) || !pgp.testPassphrase(pgpKey, new char[0])) continue;
            try {
                pgpPrivateKeyPassphraseStore.putPassphrase(pgpKeyId, new char[0]);
            }
            catch (Exception x) {
                Util.doNothing();
            }
        }
    }

    private void promptPgpKeyPassphrases(Window owner) {
        boolean serverWizardIsNeeded = new ServerWizard(true, true).isNeeded();
        boolean introAlreadyShown = false;
        Pgp pgp = PgpLs.getPgpOrFail();
        PgpPrivateKeyPassphraseStore pgpPrivateKeyPassphraseStore = PgpPrivateKeyPassphraseManagerLs.getPgpPrivateKeyPassphraseStore();
        Date now = DateUtil.now();
        for (PgpKey pgpKey : pgp.getMasterKeysWithSecretKey()) {
            PgpKeyId pgpKeyId;
            if (pgpKey.isRevoked() || !pgpKey.isValid(now) || pgpPrivateKeyPassphraseStore.hasPassphrase(pgpKeyId = pgpKey.getPgpKeyId())) continue;
            if (serverWizardIsNeeded && !introAlreadyShown) {
                introAlreadyShown = true;
                IntroWizard introWizard = new IntroWizard();
                new WizardDialog(owner, introWizard).showAndWait();
                if (introWizard.getState() == WizardState.CANCELLED) {
                    this.exitCode = ExitCode.INTRO_WIZARD_ABORTED;
                    return;
                }
            }
            boolean retry = false;
            String errorMessage = null;
            do {
                PgpPrivateKeyPassphrasePromptDialog dialog = new PgpPrivateKeyPassphrasePromptDialog(owner, pgpKey, errorMessage);
                dialog.showAndWait();
                retry = false;
                errorMessage = null;
                char[] passphrase = dialog.getPassphrase();
                if (passphrase == null) continue;
                try {
                    pgpPrivateKeyPassphraseStore.putPassphrase(pgpKeyId, passphrase);
                }
                catch (SecurityException x) {
                    logger.error("promptPgpKeyPassphrases: " + x, (Throwable)x);
                    retry = true;
                    errorMessage = "Sorry, the passphrase you entered is wrong! Please try again.";
                }
                catch (Exception x) {
                    ErrorHandler.handleError(x);
                }
            } while (retry);
        }
    }

    private static void initLogging() throws IOException, JoranException {
        File logDir = ConfigDir.getInstance().getLogDir();
        DerbyUtil.setLogFile((File)OioFileFactory.createFile((File)logDir, (String[])new String[]{"derby.log"}));
        String logbackXmlName = "logback.client.xml";
        File logbackXmlFile = OioFileFactory.createFile((File)ConfigDir.getInstance().getFile(), (String[])new String[]{"logback.client.xml"});
        if (!logbackXmlFile.exists()) {
            AppIdRegistry.getInstance().copyResourceResolvingAppId(SubShareGui.class, "logback.client.xml", logbackXmlFile);
        }
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context);
            context.reset();
            configurator.doConfigure(logbackXmlFile.getIoFile());
        }
        catch (JoranException je) {
            Util.doNothing();
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
        DebugUtil.logSystemProperties();
    }

    private void showUpdateStartingDialog(CloudStoreUpdaterCore updaterCore) {
        Objects.requireNonNull(updaterCore, "updaterCore");
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setHeaderText("Update to a new Subshare version!");
        String text = String.format("You are currently using Subshare version %s.\n\nThe new version %s is available and is going to be installed, now.\n\nThe update might take a few minutes - please be patient!", updaterCore.getLocalVersion(), updaterCore.getRemoteVersion());
        Text contentText = new Text(text);
        HBox contentTextContainer = new HBox();
        contentTextContainer.getChildren().add((Object)contentText);
        GridPane.setMargin((Node)contentText, (Insets)new Insets(8.0));
        alert.getDialogPane().setContent((Node)contentTextContainer);
        alert.showAndWait();
    }

    private void showUpdateDoneDialog() {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setHeaderText("Update to a new Subshare version done!");
        Version localVersion = new CloudStoreUpdaterCore().getLocalVersion();
        String text = String.format("Subshare was updated to version %s.", localVersion);
        Text contentText = new Text(text);
        HBox contentTextContainer = new HBox();
        contentTextContainer.getChildren().add((Object)contentText);
        GridPane.setMargin((Node)contentText, (Insets)new Insets(8.0));
        alert.getDialogPane().setContent((Node)contentTextContainer);
        alert.showAndWait();
    }

    protected File getLocalServerStopFile() {
        if (this.localServerStopFile == null) {
            this.localServerStopFile = OioFileFactory.createFile((File)ConfigDir.getInstance().getFile(), (String[])new String[]{"localServerRunning.deleteToStop"});
        }
        return this.localServerStopFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLocalServerStopFileTimerTask() {
        final File localServerStopFile = this.getLocalServerStopFile();
        if (!localServerStopFile.exists()) {
            logger.warn("localServerStopFileTimerTask.run: file '{}' does not exist during GUI client startup!", (Object)localServerStopFile);
        }
        Timer timer = this.localServerStopFileTimer;
        synchronized (timer) {
            this.cancelLocalServerStopFileTimerTask();
            this.localServerStopFileTimerTask = new TimerTask(){

                @Override
                public void run() {
                    if (localServerStopFile.exists()) {
                        logger.debug("localServerStopFileTimerTask.run: file '{}' exists => nothing to do.", (Object)localServerStopFile);
                        return;
                    }
                    logger.info("localServerStopFileTimerTask.run: file '{}' does not exist => stopping server!", (Object)localServerStopFile);
                    SubShareGui.this.exitCode = ExitCode.LOCAL_SERVER_STOPPED;
                    SubShareGui.this.stopLater();
                }
            };
            long period = 5000L;
            this.localServerStopFileTimer.schedule(this.localServerStopFileTimerTask, 5000L, 5000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelLocalServerStopFileTimerTask() {
        Timer timer = this.localServerStopFileTimer;
        synchronized (timer) {
            if (this.localServerStopFileTimerTask != null) {
                this.localServerStopFileTimerTask.cancel();
                this.localServerStopFileTimerTask = null;
            }
        }
    }
}

