/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.rest.client;

import co.codewizards.cloudstore.core.dto.Error;
import co.codewizards.cloudstore.core.dto.RemoteException;
import co.codewizards.cloudstore.core.dto.RemoteExceptionUtil;
import co.codewizards.cloudstore.core.exception.ApplicationException;
import co.codewizards.cloudstore.core.util.ExceptionUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.rest.client.CredentialsProvider;
import co.codewizards.cloudstore.rest.client.request.Request;
import co.codewizards.cloudstore.rest.client.ssl.CallbackDeniedTrustException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudStoreRestClient {
    private static final Logger logger = LoggerFactory.getLogger(CloudStoreRestClient.class);
    private final URL url;
    private String baseURL;
    private final LinkedList<Client> clientCache = new LinkedList();
    private ClientBuilder clientBuilder;
    private CredentialsProvider credentialsProvider;
    private final ThreadLocal<ClientRef> clientThreadLocal = new ThreadLocal();

    public synchronized String getBaseUrl() {
        if (this.baseURL == null) {
            this.determineBaseUrl();
        }
        return this.baseURL;
    }

    public CloudStoreRestClient(URL url, ClientBuilder clientBuilder) {
        this.url = Objects.requireNonNull(url, "url");
        this.clientBuilder = Objects.requireNonNull(clientBuilder, "clientBuilder");
    }

    public CloudStoreRestClient(String url, ClientBuilder clientBuilder) {
        try {
            this.url = Objects.requireNonNull(new URL(url), "url");
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("url is invalid", e);
        }
        this.clientBuilder = Objects.requireNonNull(clientBuilder, "clientBuilder");
    }

    private void determineBaseUrl() {
        String hostUrl = this.getHostUrl();
        logger.debug("determineBaseUrl: hostURL='{}': entered.", (Object)hostUrl);
        this.acquireClient();
        try {
            Client client = this.getClientOrFail();
            String url = hostUrl;
            for (String part : this.getPathParts()) {
                if (!part.isEmpty()) {
                    url = url + part + "/";
                }
                String testUrl = url + "_test";
                try {
                    String response = (String)client.target(testUrl).request(new String[]{"text/plain"}).get(String.class);
                    if (!"SUCCESS".equals(response)) continue;
                    this.baseURL = url;
                    break;
                }
                catch (WebApplicationException wax) {
                    Util.doNothing();
                }
            }
        }
        catch (Exception x) {
            String message = String.format("Determining baseURL failed for hostURL='%s': %s", hostUrl, x.toString());
            logger.error("determineBaseUrl: " + message);
            throw new ProcessingException(message, (Throwable)x);
        }
        finally {
            this.releaseClient();
        }
        if (this.baseURL == null) {
            String message = String.format("baseURL for hostURL='%s' not found!", hostUrl);
            logger.error("determineBaseUrl: " + message);
            throw new IllegalStateException(message);
        }
        logger.debug("determineBaseUrl: hostURL='{}' => baseURL='{}'", (Object)hostUrl, (Object)this.baseURL);
    }

    private List<String> getPathParts() {
        ArrayList<String> pathParts = new ArrayList<String>(Arrays.asList(this.url.getPath().split("/")));
        if (pathParts.isEmpty()) {
            pathParts.add("");
        }
        return pathParts;
    }

    private String getHostUrl() {
        String hostUrl = this.url.getProtocol() + "://" + this.url.getHost();
        if (this.url.getPort() != -1) {
            hostUrl = hostUrl + ":" + this.url.getPort();
        }
        return hostUrl + "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public <R> R execute(Request<R> request) {
        Objects.requireNonNull(request, "request");
        Throwable firstException = null;
        int retryCounter = 0;
        int retryMax = 2;
        while (true) {
            this.acquireClient();
            long start = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug("execute: starting try {} of {}", (Object)(retryCounter + 1), (Object)3);
            }
            request.setCloudStoreRestClient(this);
            R result = request.execute();
            if (logger.isDebugEnabled()) {
                logger.debug("execute: invocation took {} ms", (Object)(System.currentTimeMillis() - start));
            }
            if (result == null && !request.isResultNullable()) {
                throw new IllegalStateException("result == null, but request.resultNullable == false!");
            }
            R r = result;
            this.releaseClient();
            request.setCloudStoreRestClient(null);
            return r;
            {
                catch (RuntimeException e) {
                    try {
                        Throwable exception;
                        try {
                            exception = this.handleAndRethrowException(e);
                        }
                        catch (Throwable y) {
                            exception = y;
                        }
                        Throwable applicationException = this.getApplicationException(exception);
                        if (applicationException != null) {
                            if (applicationException == exception) {
                                logger.info("Caught {} => immediately rethrowing.", (Object)exception.getClass().getName());
                            } else {
                                logger.info("Caught {} wrapped in {} => immediately rethrowing.", (Object)applicationException.getClass().getName(), (Object)exception.getClass().getName());
                            }
                            logger.debug("execute: " + exception, exception);
                            throw ExceptionUtil.throwThrowableAsRuntimeExceptionIfNeeded((Throwable)exception);
                        }
                        if (firstException == null) {
                            firstException = exception;
                        }
                        this.markClientBroken();
                        if (++retryCounter > 2 || !this.retryExecuteAfterException(exception)) {
                            logger.warn("execute: invocation failed (will NOT retry): " + exception, exception);
                            throw this.handleAndRethrowException(firstException);
                        }
                        logger.warn("execute: invocation failed (will retry): " + exception, exception);
                        try {
                            Thread.sleep((long)retryCounter * 1000L);
                        }
                        catch (Exception y) {
                            Util.doNothing();
                        }
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.releaseClient();
                        request.setCloudStoreRestClient(null);
                        continue;
                    }
                }
            }
            break;
        }
    }

    private Throwable getApplicationException(Throwable exception) {
        Objects.requireNonNull(exception, "exception");
        for (Throwable x = exception; x != null; x = x.getCause()) {
            ApplicationException appEx = x.getClass().getAnnotation(ApplicationException.class);
            if (appEx == null) continue;
            return x;
        }
        return null;
    }

    private boolean retryExecuteAfterException(Throwable x) {
        return ExceptionUtil.getCause((Throwable)x, CallbackDeniedTrustException.class) == null;
    }

    public Invocation.Builder assignCredentials(Invocation.Builder builder) {
        CredentialsProvider credentialsProvider = this.getCredentialsProviderOrFail();
        builder.property("jersey.config.client.http.auth.basic.username", (Object)credentialsProvider.getUserName());
        builder.property("jersey.config.client.http.auth.basic.password", (Object)credentialsProvider.getPassword());
        return builder;
    }

    private synchronized void acquireClient() {
        ClientRef clientRef = this.clientThreadLocal.get();
        if (clientRef != null) {
            ++clientRef.refCount;
            return;
        }
        Client client = this.clientCache.poll();
        if (client == null) {
            client = this.clientBuilder.build();
            HttpAuthenticationFeature feature = HttpAuthenticationFeature.basic((String)"anonymous", (String)"");
            client.register((Object)feature);
        }
        this.clientThreadLocal.set(new ClientRef(client));
    }

    public Client getClientOrFail() {
        ClientRef clientRef = this.clientThreadLocal.get();
        if (clientRef == null) {
            throw new IllegalStateException("acquireClient() not called on the same thread (or releaseClient() already called)!");
        }
        return clientRef.client;
    }

    private synchronized void releaseClient() {
        ClientRef clientRef = this.clientThreadLocal.get();
        if (clientRef == null) {
            throw new IllegalStateException("acquireClient() not called on the same thread (or releaseClient() called more often than acquireClient())!");
        }
        if (--clientRef.refCount == 0) {
            this.clientThreadLocal.remove();
            if (!clientRef.broken) {
                this.clientCache.add(clientRef.client);
            }
        }
    }

    private void markClientBroken() {
        ClientRef clientRef = this.clientThreadLocal.get();
        if (clientRef == null) {
            throw new IllegalStateException("acquireClient() not called on the same thread (or releaseClient() called more often than acquireClient())!");
        }
        clientRef.broken = true;
    }

    protected RuntimeException handleAndRethrowException(Throwable x) {
        Response response = null;
        if (x instanceof WebApplicationException) {
            response = ((WebApplicationException)x).getResponse();
        } else if (x instanceof ResponseProcessingException) {
            response = ((ResponseProcessingException)x).getResponse();
        }
        if (response == null) {
            throw ExceptionUtil.throwThrowableAsRuntimeExceptionIfNeeded((Throwable)x);
        }
        Error error = null;
        try {
            response.bufferEntity();
            if (response.hasEntity()) {
                error = (Error)response.readEntity(Error.class);
            }
            logger.trace("handleAndRethrowException: " + x, x);
        }
        catch (Exception y) {
            logger.error("handleAndRethrowException: " + x, x);
            logger.error("handleAndRethrowException: " + y, (Throwable)y);
        }
        if (error != null) {
            RemoteExceptionUtil.throwOriginalExceptionIfPossible((Error)error);
            throw new RemoteException(error);
        }
        throw ExceptionUtil.throwThrowableAsRuntimeExceptionIfNeeded((Throwable)x);
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    private CredentialsProvider getCredentialsProviderOrFail() {
        CredentialsProvider credentialsProvider = this.getCredentialsProvider();
        if (credentialsProvider == null) {
            throw new IllegalStateException("credentialsProvider == null");
        }
        return credentialsProvider;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    private static class ClientRef {
        public final Client client;
        public int refCount = 1;
        public boolean broken;

        public ClientRef(Client client) {
            this.client = Objects.requireNonNull(client, "client");
        }
    }
}

