/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.util;

import java.util.Objects;

public final class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static <T extends Throwable> T getCause(Throwable throwable, Class<T> searchClass) {
        Objects.requireNonNull(throwable, "throwable");
        Objects.requireNonNull(searchClass, "searchClass");
        for (Throwable cause = throwable; cause != null; cause = cause.getCause()) {
            if (!searchClass.isInstance(cause)) continue;
            return (T)((Throwable)searchClass.cast(cause));
        }
        return null;
    }

    public static RuntimeException throwThrowableAsRuntimeExceptionIfNeeded(Throwable throwable) {
        Objects.requireNonNull(throwable, "throwable");
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new RuntimeException(throwable);
    }
}

