/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.backup.exp;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.progress.ProgressMonitor;
import co.codewizards.cloudstore.core.util.DateUtil;
import java.util.Objects;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.Text;
import org.subshare.gui.backup.BackupExporter;
import org.subshare.gui.backup.exp.ExportBackupData;
import org.subshare.gui.backup.exp.Messages;
import org.subshare.gui.backup.exp.first.FirstWizardPage;
import org.subshare.gui.wizard.Wizard;

public class ExportBackupWizard
extends Wizard {
    private final ExportBackupData exportBackupData = new ExportBackupData();
    private final BackupExporter backupExporter;
    private File backupFile;
    private boolean needed;

    public ExportBackupWizard() {
        this.setFirstPage(new FirstWizardPage(this.exportBackupData));
        this.backupExporter = new BackupExporter();
        this.needed = this.backupExporter.isBackupNeeded();
    }

    @Override
    protected void finishing() {
        this.backupFile = this.createBackupFile();
        super.finishing();
    }

    @Override
    protected void finish(ProgressMonitor monitor) throws Exception {
        this.backupExporter.exportBackup(this.backupFile);
    }

    @Override
    protected void preFinished() {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setHeaderText("The backup was successfully created!");
        String text = String.format("File: %3$s\nDirectory: %2$s\n\nYou should not lose this file!\n\nDo not forget to properly unmount the device, if this is an external device:\nUse your operating system's \"Safely remove\" feature!", this.backupFile.getPath(), this.backupFile.getParentFile().getPath(), this.backupFile.getName());
        Text contentText = new Text(text);
        HBox contentTextContainer = new HBox();
        contentTextContainer.getChildren().add((Object)contentText);
        GridPane.setMargin((Node)contentText, (Insets)new Insets(8.0));
        alert.getDialogPane().setContent((Node)contentTextContainer);
        alert.showAndWait();
        super.preFinished();
    }

    private File createBackupFile() {
        File directory = this.exportBackupData.getExportBackupDirectory();
        Objects.requireNonNull(directory, "exportBackupData.exportBackupDirectory");
        String dateString = String.format("%1$tY-%1$tm-%1$td_%1$tH-%1$tM-%1$tS", DateUtil.now());
        String fileName = String.format("%s%s%s", "backup_", dateString, ".subshare");
        File backupFile = OioFileFactory.createFile((File)directory, (String[])new String[]{fileName});
        return backupFile;
    }

    @Override
    public String getTitle() {
        return Messages.getString("ExportBackupWizard.title");
    }

    public boolean isNeeded() {
        return this.needed;
    }
}

