/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.pgp.imp.fromserver;

import co.codewizards.cloudstore.core.io.IByteArrayOutputStream;
import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.IOutputStream;
import co.codewizards.cloudstore.ls.client.util.ByteArrayInputStreamLs;
import co.codewizards.cloudstore.ls.client.util.ByteArrayOutputStreamLs;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javafx.collections.SetChangeListener;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.scene.control.TreeItem;
import javafx.scene.text.Text;
import org.subshare.core.pgp.ImportKeysResult;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpKeyId;
import org.subshare.core.pgp.TempImportKeysResult;
import org.subshare.core.pgp.transport.PgpTransport;
import org.subshare.core.pgp.transport.PgpTransportFactory;
import org.subshare.core.server.Server;
import org.subshare.gui.concurrent.SsTask;
import org.subshare.gui.ls.PgpLs;
import org.subshare.gui.ls.PgpTransportFactoryRegistryLs;
import org.subshare.gui.ls.ServerRegistryLs;
import org.subshare.gui.pgp.imp.fromserver.ImportPgpKeyFromServerData;
import org.subshare.gui.pgp.imp.fromserver.Messages;
import org.subshare.gui.pgp.keytree.PgpKeyPgpKeyTreeItem;
import org.subshare.gui.pgp.keytree.PgpKeyTreeItem;
import org.subshare.gui.pgp.keytree.PgpKeyTreePane;
import org.subshare.gui.pgp.keytree.SimpleRootPgpKeyTreeItem;
import org.subshare.gui.util.FxmlUtil;
import org.subshare.gui.util.PlatformUtil;
import org.subshare.gui.wizard.WizardPageContentGridPane;

public class SearchResultPane
extends WizardPageContentGridPane {
    private final ImportPgpKeyFromServerData importPgpKeyFromServerData;
    @FXML
    private Text headerText;
    @FXML
    private PgpKeyTreePane pgpKeyTreePane;

    public SearchResultPane(final ImportPgpKeyFromServerData importPgpKeyFromServerData) {
        this.importPgpKeyFromServerData = Objects.requireNonNull(importPgpKeyFromServerData, "importPgpKeyFromServerData");
        FxmlUtil.loadDynamicComponentFxml(SearchResultPane.class, this);
        this.pgpKeyTreePane.getCheckBoxVisibleForPgpKeyTreeItemClasses().add(PgpKeyPgpKeyTreeItem.class);
        this.pgpKeyTreePane.getCheckedTreeItems().addListener(new SetChangeListener<PgpKeyTreeItem<?>>(){

            public void onChanged(SetChangeListener.Change<? extends PgpKeyTreeItem<?>> change) {
                PgpKeyTreeItem elementRemoved;
                PgpKeyTreeItem elementAdded = (PgpKeyTreeItem)((Object)change.getElementAdded());
                if (elementAdded instanceof PgpKeyPgpKeyTreeItem) {
                    importPgpKeyFromServerData.getSelectedPgpKeyIds().add((Object)((PgpKeyPgpKeyTreeItem)elementAdded).getPgpKey().getPgpKeyId());
                }
                if ((elementRemoved = (PgpKeyTreeItem)((Object)change.getElementRemoved())) instanceof PgpKeyPgpKeyTreeItem) {
                    importPgpKeyFromServerData.getSelectedPgpKeyIds().remove((Object)((PgpKeyPgpKeyTreeItem)elementRemoved).getPgpKey().getPgpKeyId());
                }
            }
        });
        importPgpKeyFromServerData.getSelectedPgpKeyIds().addListener(observable -> this.updateComplete());
    }

    public void searchAsync() {
        PlatformUtil.assertFxApplicationThread();
        this.onSearchStart();
        final String queryString = this.importPgpKeyFromServerData.getQueryString();
        new Service<TempImportKeysResult>(){

            protected Task<TempImportKeysResult> createTask() {
                return new SsTask<TempImportKeysResult>(){

                    protected TempImportKeysResult call() throws Exception {
                        Pgp pgp = PgpLs.getPgpOrFail();
                        TempImportKeysResult tempImportKeysResult = null;
                        IByteArrayOutputStream bout = ByteArrayOutputStreamLs.create();
                        List servers = ServerRegistryLs.getServerRegistry().getServers();
                        for (Server server : servers) {
                            URL serverUrl = server.getUrl();
                            PgpTransportFactory pgpTransportFactory = PgpTransportFactoryRegistryLs.getPgpTransportFactoryRegistry().getPgpTransportFactoryOrFail(serverUrl);
                            PgpTransport pgpTransport = pgpTransportFactory.createPgpTransport(serverUrl);
                            try {
                                bout.reset();
                                pgpTransport.exportPublicKeysMatchingQuery(queryString, (IOutputStream)bout);
                                if (tempImportKeysResult == null) {
                                    tempImportKeysResult = pgp.importKeysTemporarily((IInputStream)ByteArrayInputStreamLs.create((IByteArrayOutputStream)bout));
                                    continue;
                                }
                                ImportKeysResult importKeysResult = tempImportKeysResult.getTempPgp().importKeys((IInputStream)ByteArrayInputStreamLs.create((IByteArrayOutputStream)bout));
                                SearchResultPane.this.mergeImportKeysResult(tempImportKeysResult, importKeysResult);
                            }
                            finally {
                                if (pgpTransport == null) continue;
                                pgpTransport.close();
                            }
                        }
                        return tempImportKeysResult;
                    }

                    protected void succeeded() {
                        TempImportKeysResult tempImportKeysResult;
                        try {
                            tempImportKeysResult = (TempImportKeysResult)this.get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                        SearchResultPane.this.onSearchDone(tempImportKeysResult);
                    }
                };
            }
        }.start();
    }

    private void mergeImportKeysResult(TempImportKeysResult destTempImportKeysResult, ImportKeysResult srcImportKeysResult) {
        Map destPgpKeyId2ImportedMasterKey = destTempImportKeysResult.getImportKeysResult().getPgpKeyId2ImportedMasterKey();
        Map srcPgpKeyId2ImportedMasterKey = srcImportKeysResult.getPgpKeyId2ImportedMasterKey();
        for (ImportKeysResult.ImportedMasterKey srcImportedMasterKey : srcPgpKeyId2ImportedMasterKey.values()) {
            PgpKeyId masterKeyId = srcImportedMasterKey.getPgpKeyId();
            ImportKeysResult.ImportedMasterKey destImportedMasterKey = (ImportKeysResult.ImportedMasterKey)destPgpKeyId2ImportedMasterKey.get(masterKeyId);
            if (destImportedMasterKey == null) {
                destPgpKeyId2ImportedMasterKey.put(masterKeyId, srcImportedMasterKey);
                continue;
            }
            for (ImportKeysResult.ImportedSubKey srcImportedSubKey : srcImportedMasterKey.getPgpKeyId2ImportedSubKey().values()) {
                PgpKeyId subKeyId = srcImportedSubKey.getPgpKeyId();
                destImportedMasterKey.getPgpKeyId2ImportedSubKey().put(subKeyId, srcImportedSubKey);
            }
        }
    }

    protected TempImportKeysResult getTempImportKeysResult() {
        PlatformUtil.assertFxApplicationThread();
        return this.importPgpKeyFromServerData.getTempImportKeysResult();
    }

    protected void setTempImportKeysResult(TempImportKeysResult tempImportKeysResult) {
        PlatformUtil.assertFxApplicationThread();
        this.importPgpKeyFromServerData.setTempImportKeysResult(tempImportKeysResult);
        this.pgpKeyTreePane.setVisible(tempImportKeysResult != null && !tempImportKeysResult.getImportKeysResult().getPgpKeyId2ImportedMasterKey().isEmpty());
        this.pgpKeyTreePane.getTreeTableView().setRoot(null);
        this.pgpKeyTreePane.setPgp(tempImportKeysResult == null ? null : tempImportKeysResult.getTempPgp());
        if (tempImportKeysResult != null) {
            SimpleRootPgpKeyTreeItem root = new SimpleRootPgpKeyTreeItem(this.pgpKeyTreePane);
            Pgp tempPgp = tempImportKeysResult.getTempPgp();
            for (ImportKeysResult.ImportedMasterKey importedMasterKey : tempImportKeysResult.getImportKeysResult().getPgpKeyId2ImportedMasterKey().values()) {
                PgpKeyId pgpKeyId = importedMasterKey.getPgpKeyId();
                PgpKey pgpKey = tempPgp.getPgpKey(pgpKeyId);
                Objects.requireNonNull(pgpKey, String.format("tempPgp.getPgpKey(%s)", pgpKeyId));
                PgpKeyPgpKeyTreeItem ti = new PgpKeyPgpKeyTreeItem(pgpKey);
                root.getChildren().add((Object)ti);
                if (!this.importPgpKeyFromServerData.getSelectedPgpKeyIds().contains((Object)pgpKeyId)) continue;
                ti.setChecked(true);
            }
            this.pgpKeyTreePane.getTreeTableView().setRoot((TreeItem)root);
        }
        this.updateComplete();
    }

    protected void onSearchStart() {
        PlatformUtil.assertFxApplicationThread();
        this.headerText.setText(String.format(Messages.getString("SearchResultPane.headerText[searching].text"), this.importPgpKeyFromServerData.getQueryString()));
        this.setTempImportKeysResult(null);
    }

    protected void onSearchDone(TempImportKeysResult tempImportKeysResult) {
        PlatformUtil.assertFxApplicationThread();
        if (tempImportKeysResult.getImportKeysResult().getPgpKeyId2ImportedMasterKey().isEmpty()) {
            this.headerText.setText(String.format(Messages.getString("SearchResultPane.headerText[notFound].text"), this.importPgpKeyFromServerData.getQueryString()));
        } else {
            this.headerText.setText(String.format(Messages.getString("SearchResultPane.headerText[found].text"), this.importPgpKeyFromServerData.getQueryString()));
        }
        this.setTempImportKeysResult(tempImportKeysResult);
    }

    @Override
    protected boolean isComplete() {
        return !this.importPgpKeyFromServerData.getSelectedPgpKeyIds().isEmpty();
    }
}

