/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.crypto;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.reflect.Constructor;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedAsymmetricBlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.RIPEMD128Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.RIPEMD256Digest;
import org.bouncycastle.crypto.digests.RIPEMD320Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA224Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.digests.WhirlpoolDigest;
import org.bouncycastle.crypto.encodings.ISO9796d1Encoding;
import org.bouncycastle.crypto.encodings.OAEPEncoding;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.engines.AESLightEngine;
import org.bouncycastle.crypto.engines.BlowfishEngine;
import org.bouncycastle.crypto.engines.CAST5Engine;
import org.bouncycastle.crypto.engines.CAST6Engine;
import org.bouncycastle.crypto.engines.CamelliaEngine;
import org.bouncycastle.crypto.engines.CamelliaLightEngine;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.ElGamalEngine;
import org.bouncycastle.crypto.engines.GOST28147Engine;
import org.bouncycastle.crypto.engines.Grain128Engine;
import org.bouncycastle.crypto.engines.Grainv1Engine;
import org.bouncycastle.crypto.engines.HC128Engine;
import org.bouncycastle.crypto.engines.HC256Engine;
import org.bouncycastle.crypto.engines.ISAACEngine;
import org.bouncycastle.crypto.engines.NaccacheSternEngine;
import org.bouncycastle.crypto.engines.NoekeonEngine;
import org.bouncycastle.crypto.engines.NullEngine;
import org.bouncycastle.crypto.engines.RC2Engine;
import org.bouncycastle.crypto.engines.RC4Engine;
import org.bouncycastle.crypto.engines.RC532Engine;
import org.bouncycastle.crypto.engines.RC564Engine;
import org.bouncycastle.crypto.engines.RC6Engine;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.engines.RijndaelEngine;
import org.bouncycastle.crypto.engines.SEEDEngine;
import org.bouncycastle.crypto.engines.Salsa20Engine;
import org.bouncycastle.crypto.engines.SerpentEngine;
import org.bouncycastle.crypto.engines.SkipjackEngine;
import org.bouncycastle.crypto.engines.TEAEngine;
import org.bouncycastle.crypto.engines.TwofishEngine;
import org.bouncycastle.crypto.engines.XTEAEngine;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.CCMBlockCipher;
import org.bouncycastle.crypto.modes.CTSBlockCipher;
import org.bouncycastle.crypto.modes.EAXBlockCipher;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.modes.GOFBBlockCipher;
import org.bouncycastle.crypto.modes.SICBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.ISO10126d2Padding;
import org.bouncycastle.crypto.paddings.ISO7816d4Padding;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.paddings.TBCPadding;
import org.bouncycastle.crypto.paddings.X923Padding;
import org.bouncycastle.crypto.paddings.ZeroBytePadding;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.crypto.AsymmetricCipherKeyPairGeneratorFactory;
import org.subshare.crypto.Cipher;
import org.subshare.crypto.CipherEngineType;
import org.subshare.crypto.MACCalculator;
import org.subshare.crypto.MACCalculatorFactory;
import org.subshare.crypto.SecretKeyGenerator;
import org.subshare.crypto.internal.asymmetric.AsymmetricBlockCipherImpl;
import org.subshare.crypto.internal.asymmetric.keypairgenerator.DHBasicKeyPairGeneratorFactory;
import org.subshare.crypto.internal.asymmetric.keypairgenerator.DSAKeyPairGeneratorFactory;
import org.subshare.crypto.internal.asymmetric.keypairgenerator.ElGamalKeyPairGeneratorFactory;
import org.subshare.crypto.internal.asymmetric.keypairgenerator.GOST3410KeyPairGeneratorFactory;
import org.subshare.crypto.internal.asymmetric.keypairgenerator.NaccacheSternKeyPairGeneratorFactory;
import org.subshare.crypto.internal.asymmetric.keypairgenerator.RSAKeyPairGeneratorFactory;
import org.subshare.crypto.internal.mac.MACCalculatorFactoryImpl;
import org.subshare.crypto.internal.sign.GenericSigner;
import org.subshare.crypto.internal.symmetric.AEADBlockCipherImpl;
import org.subshare.crypto.internal.symmetric.BufferedBlockCipherImpl;
import org.subshare.crypto.internal.symmetric.SecretKeyGeneratorImpl;
import org.subshare.crypto.internal.symmetric.StreamCipherImpl;
import org.subshare.crypto.internal.symmetric.mode.C4jCBCCTSBlockCipher;
import org.subshare.crypto.internal.symmetric.mode.C4jCFBBlockCipher;
import org.subshare.crypto.internal.symmetric.mode.C4jOFBBlockCipher;

public final class CryptoRegistry {
    private static final Logger logger = LoggerFactory.getLogger(CryptoRegistry.class);
    private static final CryptoRegistry instance = new CryptoRegistry();
    private final Map<String, Class<? extends AsymmetricBlockCipher>> algorithmName2asymmetricBlockCipherEngineClass = new HashMap<String, Class<? extends AsymmetricBlockCipher>>();
    private final Map<String, Class<? extends BlockCipher>> algorithmName2blockCipherEngineClass = new HashMap<String, Class<? extends BlockCipher>>();
    private final Map<String, Class<? extends StreamCipher>> algorithmName2streamCipherEngineClass = new HashMap<String, Class<? extends StreamCipher>>();
    private final Map<String, Class<? extends BlockCipher>> modeName2blockCipherModeClass = new HashMap<String, Class<? extends BlockCipher>>();
    private final Map<String, Class<? extends BufferedBlockCipher>> modeName2bufferedBlockCipherModeClass = new HashMap<String, Class<? extends BufferedBlockCipher>>();
    private final Map<String, Class<? extends AEADBlockCipher>> modeName2aeadBlockCipherModeClass = new HashMap<String, Class<? extends AEADBlockCipher>>();
    private final Map<String, Class<? extends BlockCipherPadding>> paddingName2blockCipherPaddingClass = new HashMap<String, Class<? extends BlockCipherPadding>>();
    private final Map<String, Class<? extends AsymmetricBlockCipher>> paddingName2asymmetricBlockCipherPaddingClass = new HashMap<String, Class<? extends AsymmetricBlockCipher>>();
    private final Map<String, AsymmetricCipherKeyPairGeneratorFactory> algorithmName2asymmetricCipherKeyPairGeneratorFactory = new HashMap<String, AsymmetricCipherKeyPairGeneratorFactory>();
    private final Map<String, Class<? extends Digest>> digestName2digestClass = new HashMap<String, Class<? extends Digest>>();
    private final Map<String, Set<String>> blackListedCipherEngine2Modes = new HashMap<String, Set<String>>();
    private final Map<String, MACCalculatorFactory> macName2macCalculatorFactory;

    public static CryptoRegistry getInstance() {
        return instance;
    }

    private void registerBlockCipherEngineClass(Class<? extends BlockCipher> engineClass) {
        BlockCipher engine = this.newInstance(engineClass);
        String algorithmName = engine.getAlgorithmName();
        logger.trace("registerSymmetricEngineClass: algorithmName=\"{}\" engineClass=\"{}\"", (Object)algorithmName, (Object)engineClass.getName());
        this.algorithmName2blockCipherEngineClass.put(algorithmName.toUpperCase(Locale.ENGLISH), engineClass);
    }

    private void registerBlockCipherEngineClass(String algorithmName, Class<? extends BlockCipher> engineClass) {
        this.newInstance(engineClass);
        logger.trace("registerSymmetricEngineClass: algorithmName=\"{}\" engineClass=\"{}\"", (Object)algorithmName, (Object)engineClass.getName());
        this.algorithmName2blockCipherEngineClass.put(algorithmName.toUpperCase(Locale.ENGLISH), engineClass);
    }

    private void registerAsymmetricBlockCipherEngineClass(String algorithmName, Class<? extends AsymmetricBlockCipher> engineClass) {
        this.newInstance(engineClass);
        logger.trace("registerAsymmetricEngineClass: algorithmName=\"{}\" engineClass=\"{}\"", (Object)algorithmName, (Object)engineClass.getName());
        this.algorithmName2asymmetricBlockCipherEngineClass.put(algorithmName.toUpperCase(Locale.ENGLISH), engineClass);
    }

    private void registerStreamCipherEngineClass(Class<? extends StreamCipher> engineClass) {
        StreamCipher engine = this.newInstance(engineClass);
        String algorithmName = engine.getAlgorithmName();
        this._registerStreamCipherEngineClass(algorithmName, engineClass);
    }

    private void registerStreamCipherEngineClass(String algorithmName, Class<? extends StreamCipher> engineClass) {
        this.newInstance(engineClass);
        this._registerStreamCipherEngineClass(algorithmName, engineClass);
    }

    private void _registerStreamCipherEngineClass(String algorithmName, Class<? extends StreamCipher> engineClass) {
        if (algorithmName == null) {
            throw new IllegalArgumentException("algorithmName == null");
        }
        if (engineClass == null) {
            throw new IllegalArgumentException("engineClass == null");
        }
        logger.trace("registerSymmetricEngineClass: algorithmName=\"{}\" engineClass=\"{}\"", (Object)algorithmName, (Object)engineClass.getName());
        this.algorithmName2streamCipherEngineClass.put(algorithmName.toUpperCase(Locale.ENGLISH), engineClass);
    }

    private void registerBlockCipherMode(String modeName, Class<? extends BlockCipher> modeClass) {
        logger.trace("registerBlockCipherMode: modeName=\"{}\" modeClass=\"{}\"", (Object)modeName, (Object)modeClass.getName());
        this.modeName2blockCipherModeClass.put(modeName.toUpperCase(Locale.ENGLISH), modeClass);
    }

    private void registerBufferedBlockCipherMode(String modeName, Class<? extends BufferedBlockCipher> modeClass) {
        logger.trace("registerBufferedBlockCipherMode: modeName=\"{}\" modeClass=\"{}\"", (Object)modeName, (Object)modeClass.getName());
        this.modeName2bufferedBlockCipherModeClass.put(modeName.toUpperCase(Locale.ENGLISH), modeClass);
    }

    private void registerAEADBlockCipherMode(String modeName, Class<? extends AEADBlockCipher> modeClass) {
        logger.trace("registerAEADBlockCipherMode: modeName=\"{}\" modeClass=\"{}\"", (Object)modeName, (Object)modeClass.getName());
        this.modeName2aeadBlockCipherModeClass.put(modeName.toUpperCase(Locale.ENGLISH), modeClass);
    }

    private void registerBlockCipherPadding(Class<? extends BlockCipherPadding> paddingClass) {
        BlockCipherPadding padding = this.newInstance(paddingClass);
        String paddingName = padding.getPaddingName();
        logger.debug("registerBlockCipherPadding: paddingName=\"{}\" paddingClass=\"{}\"", (Object)paddingName, (Object)paddingClass.getName());
        this.paddingName2blockCipherPaddingClass.put(paddingName.toUpperCase(Locale.ENGLISH), paddingClass);
        this.paddingName2blockCipherPaddingClass.put((paddingName + "Padding").toUpperCase(Locale.ENGLISH), paddingClass);
    }

    private void registerBlockCipherPadding(String paddingName, Class<? extends BlockCipherPadding> paddingClass) {
        this.newInstance(paddingClass);
        logger.trace("registerBlockCipherPadding: paddingName=\"{}\" paddingClass=\"{}\"", (Object)paddingName, (Object)paddingClass.getName());
        this.paddingName2blockCipherPaddingClass.put(paddingName.toUpperCase(Locale.ENGLISH), paddingClass);
        this.paddingName2blockCipherPaddingClass.put((paddingName + "Padding").toUpperCase(Locale.ENGLISH), paddingClass);
    }

    private void registerAsymmetricBlockCipherPadding(String paddingName, Class<? extends AsymmetricBlockCipher> paddingClass) {
        logger.trace("registerAsymmetricBlockCipherPadding: paddingName=\"{}\" paddingClass=\"{}\"", (Object)paddingName, (Object)paddingClass.getName());
        this.paddingName2asymmetricBlockCipherPaddingClass.put(paddingName.toUpperCase(Locale.ENGLISH), paddingClass);
        this.paddingName2asymmetricBlockCipherPaddingClass.put((paddingName + "Padding").toUpperCase(Locale.ENGLISH), paddingClass);
    }

    private void registerAsymmetricCipherKeyPairGeneratorFactory(AsymmetricCipherKeyPairGeneratorFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory == null");
        }
        if (factory.getAlgorithmName() == null) {
            throw new IllegalArgumentException("factory.getAlgorithmName() == null");
        }
        logger.trace("registerAsymmetricCipherKeyPairGeneratorFactory: algorithmName=\"{}\" factoryClass=\"{}\"", (Object)factory.getAlgorithmName(), (Object)factory.getClass().getName());
        this.algorithmName2asymmetricCipherKeyPairGeneratorFactory.put(factory.getAlgorithmName(), factory);
    }

    private void registerDigest(Class<? extends Digest> digestClass) {
        if (digestClass == null) {
            throw new IllegalArgumentException("digestClass == null");
        }
        String digestClassName = digestClass.getSimpleName();
        String suffix = "Digest";
        if (!digestClassName.endsWith("Digest")) {
            throw new IllegalArgumentException(String.format("digestClass name does not end on '%s'!", "Digest"));
        }
        String digestName = digestClassName.substring(0, digestClassName.length() - "Digest".length());
        this.registerDigest(digestName, digestClass);
    }

    private void registerDigest(String digestName, Class<? extends Digest> digestClass) {
        if (digestName == null) {
            throw new IllegalArgumentException("digestName == null");
        }
        if (digestClass == null) {
            throw new IllegalArgumentException("digestClass == null");
        }
        this.digestName2digestClass.put(digestName, digestClass);
    }

    private CryptoRegistry() {
        int i;
        HashSet<String> modes = new HashSet<String>();
        this.blackListedCipherEngine2Modes.put("AES.FAST", modes);
        modes.add("GOFB");
        modes = new HashSet();
        this.blackListedCipherEngine2Modes.put("AES.LIGHT", modes);
        modes.add("GOFB");
        modes = new HashSet();
        this.blackListedCipherEngine2Modes.put("AES", modes);
        modes.add("GOFB");
        modes = new HashSet();
        this.blackListedCipherEngine2Modes.put("BLOWFISH", modes);
        modes.add("CCM");
        modes.add("GCM");
        modes = new HashSet();
        this.blackListedCipherEngine2Modes.put("CAMELLIA.LIGHT", modes);
        modes.add("GOFB");
        modes = new HashSet();
        this.blackListedCipherEngine2Modes.put("CAMELLIA", modes);
        modes.add("GOFB");
        modes = new HashSet();
        this.blackListedCipherEngine2Modes.put("CAST5", modes);
        modes.add("CCM");
        modes.add("GCM");
        modes = new HashSet();
        this.blackListedCipherEngine2Modes.put("CAST6", modes);
        modes.add("GOFB");
        modes = new HashSet();
        this.blackListedCipherEngine2Modes.put("DES", modes);
        modes.add("CCM");
        modes.add("GCM");
        modes = new HashSet();
        this.blackListedCipherEngine2Modes.put("DESEDE", modes);
        modes.add("CCM");
        modes.add("GCM");
        modes = new HashSet();
        this.blackListedCipherEngine2Modes.put("GOST28147", modes);
        modes.add("CCM");
        modes.add("GCM");
        modes = new HashSet();
        this.blackListedCipherEngine2Modes.put("NOEKEON", modes);
        modes.add("GOFB");
        modes = new HashSet();
        this.blackListedCipherEngine2Modes.put("NULL", modes);
        modes.add("CCM");
        modes.add("GCM");
        modes.add("EAX");
        modes.add("GOFB");
        modes = new HashSet();
        this.blackListedCipherEngine2Modes.put("RC2", modes);
        modes.add("CCM");
        modes.add("GCM");
        modes = new HashSet();
        this.blackListedCipherEngine2Modes.put("RC5-32", modes);
        modes.add("CCM");
        modes.add("GCM");
        modes = new HashSet();
        this.blackListedCipherEngine2Modes.put("RC5-64", modes);
        modes.add("GOFB");
        modes = new HashSet();
        this.blackListedCipherEngine2Modes.put("RC6", modes);
        modes.add("GOFB");
        modes = new HashSet();
        this.blackListedCipherEngine2Modes.put("RIJNDAEL", modes);
        modes.add("GOFB");
        modes = new HashSet();
        this.blackListedCipherEngine2Modes.put("SEED", modes);
        modes.add("GOFB");
        modes = new HashSet();
        this.blackListedCipherEngine2Modes.put("SERPENT", modes);
        modes.add("GOFB");
        modes = new HashSet();
        this.blackListedCipherEngine2Modes.put("SKIPJACK", modes);
        modes.add("CCM");
        modes.add("GCM");
        modes = new HashSet();
        this.blackListedCipherEngine2Modes.put("TEA", modes);
        modes.add("CCM");
        modes.add("GCM");
        modes = new HashSet();
        this.blackListedCipherEngine2Modes.put("TWOFISH", modes);
        modes.add("GOFB");
        modes = new HashSet();
        this.blackListedCipherEngine2Modes.put("XTEA", modes);
        modes.add("CCM");
        modes.add("GCM");
        this.macName2macCalculatorFactory = new HashMap<String, MACCalculatorFactory>();
        this.registerMACCalculatorFactory("DES", new MACCalculatorFactoryImpl.DES());
        this.registerMACCalculatorFactory("DESMAC", new MACCalculatorFactoryImpl.DES());
        this.registerMACCalculatorFactory("DES64", new MACCalculatorFactoryImpl.DES64());
        this.registerMACCalculatorFactory("DES64MAC", new MACCalculatorFactoryImpl.DES64());
        this.registerMACCalculatorFactory("DES/CFB8", new MACCalculatorFactoryImpl.DESCFB8());
        this.registerMACCalculatorFactory("DESMAC/CFB8", new MACCalculatorFactoryImpl.DESCFB8());
        this.registerMACCalculatorFactory("DESWITHISO9797", new MACCalculatorFactoryImpl.DES9797Alg3());
        this.registerMACCalculatorFactory("DESWITHISO9797MAC", new MACCalculatorFactoryImpl.DES9797Alg3());
        this.registerMACCalculatorFactory("ISO9797ALG3", new MACCalculatorFactoryImpl.DES9797Alg3());
        this.registerMACCalculatorFactory("ISO9797ALG3MAC", new MACCalculatorFactoryImpl.DES9797Alg3());
        this.registerMACCalculatorFactory("ISO9797ALG3WITHISO7816-4PADDING", new MACCalculatorFactoryImpl.DES9797Alg3with7816d4());
        this.registerMACCalculatorFactory("ISO9797ALG3MACWITHISO7816-4PADDING", new MACCalculatorFactoryImpl.DES9797Alg3with7816d4());
        this.registerMACCalculatorFactory("RC2", new MACCalculatorFactoryImpl.RC2());
        this.registerMACCalculatorFactory("RC2MAC", new MACCalculatorFactoryImpl.RC2());
        this.registerMACCalculatorFactory("RC2/CFB8", new MACCalculatorFactoryImpl.RC2CFB8());
        this.registerMACCalculatorFactory("RC2MAC/CFB8", new MACCalculatorFactoryImpl.RC2CFB8());
        this.registerMACCalculatorFactory("GOST28147", new MACCalculatorFactoryImpl.GOST28147());
        this.registerMACCalculatorFactory("GOST28147MAC", new MACCalculatorFactoryImpl.GOST28147());
        this.registerDeprecatedMACCalculatorFactories();
        this.registerMACCalculatorFactory("HMACMD2", new MACCalculatorFactoryImpl.MD2());
        this.registerMACCalculatorFactory("HMAC-MD2", new MACCalculatorFactoryImpl.MD2());
        this.registerMACCalculatorFactory("HMAC/MD2", new MACCalculatorFactoryImpl.MD2());
        this.registerMACCalculatorFactory("HMACMD4", new MACCalculatorFactoryImpl.MD4());
        this.registerMACCalculatorFactory("HMAC-MD4", new MACCalculatorFactoryImpl.MD4());
        this.registerMACCalculatorFactory("HMAC/MD4", new MACCalculatorFactoryImpl.MD4());
        this.registerMACCalculatorFactory("HMACMD5", new MACCalculatorFactoryImpl.MD5());
        this.registerMACCalculatorFactory("HMAC-MD5", new MACCalculatorFactoryImpl.MD5());
        this.registerMACCalculatorFactory("HMAC/MD5", new MACCalculatorFactoryImpl.MD5());
        this.registerMACCalculatorFactory("HMACSHA1", new MACCalculatorFactoryImpl.SHA1());
        this.registerMACCalculatorFactory("HMAC-SHA1", new MACCalculatorFactoryImpl.SHA1());
        this.registerMACCalculatorFactory("HMAC/SHA1", new MACCalculatorFactoryImpl.SHA1());
        this.registerMACCalculatorFactory("HMACSHA224", new MACCalculatorFactoryImpl.SHA224());
        this.registerMACCalculatorFactory("HMAC-SHA224", new MACCalculatorFactoryImpl.SHA224());
        this.registerMACCalculatorFactory("HMAC/SHA224", new MACCalculatorFactoryImpl.SHA224());
        this.registerMACCalculatorFactory("HMACSHA256", new MACCalculatorFactoryImpl.SHA256());
        this.registerMACCalculatorFactory("HMAC-SHA256", new MACCalculatorFactoryImpl.SHA256());
        this.registerMACCalculatorFactory("HMAC/SHA256", new MACCalculatorFactoryImpl.SHA256());
        this.registerMACCalculatorFactory("HMACSHA384", new MACCalculatorFactoryImpl.SHA384());
        this.registerMACCalculatorFactory("HMAC-SHA384", new MACCalculatorFactoryImpl.SHA384());
        this.registerMACCalculatorFactory("HMAC/SHA384", new MACCalculatorFactoryImpl.SHA384());
        this.registerMACCalculatorFactory("HMACSHA512", new MACCalculatorFactoryImpl.SHA512());
        this.registerMACCalculatorFactory("HMAC-SHA512", new MACCalculatorFactoryImpl.SHA512());
        this.registerMACCalculatorFactory("HMAC/SHA512", new MACCalculatorFactoryImpl.SHA512());
        this.registerMACCalculatorFactory("HMACRIPEMD128", new MACCalculatorFactoryImpl.RIPEMD128());
        this.registerMACCalculatorFactory("HMAC-RIPEMD128", new MACCalculatorFactoryImpl.RIPEMD128());
        this.registerMACCalculatorFactory("HMAC/RIPEMD128", new MACCalculatorFactoryImpl.RIPEMD128());
        this.registerMACCalculatorFactory("HMACRIPEMD160", new MACCalculatorFactoryImpl.RIPEMD160());
        this.registerMACCalculatorFactory("HMAC-RIPEMD160", new MACCalculatorFactoryImpl.RIPEMD160());
        this.registerMACCalculatorFactory("HMAC/RIPEMD160", new MACCalculatorFactoryImpl.RIPEMD160());
        this.registerMACCalculatorFactory("HMACTIGER", new MACCalculatorFactoryImpl.Tiger());
        this.registerMACCalculatorFactory("HMAC-TIGER", new MACCalculatorFactoryImpl.Tiger());
        this.registerMACCalculatorFactory("HMAC/TIGER", new MACCalculatorFactoryImpl.Tiger());
        this.registerAsymmetricBlockCipherEngineClass("ElGamal", ElGamalEngine.class);
        this.registerAsymmetricBlockCipherEngineClass("NaccacheStern", NaccacheSternEngine.class);
        this.registerAsymmetricBlockCipherEngineClass("RSA", RSABlindedEngine.class);
        this.registerBlockCipherEngineClass(AESEngine.class);
        this.registerBlockCipherEngineClass("AES.fast", AESFastEngine.class);
        this.registerBlockCipherEngineClass("AES.light", AESLightEngine.class);
        this.registerBlockCipherEngineClass(BlowfishEngine.class);
        this.registerBlockCipherEngineClass(CamelliaEngine.class);
        this.registerBlockCipherEngineClass("Camellia.light", CamelliaLightEngine.class);
        this.registerBlockCipherEngineClass(CAST5Engine.class);
        this.registerBlockCipherEngineClass(CAST6Engine.class);
        this.registerBlockCipherEngineClass(DESedeEngine.class);
        this.registerBlockCipherEngineClass(DESEngine.class);
        this.registerBlockCipherEngineClass(GOST28147Engine.class);
        this.registerBlockCipherEngineClass(NoekeonEngine.class);
        this.registerBlockCipherEngineClass(NullEngine.class);
        this.registerBlockCipherEngineClass(RC2Engine.class);
        this.registerBlockCipherEngineClass(RC532Engine.class);
        this.registerBlockCipherEngineClass(RC564Engine.class);
        this.registerBlockCipherEngineClass(RC6Engine.class);
        this.registerBlockCipherEngineClass(RijndaelEngine.class);
        this.registerBlockCipherEngineClass(SEEDEngine.class);
        this.registerBlockCipherEngineClass(SerpentEngine.class);
        this.registerBlockCipherEngineClass(SkipjackEngine.class);
        this.registerBlockCipherEngineClass(TEAEngine.class);
        this.registerBlockCipherEngineClass(TwofishEngine.class);
        this.registerBlockCipherEngineClass(XTEAEngine.class);
        this.registerStreamCipherEngineClass(Grain128Engine.class);
        this.registerStreamCipherEngineClass("GRAIN-V1", Grainv1Engine.class);
        this.registerStreamCipherEngineClass(HC128Engine.class);
        this.registerStreamCipherEngineClass(HC256Engine.class);
        this.registerStreamCipherEngineClass(ISAACEngine.class);
        this.registerStreamCipherEngineClass(RC4Engine.class);
        this.registerStreamCipherEngineClass(Salsa20Engine.class);
        this.registerBlockCipherMode("CBC", CBCBlockCipher.class);
        this.registerAEADBlockCipherMode("CCM", CCMBlockCipher.class);
        this.registerBlockCipherMode("CFB", C4jCFBBlockCipher.class);
        for (i = 1; i <= 32; ++i) {
            this.registerBlockCipherMode("CFB" + i * 8, C4jCFBBlockCipher.class);
        }
        this.registerBufferedBlockCipherMode("CTS", CTSBlockCipher.class);
        this.registerBufferedBlockCipherMode("CBC-CTS", C4jCBCCTSBlockCipher.class);
        this.registerAEADBlockCipherMode("EAX", EAXBlockCipher.class);
        this.registerAEADBlockCipherMode("GCM", GCMBlockCipher.class);
        this.registerBlockCipherMode("GOFB", GOFBBlockCipher.class);
        this.registerBlockCipherMode("OFB", C4jOFBBlockCipher.class);
        for (i = 1; i <= 32; ++i) {
            this.registerBlockCipherMode("OFB" + i * 8, C4jOFBBlockCipher.class);
        }
        this.registerBlockCipherMode("SIC", SICBlockCipher.class);
        this.testBlockCipherModes();
        this.registerBlockCipherPadding(ISO10126d2Padding.class);
        this.registerBlockCipherPadding("ISO10126", ISO10126d2Padding.class);
        this.registerBlockCipherPadding(ISO7816d4Padding.class);
        this.registerBlockCipherPadding(PKCS7Padding.class);
        this.registerBlockCipherPadding("PKCS5", PKCS7Padding.class);
        this.registerBlockCipherPadding(TBCPadding.class);
        this.registerBlockCipherPadding(X923Padding.class);
        this.registerBlockCipherPadding(ZeroBytePadding.class);
        this.registerAsymmetricBlockCipherPadding("ISO9796-1", ISO9796d1Encoding.class);
        this.registerAsymmetricBlockCipherPadding("OAEP", OAEPEncoding.class);
        this.registerAsymmetricBlockCipherPadding("OAEPWITHSHA1ANDMGF1", OAEPEncoding.class);
        this.registerAsymmetricBlockCipherPadding("PKCS1", PKCS1Encoding.class);
        this.testAsymmetricBlockCipherPaddings();
        this.registerAsymmetricCipherKeyPairGeneratorFactory(new DHBasicKeyPairGeneratorFactory());
        this.registerAsymmetricCipherKeyPairGeneratorFactory(new DSAKeyPairGeneratorFactory());
        this.registerAsymmetricCipherKeyPairGeneratorFactory(new ElGamalKeyPairGeneratorFactory());
        this.registerAsymmetricCipherKeyPairGeneratorFactory(new GOST3410KeyPairGeneratorFactory());
        this.registerAsymmetricCipherKeyPairGeneratorFactory(new NaccacheSternKeyPairGeneratorFactory());
        this.registerAsymmetricCipherKeyPairGeneratorFactory(new RSAKeyPairGeneratorFactory());
        this.registerDigest(MD5Digest.class);
        this.registerDigest(RIPEMD128Digest.class);
        this.registerDigest(RIPEMD160Digest.class);
        this.registerDigest(RIPEMD256Digest.class);
        this.registerDigest(RIPEMD320Digest.class);
        this.registerDigest(SHA1Digest.class);
        this.registerDigest(SHA224Digest.class);
        this.registerDigest(SHA256Digest.class);
        this.registerDigest(SHA384Digest.class);
        this.registerDigest(SHA512Digest.class);
        this.registerDigest(WhirlpoolDigest.class);
    }

    private void testAsymmetricBlockCipherPaddings() {
        AsymmetricBlockCipher engine = this.createAsymmetricBlockCipherEngine("RSA");
        if (engine == null) {
            throw new IllegalStateException("No engine!");
        }
        for (String paddingName : this.paddingName2asymmetricBlockCipherPaddingClass.keySet()) {
            this.createAsymmetricBlockCipherPadding(paddingName, engine);
        }
    }

    private void testBlockCipherModes() {
        BlockCipher engine8 = this.createBlockCipherEngine("Blowfish".toUpperCase(Locale.ENGLISH));
        if (engine8 == null) {
            throw new IllegalStateException("No 'Blowfish' engine!");
        }
        BlockCipher engine16 = this.createBlockCipherEngine("AES".toUpperCase(Locale.ENGLISH));
        if (engine16 == null) {
            throw new IllegalStateException("No 'AES' engine!");
        }
        for (String modeName : this.modeName2blockCipherModeClass.keySet()) {
            this.createBlockCipherMode(modeName, engine8);
        }
        for (String modeName : this.modeName2bufferedBlockCipherModeClass.keySet()) {
            this.createBufferedBlockCipherMode(modeName, engine8);
        }
        for (String modeName : this.modeName2aeadBlockCipherModeClass.keySet()) {
            this.createAEADBlockCipherMode(modeName, engine16);
        }
    }

    private <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private BlockCipher createBlockCipherEngine(String algorithmName) {
        Class<? extends BlockCipher> engineClass = this.algorithmName2blockCipherEngineClass.get(algorithmName);
        if (engineClass == null) {
            return null;
        }
        return this.newInstance(engineClass);
    }

    private AsymmetricBlockCipher createAsymmetricBlockCipherEngine(String algorithmName) {
        Class<? extends AsymmetricBlockCipher> engineClass = this.algorithmName2asymmetricBlockCipherEngineClass.get(algorithmName);
        if (engineClass == null) {
            return null;
        }
        return this.newInstance(engineClass);
    }

    private StreamCipher createStreamCipherEngine(String algorithmName) throws NoSuchAlgorithmException {
        Class<? extends StreamCipher> engineClass = this.algorithmName2streamCipherEngineClass.get(algorithmName);
        if (engineClass == null) {
            return null;
        }
        return this.newInstance(engineClass);
    }

    private BlockCipher createBlockCipherMode(String modeName, BlockCipher engine) {
        Class<? extends BlockCipher> modeClass = this.modeName2blockCipherModeClass.get(modeName);
        if (modeClass == null) {
            return null;
        }
        try {
            Constructor<? extends BlockCipher> c = modeClass.getConstructor(BlockCipher.class, String.class);
            return c.newInstance(engine, modeName);
        }
        catch (NoSuchMethodException x) {
            CryptoRegistry.silentlyIgnore();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            Constructor<? extends BlockCipher> c = modeClass.getConstructor(BlockCipher.class);
            return c.newInstance(engine);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void silentlyIgnore() {
    }

    private AEADBlockCipher createAEADBlockCipherMode(String modeName, BlockCipher engine) {
        Class<? extends AEADBlockCipher> modeClass = this.modeName2aeadBlockCipherModeClass.get(modeName);
        if (modeClass == null) {
            return null;
        }
        try {
            Constructor<? extends AEADBlockCipher> c = modeClass.getConstructor(BlockCipher.class);
            return c.newInstance(engine);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private BufferedBlockCipher createBufferedBlockCipherMode(String modeName, BlockCipher engine) {
        Class<? extends BufferedBlockCipher> modeClass = this.modeName2bufferedBlockCipherModeClass.get(modeName);
        if (modeClass == null) {
            return null;
        }
        try {
            Constructor<? extends BufferedBlockCipher> c = modeClass.getConstructor(BlockCipher.class);
            return c.newInstance(engine);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private BlockCipherPadding createBlockCipherPadding(String paddingName) {
        Class<? extends BlockCipherPadding> paddingClass = this.paddingName2blockCipherPaddingClass.get(paddingName);
        if (paddingClass == null) {
            return null;
        }
        return this.newInstance(paddingClass);
    }

    private Cipher createCipherForBlockCipherMode(String transformation, BlockCipher modeWithEngine, String engineName, String modeName, String paddingName) throws NoSuchPaddingException {
        if (paddingName.isEmpty() || "NOPADDING".equals(paddingName)) {
            return new BufferedBlockCipherImpl(transformation, new BufferedBlockCipher(modeWithEngine));
        }
        BlockCipherPadding padding = this.createBlockCipherPadding(paddingName);
        if (padding == null) {
            throw new NoSuchPaddingException("There is no block-cipher-padding class registed with the name \"" + paddingName + "\"!");
        }
        return new BufferedBlockCipherImpl(transformation, (BufferedBlockCipher)new PaddedBufferedBlockCipher(modeWithEngine, padding));
    }

    private Cipher createCipherForBlockCipherMode(String transformation, AEADBlockCipher modeWithEngine, String engineName, String modeName, String paddingName) throws NoSuchPaddingException {
        if (paddingName.isEmpty() || "NOPADDING".equals(paddingName)) {
            return new AEADBlockCipherImpl(transformation, modeWithEngine);
        }
        throw new NoSuchPaddingException("The AEAD-mode \"" + modeName + "\" does not support the padding \"" + paddingName + "\"! Padding must be \"NoPadding\" or an empty string!");
    }

    private Cipher createCipherForBlockCipherMode(String transformation, BufferedBlockCipher modeWithEngine, String engineName, String modeName, String paddingName) throws NoSuchPaddingException {
        if (paddingName.isEmpty() || "NOPADDING".equals(paddingName)) {
            return new BufferedBlockCipherImpl(transformation, modeWithEngine);
        }
        throw new NoSuchPaddingException("The block-cipher-mode \"" + modeName + "\" does not support the padding \"" + paddingName + "\"! Padding must be \"NoPadding\" or an empty string!");
    }

    private Cipher createCipherForBlockCipherEngine(String transformation, BlockCipher engine, String engineName, String modeName, String paddingName) throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (modeName.isEmpty() || "ECB".equals(modeName)) {
            return this.createCipherForBlockCipherMode(transformation, engine, engineName, modeName, paddingName);
        }
        BlockCipher mode = this.createBlockCipherMode(modeName, engine);
        if (mode != null) {
            return this.createCipherForBlockCipherMode(transformation, mode, engineName, modeName, paddingName);
        }
        mode = this.createBufferedBlockCipherMode(modeName, engine);
        if (mode != null) {
            return this.createCipherForBlockCipherMode(transformation, (BufferedBlockCipher)mode, engineName, modeName, paddingName);
        }
        mode = this.createAEADBlockCipherMode(modeName, engine);
        if (mode != null) {
            return this.createCipherForBlockCipherMode(transformation, (AEADBlockCipher)mode, engineName, modeName, paddingName);
        }
        throw new NoSuchAlgorithmException("There is no block-cipher-mode-class registered with the modeName \"" + modeName + "\"!");
    }

    private Cipher createCipherForStreamCipherMode(String transformation, StreamCipher modeWithEngine, String engineName, String modeName, String paddingName) throws NoSuchPaddingException {
        if (paddingName.isEmpty() || "NOPADDING".equals(paddingName)) {
            return new StreamCipherImpl(transformation, modeWithEngine);
        }
        throw new NoSuchPaddingException("The stream-cipher-mode \"" + modeName + "\" does not support the padding \"" + paddingName + "\"! Padding must be \"NoPadding\" or an empty string!");
    }

    private Cipher createCipherForStreamCipherEngine(String transformation, StreamCipher engine, String engineName, String modeName, String paddingName) throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (modeName.isEmpty() || "ECB".equals(modeName)) {
            return this.createCipherForStreamCipherMode(transformation, engine, engineName, modeName, paddingName);
        }
        throw new NoSuchAlgorithmException("The stream-cipher does not support the mode \"" + modeName + "\"! Only \"ECB\" or an empty string are allowed as mode!");
    }

    private AsymmetricBlockCipher createAsymmetricBlockCipherPadding(String paddingName, AsymmetricBlockCipher engine) {
        Class<? extends AsymmetricBlockCipher> paddingClass = this.paddingName2asymmetricBlockCipherPaddingClass.get(paddingName);
        if (paddingClass == null) {
            return null;
        }
        try {
            Constructor<? extends AsymmetricBlockCipher> c = paddingClass.getConstructor(AsymmetricBlockCipher.class);
            return c.newInstance(engine);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Cipher createCipherForAsymmetricBlockCipherMode(String transformation, AsymmetricBlockCipher modeWithEngine, String engineName, String modeName, String paddingName) throws NoSuchPaddingException {
        AsymmetricBlockCipher padding;
        if (paddingName.isEmpty() || "NOPADDING".equals(paddingName)) {
            padding = modeWithEngine;
        } else {
            padding = this.createAsymmetricBlockCipherPadding(paddingName, modeWithEngine);
            if (padding == null) {
                throw new NoSuchPaddingException("There is no asymmetric-block-cipher-padding registered with name \"" + paddingName + "\"!");
            }
        }
        return new AsymmetricBlockCipherImpl(transformation, new BufferedAsymmetricBlockCipher(padding));
    }

    private Cipher createCipherForAsymmetricBlockCipherEngine(String transformation, AsymmetricBlockCipher engine, String engineName, String modeName, String paddingName) throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (modeName.isEmpty() || "ECB".equals(modeName) || "NONE".equals(modeName)) {
            return this.createCipherForAsymmetricBlockCipherMode(transformation, engine, engineName, modeName, paddingName);
        }
        throw new NoSuchAlgorithmException("The asymmetric-block-cipher does not support the mode \"" + modeName + "\"! Only \"ECB\", \"NONE\" or an empty string are allowed as mode!");
    }

    private Digest createDigest(String digestName) {
        Class<? extends Digest> digestClass = this.digestName2digestClass.get(digestName);
        if (digestClass == null) {
            return null;
        }
        return this.newInstance(digestClass);
    }

    public Set<String> getSupportedCipherEngines(CipherEngineType cipherEngineType) {
        TreeSet<String> result = new TreeSet<String>();
        if (cipherEngineType == null || cipherEngineType == CipherEngineType.symmetricBlock) {
            result.addAll(this.algorithmName2blockCipherEngineClass.keySet());
        }
        if (cipherEngineType == null || cipherEngineType == CipherEngineType.symmetricStream) {
            result.addAll(this.algorithmName2streamCipherEngineClass.keySet());
        }
        if (cipherEngineType == null || cipherEngineType == CipherEngineType.asymmetricBlock) {
            result.addAll(this.algorithmName2asymmetricBlockCipherEngineClass.keySet());
        }
        return Collections.unmodifiableSortedSet(result);
    }

    public Set<String> getSupportedDigests() {
        return Collections.unmodifiableSortedSet(new TreeSet<String>(this.digestName2digestClass.keySet()));
    }

    public Set<String> getSupportedCipherModes(String cipherEngine) {
        Set<String> blackListedModes;
        if (cipherEngine != null) {
            cipherEngine = cipherEngine.toUpperCase(Locale.ENGLISH);
        }
        TreeSet<String> result = new TreeSet<String>();
        if (cipherEngine == null || this.algorithmName2blockCipherEngineClass.containsKey(cipherEngine)) {
            result.add("");
            result.add("ECB");
            result.addAll(this.modeName2aeadBlockCipherModeClass.keySet());
            result.addAll(this.modeName2blockCipherModeClass.keySet());
            result.addAll(this.modeName2bufferedBlockCipherModeClass.keySet());
        }
        if (cipherEngine == null || this.algorithmName2streamCipherEngineClass.containsKey(cipherEngine)) {
            result.add("");
            result.add("ECB");
        }
        if (cipherEngine == null || this.algorithmName2asymmetricBlockCipherEngineClass.containsKey(cipherEngine)) {
            result.add("");
            result.add("ECB");
        }
        if ((blackListedModes = this.blackListedCipherEngine2Modes.get(cipherEngine)) != null) {
            result.removeAll(blackListedModes);
        }
        return Collections.unmodifiableSortedSet(result);
    }

    public Set<String> getSupportedCipherPaddings(CipherEngineType cipherEngineType) {
        return this.getSupportedCipherPaddings(cipherEngineType, null, null);
    }

    public Set<String> getSupportedCipherPaddings(String cipherEngine, String cipherMode) {
        return this.getSupportedCipherPaddings(null, cipherEngine, cipherMode);
    }

    private Set<String> getSupportedCipherPaddings(CipherEngineType cipherEngineType, String cipherEngine, String cipherMode) {
        if (cipherEngine != null) {
            cipherEngine = cipherEngine.toUpperCase(Locale.ENGLISH);
        }
        if (cipherMode != null) {
            cipherMode = cipherMode.toUpperCase(Locale.ENGLISH);
        }
        TreeSet<String> result = new TreeSet<String>();
        if (!(cipherEngineType != null && cipherEngineType != CipherEngineType.symmetricBlock || cipherEngine != null && !this.algorithmName2blockCipherEngineClass.containsKey(cipherEngine))) {
            result.add("");
            result.add("NOPADDING");
            if (cipherMode == null || this.modeName2blockCipherModeClass.containsKey(cipherMode)) {
                result.addAll(this.paddingName2blockCipherPaddingClass.keySet());
            }
        }
        if (!(cipherEngineType != null && cipherEngineType != CipherEngineType.symmetricStream || cipherEngine != null && !this.algorithmName2streamCipherEngineClass.containsKey(cipherEngine))) {
            result.add("");
            result.add("NOPADDING");
        }
        if (!(cipherEngineType != null && cipherEngineType != CipherEngineType.asymmetricBlock || cipherEngine != null && !this.algorithmName2asymmetricBlockCipherEngineClass.containsKey(cipherEngine))) {
            result.add("");
            result.add("NOPADDING");
            result.addAll(this.paddingName2asymmetricBlockCipherPaddingClass.keySet());
        }
        return Collections.unmodifiableSortedSet(result);
    }

    public Set<String> getSupportedCipherTransformations(CipherEngineType cipherEngineType) {
        TreeSet<CallSite> result = new TreeSet<CallSite>();
        for (String cipherEngine : this.getSupportedCipherEngines(cipherEngineType)) {
            for (String cipherMode : this.getSupportedCipherModes(cipherEngine)) {
                for (String cipherPadding : this.getSupportedCipherPaddings(cipherEngine, cipherMode)) {
                    result.add((CallSite)((Object)(cipherEngine + "/" + cipherMode + "/" + cipherPadding)));
                }
            }
        }
        return Collections.unmodifiableSortedSet(result);
    }

    public Cipher createCipher(String transformation) throws NoSuchAlgorithmException, NoSuchPaddingException {
        String[] transformationParts = CryptoRegistry.splitTransformation(transformation);
        String engineName = transformationParts[0].toUpperCase(Locale.ENGLISH);
        String modeName = transformationParts[1].toUpperCase(Locale.ENGLISH);
        String paddingName = transformationParts[2].toUpperCase(Locale.ENGLISH);
        transformationParts = null;
        BlockCipher engine = this.createBlockCipherEngine(engineName);
        if (engine != null) {
            return this.createCipherForBlockCipherEngine(transformation, engine, engineName, modeName, paddingName);
        }
        engine = this.createAsymmetricBlockCipherEngine(engineName);
        if (engine != null) {
            return this.createCipherForAsymmetricBlockCipherEngine(transformation, (AsymmetricBlockCipher)engine, engineName, modeName, paddingName);
        }
        engine = this.createStreamCipherEngine(engineName);
        if (engine != null) {
            return this.createCipherForStreamCipherEngine(transformation, (StreamCipher)engine, engineName, modeName, paddingName);
        }
        throw new NoSuchAlgorithmException("There is no cipher-engine-class registered with the name \"" + engineName + "\"!");
    }

    public Signer createSigner(String transformation) throws NoSuchAlgorithmException {
        String[] transformationParts = CryptoRegistry.splitTransformation(transformation);
        String engineName = transformationParts[0].toUpperCase(Locale.ENGLISH);
        String digestName = transformationParts[1].toUpperCase(Locale.ENGLISH);
        AsymmetricBlockCipher engine = this.createAsymmetricBlockCipherEngine(engineName);
        if (engine == null) {
            throw new NoSuchAlgorithmException(String.format("There is no asymmetric cipher-engine-class registered with the name \"%s\"!", engineName));
        }
        Digest digest = this.createDigest(digestName);
        if (digest == null) {
            throw new NoSuchAlgorithmException(String.format("There is no digest-class registered with the name \"%s\"!", digestName));
        }
        GenericSigner genericSigner = new GenericSigner(engine, digest);
        return genericSigner;
    }

    public static String[] splitTransformation(String transformation) throws IllegalArgumentException {
        int slashIdx;
        if (transformation == null) {
            throw new IllegalArgumentException("transformation == null");
        }
        Object[] result = new String[3];
        Arrays.fill(result, "");
        int lastSlashIdx = -1;
        int resultIdx = -1;
        do {
            if ((slashIdx = transformation.indexOf(47, lastSlashIdx + 1)) < 0) {
                slashIdx = transformation.length();
            }
            if (++resultIdx > result.length - 1) {
                throw new IllegalArgumentException("transformation=\"" + transformation + "\" contains more than " + (result.length - 1) + " slashes!");
            }
            result[resultIdx] = transformation.substring(lastSlashIdx + 1, slashIdx).trim();
            lastSlashIdx = slashIdx;
        } while (slashIdx != transformation.length());
        return result;
    }

    public SecretKeyGenerator createSecretKeyGenerator(String algorithmName, boolean initWithDefaults) throws NoSuchAlgorithmException {
        if (algorithmName == null) {
            throw new IllegalArgumentException("algorithmName == null");
        }
        if (!this.algorithmName2blockCipherEngineClass.containsKey(algorithmName = algorithmName.toUpperCase(Locale.ENGLISH)) && !this.algorithmName2streamCipherEngineClass.containsKey(algorithmName)) {
            throw new NoSuchAlgorithmException("There is no block/stream cipher registered for the algorithmName=\"" + algorithmName + "\"!");
        }
        SecretKeyGeneratorImpl secretKeyGeneratorImpl = new SecretKeyGeneratorImpl();
        if (initWithDefaults) {
            secretKeyGeneratorImpl.init(null);
        }
        return secretKeyGeneratorImpl;
    }

    public AsymmetricCipherKeyPairGenerator createKeyPairGenerator(String algorithmName, boolean initWithDefaults) throws NoSuchAlgorithmException {
        if (algorithmName == null) {
            throw new IllegalArgumentException("algorithmName == null");
        }
        AsymmetricCipherKeyPairGeneratorFactory factory = this.algorithmName2asymmetricCipherKeyPairGeneratorFactory.get(algorithmName);
        if (factory == null) {
            throw new NoSuchAlgorithmException("There is no key-pair-generator-class registered for algorithmName \"" + algorithmName + "\"!");
        }
        AsymmetricCipherKeyPairGenerator generator = factory.createAsymmetricCipherKeyPairGenerator(initWithDefaults);
        return generator;
    }

    public AsymmetricKeyParameter decodePublicKey(byte[] publicKeyData) throws IOException {
        AsymmetricKeyParameter asymmetricKeyParameter = PublicKeyFactory.createKey((byte[])publicKeyData);
        return asymmetricKeyParameter;
    }

    public byte[] encodePublicKey(CipherParameters publicKey) {
        if (publicKey == null) {
            throw new IllegalArgumentException("publicKey == null");
        }
        try {
            if (publicKey instanceof RSAKeyParameters) {
                RSAKeyParameters rsaPublicKey = (RSAKeyParameters)publicKey;
                SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE), (ASN1Encodable)new RSAPublicKey(rsaPublicKey.getModulus(), rsaPublicKey.getExponent()).toASN1Primitive());
                return info.getEncoded();
            }
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
        throw new UnsupportedOperationException("publicKey.class=\"" + publicKey.getClass().getName() + "\" not yet supported!");
    }

    public AsymmetricKeyParameter decodePrivateKey(byte[] privateKeyData) throws IOException {
        AsymmetricKeyParameter asymmetricKeyParameter = PrivateKeyFactory.createKey((byte[])privateKeyData);
        return asymmetricKeyParameter;
    }

    public byte[] encodePrivateKey(CipherParameters privateKey) {
        if (privateKey == null) {
            throw new IllegalArgumentException("privateKey == null");
        }
        try {
            if (privateKey instanceof RSAPrivateCrtKeyParameters) {
                RSAPrivateCrtKeyParameters rsaPrivateKey = (RSAPrivateCrtKeyParameters)privateKey;
                PrivateKeyInfo info = new PrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE), (ASN1Encodable)new RSAPrivateKey(rsaPrivateKey.getModulus(), rsaPrivateKey.getPublicExponent(), rsaPrivateKey.getExponent(), rsaPrivateKey.getP(), rsaPrivateKey.getQ(), rsaPrivateKey.getDP(), rsaPrivateKey.getDQ(), rsaPrivateKey.getQInv()).toASN1Primitive());
                return info.getEncoded();
            }
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
        throw new UnsupportedOperationException("privateKey.class=\"" + privateKey.getClass().getName() + "\" not yet supported!");
    }

    private void registerMACCalculatorFactory(String macName, MACCalculatorFactory factory) {
        if (macName != null) {
            factory.setAlgorithmName(macName);
        }
        logger.trace("registerMACCalculatorFactory: algorithmName=\"{}\" factoryClass=\"{}\"", (Object)factory.getAlgorithmName(), (Object)factory.getClass().getName());
        this.macName2macCalculatorFactory.put(factory.getAlgorithmName(), factory);
    }

    private void registerDeprecatedMACCalculatorFactories() {
        this.registerMACCalculatorFactory("OLDHMACSHA384", new MACCalculatorFactoryImpl.OldSHA384());
        this.registerMACCalculatorFactory("OLDHMACSHA512", new MACCalculatorFactoryImpl.OldSHA512());
    }

    public MACCalculator createMACCalculator(String algorithmName, boolean initWithDefaults) throws NoSuchAlgorithmException {
        if (algorithmName == null) {
            throw new IllegalArgumentException("algorithmName == null");
        }
        MACCalculatorFactory factory = this.macName2macCalculatorFactory.get(algorithmName.toUpperCase(Locale.ENGLISH));
        if (factory == null) {
            throw new NoSuchAlgorithmException("There is no MAC calculator registered for algorithmName=\"" + algorithmName.toUpperCase(Locale.ENGLISH) + "\"!");
        }
        return factory.createMACCalculator(initWithDefaults);
    }

    public Set<String> getSupportedMACAlgorithms() {
        return Collections.unmodifiableSet(new TreeSet<String>(this.macName2macCalculatorFactory.keySet()));
    }
}

