/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.locker.sync;

import java.util.Objects;
import org.subshare.core.locker.sync.LockerSync;
import org.subshare.core.locker.sync.LockerSyncDaemon;
import org.subshare.core.server.Server;
import org.subshare.core.sync.Sync;
import org.subshare.core.sync.SyncDaemonImpl;

public class LockerSyncDaemonImpl
extends SyncDaemonImpl
implements LockerSyncDaemon {
    public static final String CONFIG_KEY_PGP_SYNC_PERIOD = "lockerSyncPeriod";
    public static final long CONFIG_DEFAULT_VALUE_PGP_SYNC_PERIOD = 3600000L;

    @Override
    protected String getConfigKeySyncPeriod() {
        return CONFIG_KEY_PGP_SYNC_PERIOD;
    }

    @Override
    protected long getConfigDefaultValueSyncPeriod() {
        return 3600000L;
    }

    @Override
    protected Sync createSync(Server server) {
        Objects.requireNonNull(server, "server");
        return new LockerSync(server);
    }

    public static LockerSyncDaemon getInstance() {
        return Holder.instance;
    }

    private static final class Holder {
        public static final LockerSyncDaemonImpl instance = new LockerSyncDaemonImpl();

        private Holder() {
        }
    }
}

