/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.version;

import co.codewizards.cloudstore.core.dto.jaxb.VersionXmlAdapter;
import co.codewizards.cloudstore.core.version.MalformedVersionException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlJavaTypeAdapter(type=Version.class, value=VersionXmlAdapter.class)
public class Version
implements Comparable<Version>,
Serializable {
    public static final String SNAPSHOT_SUFFIX = "SNAPSHOT";
    private static final long serialVersionUID = 1L;
    public static final Version MIN_VERSION = new Version(0, 0, 0, 0);
    public static final Version MAX_VERSION = new Version(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    private int major;
    private int minor;
    private int release;
    private int patchLevel;
    private String suffix;
    public static final String DEFAULT_SEPARATOR = ".";
    public static final String SUFFIX_SEPARATOR = "-";
    private static final String EMPTYSTRING = "";
    public static Pattern validityCheck = null;

    public Version(String versionStr) throws MalformedVersionException {
        if (versionStr == null || versionStr.length() == 0) {
            throw new IllegalArgumentException("versionStr must NEITHER be null NOR empty!");
        }
        this.parseVersion(versionStr);
        this.validate();
    }

    public Version(int major, int minor, int release, int patchLevel) {
        this(major, minor, release, patchLevel, null);
    }

    public Version(int major, int minor, int release, int patchLevel, String suffix) {
        this.major = major;
        this.minor = minor;
        this.release = release;
        this.patchLevel = patchLevel;
        if (suffix == null) {
            suffix = EMPTYSTRING;
        }
        this.suffix = suffix;
        this.validate();
    }

    private void validate() {
        if (this.major < 0) {
            throw new MalformedVersionException("Negative major versions are invalid!");
        }
        if (this.minor < 0) {
            throw new MalformedVersionException("Negative minor versions are invalid!");
        }
        if (this.release < 0) {
            throw new MalformedVersionException("Negative release versions are invalid!");
        }
        if (this.patchLevel < 0) {
            throw new MalformedVersionException("Negative patchlevels are invalid!");
        }
        if (this.suffix == null || this.suffix.length() == 0) {
            return;
        }
        if (validityCheck == null) {
            validityCheck = Pattern.compile("[\\w#\\$!\\-]*");
        }
        if (!validityCheck.matcher(this.suffix).matches()) {
            throw new MalformedVersionException("The suffix contains illegal characters! Suffix='" + this.suffix + "'. Legal characters ='a-zA-Z0-9#$!_-'.");
        }
    }

    public int getMajor() {
        return this.major;
    }

    public Version changeMajor(int major) {
        return new Version(major, this.minor, this.release, this.patchLevel, this.suffix);
    }

    public int getMinor() {
        return this.minor;
    }

    public Version changeMinor(int minor) {
        return new Version(this.major, minor, this.release, this.patchLevel, this.suffix);
    }

    public int getPatchLevel() {
        return this.patchLevel;
    }

    public Version changePatchLevel(int patchLevel) {
        return new Version(this.major, this.minor, this.release, patchLevel, this.suffix);
    }

    public int getRelease() {
        return this.release;
    }

    public Version changeRelease(int release) {
        return new Version(this.major, this.minor, release, this.patchLevel, this.suffix);
    }

    public String getSuffix() {
        return this.suffix;
    }

    public Version changeSuffix(String suffix) {
        return new Version(this.major, this.minor, this.release, this.patchLevel, suffix);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.major);
        sb.append(DEFAULT_SEPARATOR);
        sb.append(this.minor);
        sb.append(DEFAULT_SEPARATOR);
        sb.append(this.release);
        if (this.patchLevel != 0) {
            sb.append(DEFAULT_SEPARATOR);
            sb.append(this.patchLevel);
        }
        if (this.suffix != null && !EMPTYSTRING.equals(this.suffix)) {
            sb.append(SUFFIX_SEPARATOR);
            sb.append(this.suffix);
        }
        return sb.toString();
    }

    private void parseVersion(String version) throws MalformedVersionException {
        Pattern versionPattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(?:[-\\.](?:(\\d+)|([\\w#\\$!\\-]+)|(?:(\\d+)[-\\.]([\\w#\\$!\\-]+))))?\\s*\\z");
        Matcher m = versionPattern.matcher(version);
        if (m.find()) {
            this.major = Integer.parseInt(m.group(1));
            this.minor = Integer.parseInt(m.group(2));
            this.release = Integer.parseInt(m.group(3));
            if (m.group(4) != null) {
                try {
                    this.patchLevel = Integer.parseInt(m.group(4));
                    this.suffix = EMPTYSTRING;
                }
                catch (NumberFormatException nfe) {
                    this.patchLevel = 0;
                    this.suffix = m.group(4);
                }
            } else if (m.group(5) != null) {
                this.patchLevel = 0;
                this.suffix = m.group(5);
            } else if (m.group(6) != null && m.group(7) != null) {
                try {
                    this.patchLevel = Integer.parseInt(m.group(6));
                    this.suffix = m.group(7);
                }
                catch (NumberFormatException nfe2) {
                    throw new MalformedVersionException("The patchlevel has to be a parseable number! given patchlevel: '" + m.group(6) + "' given encoded version: '" + version + "'");
                }
            } else {
                for (int i = 4; i < 8; ++i) {
                    if (m.group(i) == null) continue;
                    throw new MalformedVersionException("Malformed version string: " + version);
                }
            }
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Version)) {
            return false;
        }
        Version otherVersion = (Version)other;
        return this.major == otherVersion.major && this.minor == otherVersion.minor && this.release == otherVersion.release && this.patchLevel == otherVersion.patchLevel && Version.equals(this.suffix, otherVersion.suffix);
    }

    private static boolean equals(Object obj0, Object obj1) {
        if (obj0 instanceof Object[] && obj1 instanceof Object[]) {
            return obj0 == obj1 || Arrays.equals((Object[])obj0, (Object[])obj1);
        }
        return obj0 == obj1 || obj0 != null && obj0.equals(obj1);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = result * 31 + this.major;
        result = result * 31 + this.minor;
        result = result * 31 + this.release;
        result = result * 31 + this.patchLevel;
        result = result * 31 + (this.suffix == null ? 0 : this.suffix.hashCode());
        return result;
    }

    @Override
    public int compareTo(Version other) {
        if (this == other) {
            return 0;
        }
        int difference = this.major - other.major;
        if (difference != 0) {
            return difference;
        }
        difference = this.minor - other.minor;
        if (difference != 0) {
            return difference;
        }
        difference = this.release - other.release;
        if (difference != 0) {
            return difference;
        }
        difference = this.patchLevel - other.patchLevel;
        if (difference != 0) {
            return difference;
        }
        if (this.suffix == null) {
            if (other.suffix == null) {
                return 0;
            }
            if (other.suffix.equalsIgnoreCase(SNAPSHOT_SUFFIX)) {
                return 1;
            }
            return 0;
        }
        if (this.suffix.equalsIgnoreCase(other.suffix)) {
            return 0;
        }
        if (this.suffix.equalsIgnoreCase(SNAPSHOT_SUFFIX)) {
            return -1;
        }
        return 0;
    }
}

