/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.crypto.internal.asymmetric.keypairgenerator;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.ElGamalKeyPairGenerator;
import org.bouncycastle.crypto.generators.ElGamalParametersGenerator;
import org.bouncycastle.crypto.params.ElGamalKeyGenerationParameters;
import org.bouncycastle.crypto.params.ElGamalParameters;
import org.subshare.crypto.internal.asymmetric.keypairgenerator.AbstractAsymmetricCipherKeyPairGeneratorFactory;

public class ElGamalKeyPairGeneratorFactory
extends AbstractAsymmetricCipherKeyPairGeneratorFactory {
    public ElGamalKeyPairGeneratorFactory() {
        this.setAlgorithmName("ElGamal");
    }

    @Override
    public AsymmetricCipherKeyPairGenerator createAsymmetricCipherKeyPairGenerator(boolean initWithDefaults) {
        ElGamalKeyPairGenerator generator = new ElGamalKeyPairGenerator();
        if (initWithDefaults) {
            int certainty = 12;
            SecureRandom random = new SecureRandom();
            ElGamalParametersGenerator pGen = new ElGamalParametersGenerator();
            pGen.init(4096, 12, random);
            ElGamalParameters elGamalParameters = pGen.generateParameters();
            generator.init((KeyGenerationParameters)new ElGamalKeyGenerationParameters(random, elGamalParameters));
        }
        return generator;
    }
}

