/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.dto;

import co.codewizards.cloudstore.core.Uid;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.subshare.core.dto.CryptoKeyDeactivationDto;
import org.subshare.core.dto.CryptoKeyRole;
import org.subshare.core.dto.CryptoKeyType;
import org.subshare.core.dto.SignatureDto;
import org.subshare.core.io.InputStreamSource;
import org.subshare.core.io.MultiInputStream;
import org.subshare.core.sign.Signable;
import org.subshare.core.sign.Signature;

@XmlRootElement
public class CryptoKeyDto
implements Signable {
    public static final String SIGNED_DATA_TYPE = "CryptoKey";
    private Uid cryptoKeyId;
    private Uid cryptoRepoFileId;
    private CryptoKeyType cryptoKeyType;
    private CryptoKeyRole cryptoKeyRole;
    @XmlElement
    private SignatureDto signatureDto;
    private CryptoKeyDeactivationDto cryptoKeyDeactivationDto;

    public CryptoKeyDto() {
    }

    public CryptoKeyDto(String cryptoKeyId, String cryptoRepoFileId, Enum<?> cryptoKeyType, Enum<?> cryptoKeyRole, Signature signature, String cryptoKeyDeactivation_cryptoKeyId, Signature cryptoKeyDeactivation_signature) {
        this.cryptoKeyId = Uid.valueOf((String)cryptoKeyId);
        this.cryptoRepoFileId = Uid.valueOf((String)cryptoRepoFileId);
        this.cryptoKeyType = (CryptoKeyType)cryptoKeyType;
        this.cryptoKeyRole = (CryptoKeyRole)cryptoKeyRole;
        this.setSignature(signature);
        if (cryptoKeyDeactivation_cryptoKeyId != null) {
            this.cryptoKeyDeactivationDto = new CryptoKeyDeactivationDto();
            this.cryptoKeyDeactivationDto.setCryptoKeyId(new Uid(cryptoKeyDeactivation_cryptoKeyId));
            this.cryptoKeyDeactivationDto.setSignature(cryptoKeyDeactivation_signature);
        }
    }

    public Uid getCryptoKeyId() {
        return this.cryptoKeyId;
    }

    public void setCryptoKeyId(Uid cryptoKeyId) {
        this.cryptoKeyId = cryptoKeyId;
    }

    public Uid getCryptoRepoFileId() {
        return this.cryptoRepoFileId;
    }

    public void setCryptoRepoFileId(Uid cryptoRepoFileId) {
        this.cryptoRepoFileId = cryptoRepoFileId;
    }

    public CryptoKeyType getCryptoKeyType() {
        return this.cryptoKeyType;
    }

    public void setCryptoKeyType(CryptoKeyType cryptoKeyType) {
        this.cryptoKeyType = cryptoKeyType;
    }

    public CryptoKeyRole getCryptoKeyRole() {
        return this.cryptoKeyRole;
    }

    public void setCryptoKeyRole(CryptoKeyRole cryptoKeyRole) {
        this.cryptoKeyRole = cryptoKeyRole;
    }

    public CryptoKeyDeactivationDto getCryptoKeyDeactivationDto() {
        return this.cryptoKeyDeactivationDto;
    }

    public void setCryptoKeyDeactivationDto(CryptoKeyDeactivationDto cryptoKeyDeactivationDto) {
        this.cryptoKeyDeactivationDto = cryptoKeyDeactivationDto;
    }

    @Override
    public String getSignedDataType() {
        return SIGNED_DATA_TYPE;
    }

    @Override
    public int getSignedDataVersion() {
        return 0;
    }

    @Override
    public InputStream getSignedData(int signedDataVersion) {
        try {
            byte separatorIndex = 0;
            InputStreamSource[] inputStreamSourceArray = new InputStreamSource[7];
            inputStreamSourceArray[0] = InputStreamSource.Helper.createInputStreamSource(this.cryptoKeyId);
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[1] = InputStreamSource.Helper.createInputStreamSource(separatorIndex);
            inputStreamSourceArray[2] = InputStreamSource.Helper.createInputStreamSource(this.cryptoRepoFileId);
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[3] = InputStreamSource.Helper.createInputStreamSource(separatorIndex);
            inputStreamSourceArray[4] = InputStreamSource.Helper.createInputStreamSource(this.cryptoKeyRole.ordinal());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[5] = InputStreamSource.Helper.createInputStreamSource(separatorIndex);
            inputStreamSourceArray[6] = InputStreamSource.Helper.createInputStreamSource(this.cryptoKeyType.ordinal());
            return new MultiInputStream(inputStreamSourceArray);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    @Override
    @XmlTransient
    public Signature getSignature() {
        return this.signatureDto;
    }

    @Override
    public void setSignature(Signature signature) {
        this.signatureDto = SignatureDto.copyIfNeeded(signature);
    }

    public String toString() {
        return "CryptoKeyDto[cryptoKeyId=" + this.cryptoKeyId + ", cryptoRepoFileId=" + this.cryptoRepoFileId + ", cryptoKeyType=" + this.cryptoKeyType + ", cryptoKeyRole=" + this.cryptoKeyRole + ", cryptoKeyDeactivationDto=" + this.cryptoKeyDeactivationDto + "]";
    }
}

