/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.rest.server;

import co.codewizards.cloudstore.ls.core.invoke.ObjectManager;
import co.codewizards.cloudstore.ls.core.invoke.ObjectRef;
import co.codewizards.cloudstore.ls.core.invoke.ObjectRefConverter;
import co.codewizards.cloudstore.ls.core.invoke.RemoteObjectProxy;
import co.codewizards.cloudstore.ls.rest.server.InverseInvoker;
import java.util.Objects;

class ObjectRefConverterImpl
implements ObjectRefConverter {
    private final ObjectManager objectManager;
    private InverseInvoker inverseInvoker;

    public ObjectRefConverterImpl(ObjectManager objectManager) {
        this.objectManager = Objects.requireNonNull(objectManager, "objectManager");
    }

    public Object convertToObjectRefIfNeeded(Object object) {
        if (object instanceof RemoteObjectProxy) {
            return Objects.requireNonNull(((RemoteObjectProxy)object).getObjectRef(), "object.getObjectRef()");
        }
        return this.objectManager.getObjectRefOrObject(object);
    }

    public Object convertFromObjectRefIfNeeded(Object object) {
        if (object instanceof ObjectRef) {
            ObjectRef objectRef = (ObjectRef)object;
            if (this.objectManager.getClientId().equals((Object)objectRef.getClientId())) {
                return this.objectManager.getObjectOrFail(objectRef);
            }
            return this.getInverseInvoker().getRemoteObjectProxyOrCreate(objectRef);
        }
        return object;
    }

    protected InverseInvoker getInverseInvoker() {
        if (this.inverseInvoker == null) {
            this.inverseInvoker = InverseInvoker.getInverseInvoker(this.objectManager);
        }
        return this.inverseInvoker;
    }
}

