/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.repo.metaonly;

import co.codewizards.cloudstore.core.bean.PropertyChangeListenerUtil;
import co.codewizards.cloudstore.core.config.ConfigImpl;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.repo.ServerRepoRegistry;
import org.subshare.core.repo.ServerRepoRegistryImpl;
import org.subshare.core.repo.metaonly.MetaOnlyRepoManagerImpl;
import org.subshare.core.repo.metaonly.MetaOnlyRepoSyncDaemon;

public class MetaOnlyRepoSyncDaemonImpl
implements MetaOnlyRepoSyncDaemon {
    public static final String CONFIG_KEY_READ_ONLY_META_REPO_SYNC_PERIOD = "readOnlyMetaRepoSyncPeriod";
    public static final long CONFIG_DEFAULT_VALUE_READ_ONLY_META_REPO_SYNC_PERIOD = 300000L;
    private static final Logger logger = LoggerFactory.getLogger(MetaOnlyRepoSyncDaemonImpl.class);
    private Timer syncTimer;
    private TimerTask syncTimerTask;
    private volatile long syncPeriod;
    private final AtomicBoolean syncRunning = new AtomicBoolean();
    private ServerRepoRegistry serverRepoRegistry;
    private final PropertyChangeListener serverRepoRegistryPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            MetaOnlyRepoSyncDaemonImpl.this.getSyncTimer().schedule(new TimerTask(){

                @Override
                public void run() {
                    MetaOnlyRepoSyncDaemonImpl.this._sync();
                }
            }, 0L);
        }
    };

    private MetaOnlyRepoSyncDaemonImpl() {
        this.createSyncTimerTask(true);
        PropertyChangeListenerUtil.addWeakPropertyChangeListener((Object)this.getServerRepoRegistry(), (PropertyChangeListener)this.serverRepoRegistryPropertyChangeListener);
    }

    public static MetaOnlyRepoSyncDaemon getInstance() {
        return Holder.instance;
    }

    private synchronized boolean createSyncTimerTask(boolean runImmediately) {
        long syncPeriod;
        this.destroySyncTimerTask();
        this.syncPeriod = syncPeriod = ConfigImpl.getInstance().getPropertyAsLong(this.getConfigKeySyncPeriod(), this.getConfigDefaultValueSyncPeriod());
        if (syncPeriod <= 0L) {
            return false;
        }
        this.syncTimerTask = new TimerTask(){

            @Override
            public void run() {
                MetaOnlyRepoSyncDaemonImpl.this._sync();
                MetaOnlyRepoSyncDaemonImpl.this.recreateSyncTimerTaskIfPeriodChanged();
            }
        };
        long delay = runImmediately ? 500L : syncPeriod;
        this.getSyncTimer().schedule(this.syncTimerTask, delay, syncPeriod);
        return true;
    }

    private synchronized void recreateSyncTimerTaskIfPeriodChanged() {
        long syncPeriod = ConfigImpl.getInstance().getPropertyAsLong(this.getConfigKeySyncPeriod(), this.getConfigDefaultValueSyncPeriod());
        if (this.syncPeriod != syncPeriod) {
            this.destroySyncTimerTask();
            if (!this.createSyncTimerTask(false)) {
                this.destroySyncTimer();
            }
        }
    }

    @Override
    public void sync() {
        this._sync();
        this.createSyncTimerTask(false);
    }

    private void _sync() {
        if (!this.syncRunning.compareAndSet(false, true)) {
            return;
        }
        try {
            MetaOnlyRepoManagerImpl.getInstance().sync();
        }
        catch (Exception x) {
            logger.error("_sync: " + x, (Throwable)x);
        }
        finally {
            this.syncRunning.set(false);
        }
    }

    private synchronized Timer getSyncTimer() {
        if (this.syncTimer == null) {
            this.syncTimer = new Timer(true);
        }
        return this.syncTimer;
    }

    private synchronized void destroySyncTimer() {
        if (this.syncTimer != null) {
            this.syncTimer.cancel();
            this.syncTimer = null;
        }
    }

    private synchronized void destroySyncTimerTask() {
        if (this.syncTimerTask != null) {
            this.syncTimerTask.cancel();
            this.syncTimerTask = null;
        }
    }

    protected ServerRepoRegistry getServerRepoRegistry() {
        if (this.serverRepoRegistry == null) {
            this.serverRepoRegistry = ServerRepoRegistryImpl.getInstance();
        }
        return this.serverRepoRegistry;
    }

    protected String getConfigKeySyncPeriod() {
        return CONFIG_KEY_READ_ONLY_META_REPO_SYNC_PERIOD;
    }

    protected long getConfigDefaultValueSyncPeriod() {
        return 300000L;
    }

    private static final class Holder {
        public static final MetaOnlyRepoSyncDaemonImpl instance = new MetaOnlyRepoSyncDaemonImpl();

        private Holder() {
        }
    }
}

