/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.util.DateUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.local.LocalRepoMetaDataImpl;
import co.codewizards.cloudstore.local.persistence.RemoteRepository;
import co.codewizards.cloudstore.local.persistence.RemoteRepositoryDao;
import co.codewizards.cloudstore.local.persistence.RepoFile;
import co.codewizards.cloudstore.local.persistence.RepoFileDao;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.AccessDeniedException;
import org.subshare.core.Cryptree;
import org.subshare.core.CryptreeFactoryRegistry;
import org.subshare.core.LocalRepoStorage;
import org.subshare.core.LocalRepoStorageFactoryRegistry;
import org.subshare.core.ReadUserIdentityAccessDeniedException;
import org.subshare.core.dto.CollisionDto;
import org.subshare.core.dto.CollisionPrivateDto;
import org.subshare.core.dto.CryptoRepoFileDto;
import org.subshare.core.dto.DebugUserRepoKeyDto;
import org.subshare.core.dto.HistoFrameDto;
import org.subshare.core.dto.PermissionType;
import org.subshare.core.dto.PlainHistoCryptoRepoFileDto;
import org.subshare.core.dto.UserIdentityPayloadDto;
import org.subshare.core.dto.split.CryptoChangeSetDtoSplitFileManager;
import org.subshare.core.repo.local.CollisionFilter;
import org.subshare.core.repo.local.CollisionPrivateFilter;
import org.subshare.core.repo.local.HistoFrameFilter;
import org.subshare.core.repo.local.PlainHistoCryptoRepoFileFilter;
import org.subshare.core.repo.local.SsLocalRepoMetaData;
import org.subshare.core.user.User;
import org.subshare.core.user.UserRegistryImpl;
import org.subshare.core.user.UserRepoKey;
import org.subshare.core.user.UserRepoKeyRing;
import org.subshare.core.user.UserRepoKeyRingLookup;
import org.subshare.core.user.UserRepoKeyRingLookupContext;
import org.subshare.local.UpdatePlainHistoCryptoRepoFilesMarker;
import org.subshare.local.dto.CollisionDtoConverter;
import org.subshare.local.dto.CollisionPrivateDtoConverter;
import org.subshare.local.dto.CryptoRepoFileDtoConverter;
import org.subshare.local.dto.HistoFrameDtoConverter;
import org.subshare.local.persistence.Collision;
import org.subshare.local.persistence.CollisionDao;
import org.subshare.local.persistence.CollisionPrivate;
import org.subshare.local.persistence.CollisionPrivateDao;
import org.subshare.local.persistence.CryptoRepoFile;
import org.subshare.local.persistence.CryptoRepoFileDao;
import org.subshare.local.persistence.HistoFrame;
import org.subshare.local.persistence.HistoFrameDao;
import org.subshare.local.persistence.InvitationUserRepoKeyPublicKey;
import org.subshare.local.persistence.LastCryptoKeySyncFromRemoteRepo;
import org.subshare.local.persistence.LastCryptoKeySyncFromRemoteRepoDao;
import org.subshare.local.persistence.ScheduledReupload;
import org.subshare.local.persistence.ScheduledReuploadDao;
import org.subshare.local.persistence.UserIdentity;
import org.subshare.local.persistence.UserIdentityDao;
import org.subshare.local.persistence.UserRepoKeyPublicKey;
import org.subshare.local.persistence.UserRepoKeyPublicKeyDao;

public class SsLocalRepoMetaDataImpl
extends LocalRepoMetaDataImpl
implements SsLocalRepoMetaData {
    private static final Logger logger = LoggerFactory.getLogger(SsLocalRepoMetaDataImpl.class);
    private UUID remoteRepositoryId;
    private URL remoteRoot;

    public CryptoRepoFileDto getCryptoRepoFileDto(long repoFileId) {
        CryptoRepoFileDto result;
        try (LocalRepoTransaction tx = this.beginReadTransaction();){
            CryptoRepoFileDtoConverter converter = CryptoRepoFileDtoConverter.create();
            RepoFile repoFile = (RepoFile)((RepoFileDao)tx.getDao(RepoFileDao.class)).getObjectByIdOrNull(repoFileId);
            CryptoRepoFile cryptoRepoFile = repoFile == null ? null : ((CryptoRepoFileDao)((Object)tx.getDao(CryptoRepoFileDao.class))).getCryptoRepoFile(repoFile);
            result = cryptoRepoFile == null ? null : converter.toCryptoRepoFileDto(cryptoRepoFile);
            tx.commit();
        }
        return result;
    }

    public Map<Long, CryptoRepoFileDto> getCryptoRepoFileDtos(Collection<Long> repoFileIds) {
        Objects.requireNonNull(repoFileIds, "repoFileIds");
        LinkedHashMap<Long, CryptoRepoFileDto> result = new LinkedHashMap<Long, CryptoRepoFileDto>();
        try (LocalRepoTransaction tx = this.beginReadTransaction();){
            RepoFileDao repoFileDao = (RepoFileDao)tx.getDao(RepoFileDao.class);
            CryptoRepoFileDao cryptoRepoFileDao = (CryptoRepoFileDao)((Object)tx.getDao(CryptoRepoFileDao.class));
            CryptoRepoFileDtoConverter converter = CryptoRepoFileDtoConverter.create();
            for (Long repoFileId : repoFileIds) {
                CryptoRepoFile cryptoRepoFile;
                Objects.requireNonNull(repoFileId, "repoFileId");
                RepoFile repoFile = (RepoFile)repoFileDao.getObjectByIdOrNull(repoFileId.longValue());
                if (repoFile == null || (cryptoRepoFile = cryptoRepoFileDao.getCryptoRepoFile(repoFile)) == null) continue;
                result.put(repoFileId, converter.toCryptoRepoFileDto(cryptoRepoFile));
            }
            tx.commit();
        }
        return result;
    }

    public boolean isPermissionsInherited(String localPath) {
        try (LocalRepoTransaction tx = this.beginReadTransaction();){
            Cryptree cryptree = this.getCryptree(tx);
            boolean result = cryptree.isPermissionsInherited(localPath);
            tx.commit();
            boolean bl = result;
            return bl;
        }
    }

    public void setPermissionsInherited(String localPath, boolean inherited) {
        try (LocalRepoTransaction tx = this.beginWriteTransaction();){
            Cryptree cryptree = this.getCryptree(tx);
            cryptree.setPermissionsInherited(localPath, inherited);
            tx.commit();
        }
    }

    public Uid getOwnerUserRepoKeyId() {
        try (LocalRepoTransaction tx = this.beginReadTransaction();){
            Cryptree cryptree = this.getCryptree(tx);
            Uid result = cryptree.getOwnerUserRepoKeyId();
            tx.commit();
            Uid uid = result;
            return uid;
        }
    }

    public Set<PermissionType> getGrantedPermissionTypes(String localPath, Uid userRepoKeyId) {
        try (LocalRepoTransaction tx = this.beginReadTransaction();){
            Cryptree cryptree = this.getCryptree(tx);
            Set result = cryptree.getGrantedPermissionTypes(localPath, userRepoKeyId);
            tx.commit();
            Set set = result;
            return set;
        }
    }

    public Set<PermissionType> getEffectivePermissionTypes(String localPath, Uid userRepoKeyId) {
        EnumSet<PermissionType> result = EnumSet.noneOf(PermissionType.class);
        try (LocalRepoTransaction tx = this.beginReadTransaction();){
            Cryptree cryptree = this.getCryptree(tx);
            for (PermissionType permissionType : PermissionType.values()) {
                try {
                    cryptree.assertHasPermission(localPath, userRepoKeyId, permissionType, DateUtil.now());
                    result.add(permissionType);
                }
                catch (AccessDeniedException x) {
                    Util.doNothing();
                }
            }
            tx.commit();
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<PermissionType> getInheritedPermissionTypes(String localPath, Uid userRepoKeyId) {
        EnumSet<PermissionType> result = EnumSet.noneOf(PermissionType.class);
        try (LocalRepoTransaction tx = this.beginReadTransaction();){
            Cryptree cryptree = this.getCryptree(tx);
            Uid cryptoRepoFileId = cryptree.getCryptoRepoFileIdOrFail(localPath);
            Uid parentCryptoRepoFileId = cryptree.getParentCryptoRepoFileId(cryptoRepoFileId);
            if (parentCryptoRepoFileId == null) {
                Set<PermissionType> set = Collections.emptySet();
                return set;
            }
            for (PermissionType permissionType : PermissionType.values()) {
                try {
                    cryptree.assertHasPermission(parentCryptoRepoFileId, userRepoKeyId, permissionType, DateUtil.now());
                    result.add(permissionType);
                }
                catch (AccessDeniedException x) {
                    Util.doNothing();
                }
            }
            tx.commit();
        }
        return Collections.unmodifiableSet(result);
    }

    public void revokePermission(String localPath, PermissionType permissionType, Set<Uid> userRepoKeyIds) {
        try (LocalRepoTransaction tx = this.beginWriteTransaction();){
            Cryptree cryptree = this.getCryptree(tx);
            cryptree.revokePermission(localPath, permissionType, userRepoKeyIds);
            tx.commit();
        }
    }

    public void grantPermission(String localPath, PermissionType permissionType, UserRepoKey.PublicKey publicKey) {
        try (LocalRepoTransaction tx = this.beginWriteTransaction();){
            Cryptree cryptree = this.getCryptree(tx);
            cryptree.grantPermission(localPath, permissionType, publicKey);
            tx.commit();
        }
    }

    public void scheduleReupload(String localPath) {
        logger.debug("scheduleReupload: localPath='{}' ", (Object)localPath);
        try (LocalRepoTransaction tx = this.beginWriteTransaction();){
            File localRoot = tx.getLocalRepoManager().getLocalRoot();
            File file = localRoot.createFile(new String[]{localPath});
            RepoFile repoFile = ((RepoFileDao)tx.getDao(RepoFileDao.class)).getRepoFile(localRoot, file);
            if (repoFile != null) {
                ScheduledReuploadDao srDao = (ScheduledReuploadDao)((Object)tx.getDao(ScheduledReuploadDao.class));
                ScheduledReupload scheduledReupload = srDao.getScheduledReupload(repoFile);
                if (scheduledReupload == null) {
                    scheduledReupload = new ScheduledReupload();
                    scheduledReupload.setRepoFile(repoFile);
                }
                srDao.makePersistent(scheduledReupload);
            } else {
                logger.warn("scheduleReupload: localRoot='{}' localPath='{}' ignored, becaue RepoFile not found!", (Object)localRoot.getPath(), (Object)localPath);
            }
            tx.commit();
        }
    }

    protected Cryptree getCryptree(LocalRepoTransaction tx) {
        UUID localRepositoryId = tx.getLocalRepoManager().getRepositoryId();
        UUID remoteRepositoryId = this.getRemoteRepositoryId(tx);
        String remotePathPrefix = "";
        UserRepoKeyRing userRepoKeyRing = UserRepoKeyRingLookup.Helper.getUserRepoKeyRingLookup().getUserRepoKeyRing(new UserRepoKeyRingLookupContext(localRepositoryId, remoteRepositoryId));
        Cryptree cryptree = CryptreeFactoryRegistry.getInstance().getCryptreeFactoryOrFail().getCryptreeOrCreate(tx, remoteRepositoryId, "", userRepoKeyRing);
        return cryptree;
    }

    protected UUID getRemoteRepositoryId(LocalRepoTransaction tx) {
        Objects.requireNonNull(tx, "tx");
        UUID result = this.remoteRepositoryId;
        if (result == null) {
            RemoteRepositoryDao remoteRepositoryDao = (RemoteRepositoryDao)tx.getDao(RemoteRepositoryDao.class);
            Iterator iterator = remoteRepositoryDao.getObjects().iterator();
            if (!iterator.hasNext()) {
                throw new IllegalStateException("There is no RemoteRepository!");
            }
            RemoteRepository remoteRepository = (RemoteRepository)iterator.next();
            URL remoteRoot = remoteRepository.getRemoteRoot();
            result = remoteRepository.getRepositoryId();
            if (iterator.hasNext()) {
                throw new IllegalStateException("There is more than one RemoteRepository!");
            }
            this.remoteRepositoryId = result;
            this.remoteRoot = remoteRoot;
        }
        return result;
    }

    protected URL getRemoteRoot(LocalRepoTransaction tx) {
        Objects.requireNonNull(tx, "tx");
        URL result = this.remoteRoot;
        if (result == null) {
            this.getRemoteRepositoryId(tx);
            result = this.remoteRoot;
            if (result == null) {
                throw new IllegalStateException("getRemoteRepositoryId(tx) did not assign remoteRoot!");
            }
        }
        return result;
    }

    public UUID getRemoteRepositoryId() {
        UUID result = this.remoteRepositoryId;
        if (result == null) {
            try (LocalRepoTransaction tx = this.getLocalRepoManagerOrFail().beginReadTransaction();){
                result = this.getRemoteRepositoryId(tx);
            }
            this.remoteRepositoryId = result;
        }
        return result;
    }

    public URL getRemoteRoot() {
        URL result = this.remoteRoot;
        if (result == null) {
            this.getRemoteRepositoryId();
            result = this.remoteRoot;
            if (result == null) {
                throw new IllegalStateException("getRemoteRepositoryId() did not assign remoteRoot!");
            }
        }
        return result;
    }

    public boolean isMetaOnly() {
        try (LocalRepoTransaction tx = this.getLocalRepoManagerOrFail().beginReadTransaction();){
            LocalRepoStorage lrs = LocalRepoStorageFactoryRegistry.getInstance().getLocalRepoStorageFactoryOrFail().getLocalRepoStorageOrCreate(tx);
            boolean bl = lrs.isMetaOnly();
            return bl;
        }
    }

    public void makeMetaOnly() {
        try (LocalRepoTransaction tx = this.getLocalRepoManagerOrFail().beginWriteTransaction();){
            LocalRepoStorage lrs = LocalRepoStorageFactoryRegistry.getInstance().getLocalRepoStorageFactoryOrFail().getLocalRepoStorageOrCreate(tx);
            lrs.makeMetaOnly();
            tx.commit();
        }
    }

    public Collection<HistoFrameDto> getHistoFrameDtos(HistoFrameFilter filter) {
        Objects.requireNonNull(filter, "filter");
        LocalRepoManager localRepoManager = this.getLocalRepoManagerOrFail();
        try (LocalRepoTransaction tx = localRepoManager.beginReadTransaction();){
            HistoFrameDao hfDao = (HistoFrameDao)((Object)tx.getDao(HistoFrameDao.class));
            Collection<HistoFrame> histoFrames = hfDao.getHistoFrames(filter);
            ArrayList<HistoFrameDto> result = new ArrayList<HistoFrameDto>(histoFrames.size());
            HistoFrameDtoConverter converter = HistoFrameDtoConverter.create(tx);
            for (HistoFrame histoFrame : histoFrames) {
                HistoFrameDto histoFrameDto = converter.toHistoFrameDto(histoFrame);
                result.add(histoFrameDto);
            }
            ArrayList<HistoFrameDto> arrayList = result;
            return arrayList;
        }
    }

    public Collection<PlainHistoCryptoRepoFileDto> getPlainHistoCryptoRepoFileDtos(PlainHistoCryptoRepoFileFilter filter) {
        UpdatePlainHistoCryptoRepoFilesMarker updatePlainHistoCryptoRepoFilesMarker;
        Collection result;
        Objects.requireNonNull(filter, "filter");
        try (LocalRepoTransaction tx = this.getLocalRepoManagerOrFail().beginReadTransaction();){
            result = this.getCryptree(tx).getPlainHistoCryptoRepoFileDtos(filter);
            updatePlainHistoCryptoRepoFilesMarker = (UpdatePlainHistoCryptoRepoFilesMarker)tx.getContextObject(UpdatePlainHistoCryptoRepoFilesMarker.class);
        }
        if (updatePlainHistoCryptoRepoFilesMarker != null) {
            new Thread("updatePlainHistoCryptoRepoFilesThread"){

                @Override
                public void run() {
                    try (LocalRepoTransaction tx = SsLocalRepoMetaDataImpl.this.getLocalRepoManagerOrFail().beginWriteTransaction();){
                        SsLocalRepoMetaDataImpl.this.getCryptree(tx).updatePlainHistoCryptoRepoFiles(updatePlainHistoCryptoRepoFilesMarker.getHistoCryptoRepoFileIds());
                        tx.commit();
                    }
                }
            }.start();
        }
        return result;
    }

    public Collection<CollisionPrivateDto> getCollisionPrivateDtos(CollisionPrivateFilter filter) {
        Objects.requireNonNull(filter, "filter");
        try (LocalRepoTransaction tx = this.getLocalRepoManagerOrFail().beginReadTransaction();){
            CollisionPrivateDao cDao = (CollisionPrivateDao)((Object)tx.getDao(CollisionPrivateDao.class));
            Collection<CollisionPrivate> pcps = cDao.getCollisionPrivates(filter);
            ArrayList<CollisionPrivateDto> result = new ArrayList<CollisionPrivateDto>(pcps.size());
            CollisionPrivateDtoConverter cpDtoConverter = CollisionPrivateDtoConverter.create(tx);
            for (CollisionPrivate pcp : pcps) {
                result.add(cpDtoConverter.toCollisionPrivateDto(pcp));
            }
            ArrayList<CollisionPrivateDto> arrayList = result;
            return arrayList;
        }
    }

    public Collection<CollisionDto> getCollisionDtos(CollisionFilter filter) {
        Objects.requireNonNull(filter, "filter");
        try (LocalRepoTransaction tx = this.getLocalRepoManagerOrFail().beginReadTransaction();){
            CollisionDao cDao = (CollisionDao)((Object)tx.getDao(CollisionDao.class));
            Collection<Collision> collisions = cDao.getCollisions(filter);
            ArrayList<CollisionDto> result = new ArrayList<CollisionDto>(collisions.size());
            CollisionDtoConverter converter = CollisionDtoConverter.create(tx);
            for (Collision collision : collisions) {
                CollisionDto collisionDto = converter.toCollisionDto(collision);
                result.add(collisionDto);
            }
            ArrayList<CollisionDto> arrayList = result;
            return arrayList;
        }
    }

    public void putCollisionPrivateDto(CollisionPrivateDto collisionPrivateDto) {
        Objects.requireNonNull(collisionPrivateDto, "collisionPrivateDto");
        try (LocalRepoTransaction tx = this.getLocalRepoManagerOrFail().beginWriteTransaction();){
            Cryptree cryptree = this.getCryptree(tx);
            cryptree.putCollisionPrivateDto(collisionPrivateDto);
            tx.commit();
        }
    }

    public Collection<DebugUserRepoKeyDto> getDebugUserRepoKeyDtos() {
        try (LocalRepoTransaction tx = this.getLocalRepoManagerOrFail().beginReadTransaction();){
            Cryptree cryptree = this.getCryptree(tx);
            UserRepoKeyPublicKeyDao urkpkDao = (UserRepoKeyPublicKeyDao)((Object)tx.getDao(UserRepoKeyPublicKeyDao.class));
            UserIdentityDao uiDao = (UserIdentityDao)((Object)tx.getDao(UserIdentityDao.class));
            HashMap<Uid, DebugUserRepoKeyDto> userRepoKeyId2DebugUserRepoKeyDto = new HashMap<Uid, DebugUserRepoKeyDto>();
            DebugUserRepoKeyDto dto = new DebugUserRepoKeyDto();
            Uid ownerUserRepoKeyId = cryptree.getOwnerUserRepoKeyId();
            if (ownerUserRepoKeyId != null) {
                dto.setUserRepoKeyId(ownerUserRepoKeyId);
                dto.setOwner(true);
                userRepoKeyId2DebugUserRepoKeyDto.put(dto.getUserRepoKeyId(), dto);
            }
            for (UserRepoKeyPublicKey userRepoKeyPublicKey : urkpkDao.getObjects()) {
                Uid userRepoKeyId = userRepoKeyPublicKey.getUserRepoKeyId();
                dto = (DebugUserRepoKeyDto)userRepoKeyId2DebugUserRepoKeyDto.get(userRepoKeyId);
                if (dto == null) {
                    dto = new DebugUserRepoKeyDto();
                    dto.setUserRepoKeyId(userRepoKeyId);
                    userRepoKeyId2DebugUserRepoKeyDto.put(dto.getUserRepoKeyId(), dto);
                }
                dto.setInDatabase(true);
                dto.setServerRepositoryId(userRepoKeyPublicKey.getServerRepositoryId());
                dto.setInvitation(userRepoKeyPublicKey instanceof InvitationUserRepoKeyPublicKey);
                Collection<UserIdentity> userIdentities = uiDao.getUserIdentitiesOf(userRepoKeyPublicKey);
                dto.setUserIdentityCount(userIdentities.size());
                try {
                    UserIdentityPayloadDto userIdentityPayloadDto = cryptree.getUserIdentityPayloadDtoOrFail(userRepoKeyId);
                    dto.setUserIdentityPayloadDto(userIdentityPayloadDto);
                }
                catch (ReadUserIdentityAccessDeniedException x) {
                    Util.doNothing();
                }
            }
            this.populateDebugUserRepoKeyDtoMapFromUserRepoKeyRing(userRepoKeyId2DebugUserRepoKeyDto, cryptree.getUserRepoKeyRing(), true);
            for (User user : UserRegistryImpl.getInstance().getUsers()) {
                UserRepoKeyRing userRepoKeyRing = user.getUserRepoKeyRing();
                if (userRepoKeyRing != null) {
                    if (userRepoKeyRing == cryptree.getUserRepoKeyRing()) continue;
                    this.populateDebugUserRepoKeyDtoMapFromUserRepoKeyRing(userRepoKeyId2DebugUserRepoKeyDto, userRepoKeyRing, false);
                    continue;
                }
                for (UserRepoKey.PublicKeyWithSignature pk : user.getUserRepoKeyPublicKeys()) {
                    Uid userRepoKeyId = pk.getUserRepoKeyId();
                    dto = (DebugUserRepoKeyDto)userRepoKeyId2DebugUserRepoKeyDto.get(userRepoKeyId);
                    if (dto == null) {
                        dto = new DebugUserRepoKeyDto();
                        dto.setUserRepoKeyId(userRepoKeyId);
                        userRepoKeyId2DebugUserRepoKeyDto.put(dto.getUserRepoKeyId(), dto);
                    }
                    dto.setKeyRingType(DebugUserRepoKeyDto.KeyRingType.PUBLIC);
                }
            }
            tx.commit();
            ArrayList arrayList = new ArrayList(userRepoKeyId2DebugUserRepoKeyDto.values());
            return arrayList;
        }
    }

    private void populateDebugUserRepoKeyDtoMapFromUserRepoKeyRing(Map<Uid, DebugUserRepoKeyDto> userRepoKeyId2DebugUserRepoKeyDto, UserRepoKeyRing userRepoKeyRing, boolean current) {
        for (UserRepoKey userRepoKey : userRepoKeyRing.getUserRepoKeys()) {
            Uid userRepoKeyId = userRepoKey.getUserRepoKeyId();
            DebugUserRepoKeyDto dto = userRepoKeyId2DebugUserRepoKeyDto.get(userRepoKeyId);
            if (dto == null) {
                dto = new DebugUserRepoKeyDto();
                dto.setUserRepoKeyId(userRepoKeyId);
                userRepoKeyId2DebugUserRepoKeyDto.put(dto.getUserRepoKeyId(), dto);
            }
            dto.setKeyRingType(current ? DebugUserRepoKeyDto.KeyRingType.PAIR_CURRENT : DebugUserRepoKeyDto.KeyRingType.PAIR_OTHER);
            if (dto.isInDatabase()) {
                if (dto.isInvitation() != userRepoKey.isInvitation()) {
                    throw new IllegalStateException("dto.inDatabase && dto.invitation != userRepoKey.invitation");
                }
            } else {
                dto.setInvitation(userRepoKey.isInvitation());
            }
            if (dto.getServerRepositoryId() == null) {
                userRepoKey.getServerRepositoryId();
                continue;
            }
            if (dto.getServerRepositoryId().equals(userRepoKey.getServerRepositoryId())) continue;
            throw new IllegalStateException("dto.serverRepositoryId != userRepoKey.serverRepositoryId");
        }
    }

    public void resetLastCryptoKeySyncFromRemoteRepoRemoteRepositoryRevisionSynced() {
        try (LocalRepoTransaction tx = this.getLocalRepoManagerOrFail().beginWriteTransaction();){
            LastCryptoKeySyncFromRemoteRepoDao dao = (LastCryptoKeySyncFromRemoteRepoDao)((Object)tx.getDao(LastCryptoKeySyncFromRemoteRepoDao.class));
            for (LastCryptoKeySyncFromRemoteRepo lastCryptoKeySyncFromRemoteRepo : dao.getObjects()) {
                lastCryptoKeySyncFromRemoteRepo.setRemoteRepositoryRevisionSynced(-1L);
                try {
                    CryptoChangeSetDtoSplitFileManager.createInstance((LocalRepoManager)this.getLocalRepoManagerOrFail(), (UUID)lastCryptoKeySyncFromRemoteRepo.getRemoteRepository().getRepositoryId()).deleteAll();
                }
                catch (IOException x) {
                    throw new RuntimeException(x);
                }
            }
            tx.commit();
        }
    }

    public void resetLastSyncFromRemoteRepoRemoteRepositoryRevisionSynced() {
        try (LocalRepoTransaction tx = this.getLocalRepoManagerOrFail().beginWriteTransaction();){
            RemoteRepositoryDao dao = (RemoteRepositoryDao)tx.getDao(RemoteRepositoryDao.class);
            for (RemoteRepository remoteRepo : dao.getObjects()) {
                remoteRepo.setRevision(-1L);
            }
            tx.commit();
        }
    }
}

