/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.local.db.IgnoreDatabaseMigraterComparison;
import co.codewizards.cloudstore.local.persistence.AutoTrackLocalRevision;
import co.codewizards.cloudstore.local.persistence.Entity;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.Embedded;
import javax.jdo.annotations.FetchGroup;
import javax.jdo.annotations.FetchGroups;
import javax.jdo.annotations.Index;
import javax.jdo.annotations.Inheritance;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.annotations.NullValue;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.Queries;
import javax.jdo.annotations.Query;
import javax.jdo.annotations.Unique;
import javax.jdo.listener.StoreCallback;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;
import org.subshare.core.dto.PermissionType;
import org.subshare.core.io.InputStreamSource;
import org.subshare.core.io.MultiInputStream;
import org.subshare.core.sign.Signature;
import org.subshare.core.sign.WriteProtected;
import org.subshare.local.persistence.SignatureImpl;
import org.subshare.local.persistence.UserIdentity;
import org.subshare.local.persistence.UserRepoKeyPublicKey;

@PersistenceCapable
@Inheritance(strategy=InheritanceStrategy.NEW_TABLE)
@Unique(name="UserIdentityLink_userIdentityLinkId", members={"userIdentityLinkId"})
@Index(name="UserIdentityLink_localRevision", members={"localRevision"})
@Queries(value={@Query(name="getUserIdentityLink_userIdentityLinkId", value="SELECT UNIQUE WHERE this.userIdentityLinkId == :userIdentityLinkId"), @Query(name="getUserIdentityLinksChangedAfter_localRevision", value="SELECT WHERE this.localRevision > :localRevision"), @Query(name="getUserIdentityLinks_userIdentity", value="SELECT WHERE this.userIdentity == :userIdentity"), @Query(name="getUserIdentityLinks_ofUserRepoKeyPublicKey", value="SELECT WHERE this.userIdentity.ofUserRepoKeyPublicKey == :ofUserRepoKeyPublicKey"), @Query(name="getUserIdentityLinks_forUserRepoKeyPublicKey", value="SELECT WHERE this.forUserRepoKeyPublicKey == :forUserRepoKeyPublicKey"), @Query(name="getUserIdentityLinks_ofUserRepoKeyPublicKey_forUserRepoKeyPublicKey", value="SELECT WHERE this.userIdentity.ofUserRepoKeyPublicKey == :ofUserRepoKeyPublicKey && this.forUserRepoKeyPublicKey == :forUserRepoKeyPublicKey")})
@FetchGroups(value={@FetchGroup(name="Signature", members={@Persistent(name="signature")})})
public class UserIdentityLink
extends Entity
implements WriteProtected,
AutoTrackLocalRevision,
StoreCallback,
Persistable {
    public static final String SIGNED_DATA_TYPE = "UserIdentityLink";
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Column(length=22)
    private String userIdentityLinkId;
    @Persistent(nullValue=NullValue.EXCEPTION)
    private UserIdentity userIdentity;
    @Persistent(nullValue=NullValue.EXCEPTION)
    private UserRepoKeyPublicKey forUserRepoKeyPublicKey;
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Column(jdbcType="BLOB")
    private byte[] encryptedUserIdentityKeyData;
    private long localRevision;
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Embedded(nullIndicatorColumn="signatureCreated")
    private SignatureImpl signature;
    private static final String[] dnFieldNames = UserIdentityLink.__dnFieldNamesInit();
    private static final int dnInheritedFieldCount = UserIdentityLink.__dnGetInheritedFieldCount();

    public UserIdentityLink() {
    }

    public UserIdentityLink(Uid userIdentityLinkId) {
        this.userIdentityLinkId = userIdentityLinkId == null ? null : userIdentityLinkId.toString();
    }

    public Uid getUserIdentityLinkId() {
        if (UserIdentityLink.dnGetuserIdentityLinkId(this) == null) {
            UserIdentityLink.dnSetuserIdentityLinkId(this, new Uid().toString());
        }
        return new Uid(UserIdentityLink.dnGetuserIdentityLinkId(this));
    }

    public UserIdentity getUserIdentity() {
        return UserIdentityLink.dnGetuserIdentity(this);
    }

    public void setUserIdentity(UserIdentity userIdentity) {
        if (!Util.equal((Object)((Object)UserIdentityLink.dnGetuserIdentity(this)), (Object)((Object)userIdentity))) {
            UserIdentityLink.dnSetuserIdentity(this, userIdentity);
        }
    }

    public UserRepoKeyPublicKey getForUserRepoKeyPublicKey() {
        return UserIdentityLink.dnGetforUserRepoKeyPublicKey(this);
    }

    public void setForUserRepoKeyPublicKey(UserRepoKeyPublicKey forUserRepoKeyPublicKey) {
        if (!Util.equal((Object)((Object)UserIdentityLink.dnGetforUserRepoKeyPublicKey(this)), (Object)((Object)forUserRepoKeyPublicKey))) {
            UserIdentityLink.dnSetforUserRepoKeyPublicKey(this, forUserRepoKeyPublicKey);
        }
    }

    public byte[] getEncryptedUserIdentityKeyData() {
        return UserIdentityLink.dnGetencryptedUserIdentityKeyData(this);
    }

    public void setEncryptedUserIdentityKeyData(byte[] encryptedUserIdentityKeyData) {
        if (!Util.equal((byte[])UserIdentityLink.dnGetencryptedUserIdentityKeyData(this), (byte[])encryptedUserIdentityKeyData)) {
            UserIdentityLink.dnSetencryptedUserIdentityKeyData(this, encryptedUserIdentityKeyData);
        }
    }

    public String getSignedDataType() {
        return SIGNED_DATA_TYPE;
    }

    public int getSignedDataVersion() {
        return 0;
    }

    public InputStream getSignedData(int signedDataVersion) {
        try {
            byte separatorIndex = 0;
            InputStreamSource[] inputStreamSourceArray = new InputStreamSource[7];
            inputStreamSourceArray[0] = InputStreamSource.Helper.createInputStreamSource((Uid)this.getUserIdentityLinkId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[1] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[2] = InputStreamSource.Helper.createInputStreamSource((Uid)UserIdentityLink.dnGetuserIdentity(this).getUserIdentityId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[3] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[4] = InputStreamSource.Helper.createInputStreamSource((Uid)UserIdentityLink.dnGetforUserRepoKeyPublicKey(this).getUserRepoKeyId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[5] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[6] = InputStreamSource.Helper.createInputStreamSource((byte[])UserIdentityLink.dnGetencryptedUserIdentityKeyData(this));
            return new MultiInputStream(inputStreamSourceArray);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public Signature getSignature() {
        return UserIdentityLink.dnGetsignature(this);
    }

    public void setSignature(Signature signature) {
        if (!Util.equal((Object)UserIdentityLink.dnGetsignature(this), (Object)signature)) {
            UserIdentityLink.dnSetsignature(this, SignatureImpl.copy(signature));
        }
    }

    public void jdoPreStore() {
        this.getUserIdentityLinkId();
    }

    public long getLocalRevision() {
        return UserIdentityLink.dnGetlocalRevision(this);
    }

    public void setLocalRevision(long localRevision) {
        if (!Util.equal((long)UserIdentityLink.dnGetlocalRevision(this), (long)localRevision)) {
            UserIdentityLink.dnSetlocalRevision(this, localRevision);
        }
    }

    @IgnoreDatabaseMigraterComparison
    public Uid getCryptoRepoFileIdControllingPermissions() {
        return null;
    }

    @IgnoreDatabaseMigraterComparison
    public PermissionType getPermissionTypeRequiredForWrite() {
        Signature signature = this.getSignature();
        if (signature == null || !signature.getSigningUserRepoKeyId().equals((Object)Objects.requireNonNull(Objects.requireNonNull(UserIdentityLink.dnGetuserIdentity(this), "userIdentity").getOfUserRepoKeyPublicKey(), "userIdentity.ofUserRepoKeyPublicKey").getUserRepoKeyId())) {
            return PermissionType.readUserIdentity;
        }
        return null;
    }

    static {
        EnhancementHelper.registerClass((Class)UserIdentityLink.___dn$loadClass("org.subshare.local.persistence.UserIdentityLink"), (Persistable)new UserIdentityLink());
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        UserIdentityLink result = new UserIdentityLink();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        UserIdentityLink result = new UserIdentityLink();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.encryptedUserIdentityKeyData = (byte[])this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 1: {
                this.forUserRepoKeyPublicKey = (UserRepoKeyPublicKey)((Object)this.dnStateManager.replacingObjectField((Persistable)this, index));
                break;
            }
            case 2: {
                this.localRevision = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 3: {
                this.signature = (SignatureImpl)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 4: {
                this.userIdentity = (UserIdentity)((Object)this.dnStateManager.replacingObjectField((Persistable)this, index));
                break;
            }
            case 5: {
                this.userIdentityLinkId = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            default: {
                super.dnReplaceField(index);
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.encryptedUserIdentityKeyData);
                break;
            }
            case 1: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.forUserRepoKeyPublicKey);
                break;
            }
            case 2: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.localRevision);
                break;
            }
            case 3: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.signature);
                break;
            }
            case 4: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.userIdentity);
                break;
            }
            case 5: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.userIdentityLinkId);
                break;
            }
            default: {
                super.dnProvideField(index);
            }
        }
    }

    protected final void dnCopyField(UserIdentityLink obj, int index) {
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.encryptedUserIdentityKeyData = obj.encryptedUserIdentityKeyData;
                break;
            }
            case 1: {
                this.forUserRepoKeyPublicKey = obj.forUserRepoKeyPublicKey;
                break;
            }
            case 2: {
                this.localRevision = obj.localRevision;
                break;
            }
            case 3: {
                this.signature = obj.signature;
                break;
            }
            case 4: {
                this.userIdentity = obj.userIdentity;
                break;
            }
            case 5: {
                this.userIdentityLinkId = obj.userIdentityLinkId;
                break;
            }
            default: {
                super.dnCopyField((Entity)obj, index);
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof UserIdentityLink)) {
            throw new IllegalArgumentException("object is not an object of type org.subshare.local.persistence.UserIdentityLink");
        }
        UserIdentityLink other = (UserIdentityLink)((Object)obj);
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"encryptedUserIdentityKeyData", "forUserRepoKeyPublicKey", "localRevision", "signature", "userIdentity", "userIdentityLinkId"};
    }

    protected static int __dnGetInheritedFieldCount() {
        return Entity.dnGetManagedFieldCount();
    }

    protected static int dnGetManagedFieldCount() {
        return 6 + Entity.dnGetManagedFieldCount();
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private static byte[] dnGetencryptedUserIdentityKeyData(UserIdentityLink objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0 + dnInheritedFieldCount)) {
            return (byte[])objPC.dnStateManager.getObjectField((Persistable)objPC, 0 + dnInheritedFieldCount, (Object)objPC.encryptedUserIdentityKeyData);
        }
        return objPC.encryptedUserIdentityKeyData;
    }

    private static void dnSetencryptedUserIdentityKeyData(UserIdentityLink objPC, byte[] val) {
        if (objPC.dnStateManager == null) {
            objPC.encryptedUserIdentityKeyData = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 0 + dnInheritedFieldCount, (Object)objPC.encryptedUserIdentityKeyData, (Object)val);
        }
    }

    private static UserRepoKeyPublicKey dnGetforUserRepoKeyPublicKey(UserIdentityLink objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1 + dnInheritedFieldCount)) {
            return (UserRepoKeyPublicKey)((Object)objPC.dnStateManager.getObjectField((Persistable)objPC, 1 + dnInheritedFieldCount, (Object)objPC.forUserRepoKeyPublicKey));
        }
        return objPC.forUserRepoKeyPublicKey;
    }

    private static void dnSetforUserRepoKeyPublicKey(UserIdentityLink objPC, UserRepoKeyPublicKey val) {
        if (objPC.dnStateManager == null) {
            objPC.forUserRepoKeyPublicKey = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 1 + dnInheritedFieldCount, (Object)objPC.forUserRepoKeyPublicKey, (Object)val);
        }
    }

    private static long dnGetlocalRevision(UserIdentityLink objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getLongField((Persistable)objPC, 2 + dnInheritedFieldCount, objPC.localRevision);
        }
        return objPC.localRevision;
    }

    private static void dnSetlocalRevision(UserIdentityLink objPC, long val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setLongField((Persistable)objPC, 2 + dnInheritedFieldCount, objPC.localRevision, val);
        } else {
            objPC.localRevision = val;
        }
    }

    private static SignatureImpl dnGetsignature(UserIdentityLink objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3 + dnInheritedFieldCount)) {
            return (SignatureImpl)objPC.dnStateManager.getObjectField((Persistable)objPC, 3 + dnInheritedFieldCount, (Object)objPC.signature);
        }
        return objPC.signature;
    }

    private static void dnSetsignature(UserIdentityLink objPC, SignatureImpl val) {
        if (objPC.dnStateManager == null) {
            objPC.signature = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 3 + dnInheritedFieldCount, (Object)objPC.signature, (Object)val);
        }
    }

    private static UserIdentity dnGetuserIdentity(UserIdentityLink objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4 + dnInheritedFieldCount)) {
            return (UserIdentity)((Object)objPC.dnStateManager.getObjectField((Persistable)objPC, 4 + dnInheritedFieldCount, (Object)objPC.userIdentity));
        }
        return objPC.userIdentity;
    }

    private static void dnSetuserIdentity(UserIdentityLink objPC, UserIdentity val) {
        if (objPC.dnStateManager == null) {
            objPC.userIdentity = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 4 + dnInheritedFieldCount, (Object)objPC.userIdentity, (Object)val);
        }
    }

    private static String dnGetuserIdentityLinkId(UserIdentityLink objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 5 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 5 + dnInheritedFieldCount, objPC.userIdentityLinkId);
        }
        return objPC.userIdentityLinkId;
    }

    private static void dnSetuserIdentityLinkId(UserIdentityLink objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 5 + dnInheritedFieldCount, objPC.userIdentityLinkId, val);
        } else {
            objPC.userIdentityLinkId = val;
        }
    }
}

