/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.control;

import co.codewizards.cloudstore.core.TimePeriod;
import co.codewizards.cloudstore.core.util.StringUtil;
import co.codewizards.cloudstore.core.util.Util;
import java.text.ParseException;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimePeriodTextField
extends TextField {
    private static final Logger logger = LoggerFactory.getLogger(TimePeriodTextField.class);
    private final ObjectProperty<TimePeriod> timePeriod = new SimpleObjectProperty<TimePeriod>((Object)this, "timePeriod"){

        public void set(TimePeriod timePeriod) {
            TimePeriod shownTimePeriod;
            if (Util.equal((Object)((TimePeriod)this.get()), (Object)timePeriod)) {
                logger.debug("timePeriod.set: newValue='{}' equals old value => ignore!", (Object)timePeriod);
                return;
            }
            logger.debug("timePeriod.set: newValue='{}'", (Object)timePeriod);
            super.set((Object)timePeriod);
            try {
                shownTimePeriod = new TimePeriod(StringUtil.trim((String)TimePeriodTextField.this.getText()));
            }
            catch (ParseException x) {
                shownTimePeriod = null;
            }
            if (!Util.equal((Object)timePeriod, shownTimePeriod)) {
                TimePeriodTextField.this.updateText();
            }
        }
    };

    public TimePeriodTextField() {
        this.textProperty().addListener(observable -> this.tryParse(true));
        this.focusedProperty().addListener(observable -> {
            if (!this.focusedProperty().get()) {
                this.onFocusLost();
            }
        });
    }

    private void tryParse(boolean silent) {
        String text = StringUtil.trim((String)this.getText());
        if (logger.isDebugEnabled()) {
            logger.debug("tryParse: silent={} text='{}'", (Object)silent, (Object)text);
        }
        if (StringUtil.isEmpty((String)text)) {
            this.setTimePeriod(null);
        } else {
            TimePeriod timePeriod;
            try {
                timePeriod = new TimePeriod(text);
            }
            catch (ParseException x) {
                if (!silent) {
                    this.showErrorMessage("Invalid input!", x.getLocalizedMessage());
                }
                return;
            }
            this.setTimePeriod(timePeriod);
        }
    }

    private void showErrorMessage(String headerText, String detailText) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setHeaderText(headerText);
        Text contentText = new Text(detailText);
        HBox contentTextContainer = new HBox();
        contentTextContainer.getChildren().add((Object)contentText);
        GridPane.setMargin((Node)contentText, (Insets)new Insets(8.0));
        alert.getDialogPane().setContent((Node)contentTextContainer);
        alert.showAndWait();
    }

    private void onFocusLost() {
        this.tryParse(false);
        this.updateText();
    }

    private void updateText() {
        TimePeriod timePeriod = this.getTimePeriod();
        if (logger.isDebugEnabled()) {
            logger.debug("updateText: oldText='{}' timePeriod='{}'", (Object)this.getText(), (Object)timePeriod);
        }
        this.setText(timePeriod == null ? null : timePeriod.toString());
    }

    public ObjectProperty<TimePeriod> timePeriodProperty() {
        return this.timePeriod;
    }

    public TimePeriod getTimePeriod() {
        return (TimePeriod)this.timePeriod.get();
    }

    public void setTimePeriod(TimePeriod timePeriod) {
        this.timePeriod.set((Object)timePeriod);
    }
}

