/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.pgp.keytree;

import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.pgp.PgpKeyFlag;
import org.subshare.gui.pgp.keytree.Messages;

public class PgpKeyFlagsToUsageConverter {
    private static final Logger logger = LoggerFactory.getLogger(PgpKeyFlagsToUsageConverter.class);

    public String toUsage(Set<PgpKeyFlag> pgpKeyFlags) {
        Objects.requireNonNull(pgpKeyFlags, "pgpKeyFlags");
        StringBuilder sb = new StringBuilder();
        block4: for (PgpKeyFlag pgpKeyFlag : pgpKeyFlags) {
            switch (pgpKeyFlag) {
                case CAN_AUTHENTICATE: 
                case CAN_CERTIFY: 
                case CAN_SIGN: 
                case CAN_ENCRYPT_COMMS: 
                case CAN_ENCRYPT_STORAGE: {
                    PgpKeyFlagsToUsageConverter.append(sb, pgpKeyFlag);
                    continue block4;
                }
                case MAYBE_SHARED: 
                case MAYBE_SPLIT: {
                    continue block4;
                }
            }
            logger.warn("Unknown pgpKeyFlag: " + pgpKeyFlag);
        }
        return sb.toString();
    }

    private static final void append(StringBuilder sb, PgpKeyFlag pgpKeyFlag) {
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append(Messages.getString(String.format(PgpKeyFlagsToUsageConverter.class.getSimpleName() + ".usage[%s]", pgpKeyFlag)));
    }
}

