/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core;

import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import java.util.Objects;
import java.util.UUID;
import org.subshare.core.Cryptree;
import org.subshare.core.CryptreeFactory;
import org.subshare.core.user.UserRepoKeyRing;

public abstract class AbstractCryptreeFactory
implements CryptreeFactory {
    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public Cryptree getCryptreeOrCreate(LocalRepoTransaction transaction, UUID remoteRepositoryId) {
        Objects.requireNonNull(transaction, "transaction");
        Objects.requireNonNull(remoteRepositoryId, "remoteRepositoryId");
        Cryptree cryptree = (Cryptree)transaction.getContextObject(Cryptree.class);
        if (cryptree == null) {
            cryptree = this._createCryptree();
            cryptree.setCryptreeFactory(this);
            cryptree.setTransaction(transaction);
            cryptree.setRemoteRepositoryId(remoteRepositoryId);
            transaction.setContextObject((Object)cryptree);
        } else {
            if (transaction != cryptree.getTransaction()) {
                throw new IllegalStateException("transaction != cryptree.transaction");
            }
            if (!remoteRepositoryId.equals(cryptree.getRemoteRepositoryId())) {
                throw new IllegalStateException("remoteRepositoryId != cryptree.remoteRepositoryId");
            }
        }
        return cryptree;
    }

    @Override
    public Cryptree getCryptreeOrCreate(LocalRepoTransaction transaction, UUID remoteRepositoryId, String remotePathPrefix, UserRepoKeyRing userRepoKeyRing) {
        Objects.requireNonNull(transaction, "transaction");
        Objects.requireNonNull(remoteRepositoryId, "remoteRepositoryId");
        Objects.requireNonNull(remotePathPrefix, "remotePathPrefix");
        Objects.requireNonNull(userRepoKeyRing, "userRepoKeyRing");
        Cryptree cryptree = (Cryptree)transaction.getContextObject(Cryptree.class);
        if (cryptree == null) {
            cryptree = this._createCryptree();
            cryptree.setCryptreeFactory(this);
            cryptree.setTransaction(transaction);
            cryptree.setRemoteRepositoryId(remoteRepositoryId);
            cryptree.setUserRepoKeyRing(userRepoKeyRing);
            cryptree.setRemotePathPrefix(remotePathPrefix);
            transaction.setContextObject((Object)cryptree);
        } else {
            if (transaction != cryptree.getTransaction()) {
                throw new IllegalStateException("transaction != cryptree.transaction");
            }
            if (!remoteRepositoryId.equals(cryptree.getRemoteRepositoryId())) {
                throw new IllegalStateException("remoteRepositoryId != cryptree.remoteRepositoryId");
            }
            if (userRepoKeyRing != cryptree.getUserRepoKeyRing()) {
                throw new IllegalStateException("userRepoKeyRing != cryptree.userRepoKeyRing");
            }
            if (!remotePathPrefix.equals(cryptree.getRemotePathPrefix())) {
                throw new IllegalStateException("remotePathPrefix != cryptree.remotePathPrefix");
            }
        }
        return cryptree;
    }

    protected abstract Cryptree _createCryptree();
}

