/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.updater.gui.console;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.updater.gui.console.Messages;

public abstract class ConsolePane
extends GridPane {
    private static final Logger logger = LoggerFactory.getLogger(ConsolePane.class);
    private BooleanProperty done = new SimpleBooleanProperty((Object)this, "done");
    @FXML
    private Label headerLabel;
    @FXML
    private TextArea consoleTextArea;
    @FXML
    private Button okButton;
    private static final AtomicInteger nextId = new AtomicInteger();
    private final int id = nextId.getAndIncrement();
    private final Object instanceMutex = this;
    private StringBuilder buffer = new StringBuilder();
    private final Timer updateUiTimer = new Timer("ConsolePane[" + this.id + "].updateTimer", true);
    private final Object finalizer = new Object(){

        protected void finalize() throws Throwable {
            ConsolePane.this.updateUiTimer.cancel();
        }
    };

    public ConsolePane() {
        this.loadFxml();
        this.okButton.disableProperty().bind((ObservableValue)this.done.not());
        TimerTask updateUiTimerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    ConsolePane.this.updateUi();
                }
                catch (Exception x) {
                    logger.error("updateTimerTask.run: " + x, (Throwable)x);
                }
            }
        };
        this.updateUiTimer.schedule(updateUiTimerTask, 0L, 500L);
    }

    public void setHeaderText(boolean error, String text) {
        String iconName = error ? "ERROR_24x24.png" : "INFO_24x24.png";
        this.headerLabel.setGraphic((Node)new ImageView(new Image(ConsolePane.class.getResource(iconName).toString())));
        this.headerLabel.setText(text);
    }

    private void loadFxml() {
        FXMLLoader fxmlLoader = new FXMLLoader(ConsolePane.class.getResource(ConsolePane.class.getSimpleName() + ".fxml"), Messages.RESOURCE_BUNDLE);
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isDone() {
        return this.done.get();
    }

    public void setDone(boolean done) {
        this.done.set(done);
    }

    public BooleanProperty doneProperty() {
        return this.done;
    }

    @FXML
    protected abstract void okButtonClicked(ActionEvent var1);

    public void appendError(Throwable error) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        error.printStackTrace(pw);
        pw.flush();
        pw.close();
        String errorStackTrace = sw.toString();
        this.println("\n\n\n*** ERROR ***");
        this.println(errorStackTrace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(String message) {
        Object object = this.instanceMutex;
        synchronized (object) {
            this.buffer.append(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUi() {
        String bufferStr;
        Object object = this.instanceMutex;
        synchronized (object) {
            bufferStr = this.buffer.toString();
            this.buffer = new StringBuilder();
        }
        if (bufferStr.length() > 0) {
            Platform.runLater(() -> this.consoleTextArea.appendText(bufferStr));
        }
    }

    public void println(String message) {
        this.print(message + "\n");
    }
}

