/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.dbupdate;

import co.codewizards.cloudstore.local.dbupdate.AbstractDbUpdateStep;
import co.codewizards.cloudstore.local.dbupdate.DatabaseType;
import java.sql.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbUpdateStep004
extends AbstractDbUpdateStep {
    private static final Logger logger = LoggerFactory.getLogger(DbUpdateStep004.class);

    @Override
    public int getVersion() {
        return 4;
    }

    @Override
    public void performUpdate() throws Exception {
        logger.info("performUpdate: entered.");
        try (Connection connection = this.getDatabaseAdapterOrFail().createConnection();){
            DatabaseType databaseType = DbUpdateStep004.getDatabaseType(connection);
            if (databaseType != DatabaseType.DERBY) {
                logger.info("performUpdate: This update-step is not supported for the database-type {}. Skipping!", (Object)databaseType);
                return;
            }
            logger.info("performUpdate: Database-type: {}", (Object)databaseType);
            String tableName = "LastSyncToRemoteRepo";
            String columnName = "resyncMode";
            if (!DbUpdateStep004.doesTableExist(connection, "LastSyncToRemoteRepo")) {
                logger.info("performUpdate: Table '{}' does not exist!", (Object)"LastSyncToRemoteRepo");
                return;
            }
            logger.info("performUpdate: Table '{}' does exist! Checking for existence of column '{}'.", (Object)"LastSyncToRemoteRepo", (Object)"resyncMode");
            if (!DbUpdateStep004.doesColumnExist(connection, "LastSyncToRemoteRepo", "resyncMode")) {
                DbUpdateStep004.addColumnBooleanNotNull(connection, "LastSyncToRemoteRepo", "resyncMode");
            }
        }
    }
}

