/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ContainerComponent;
import org.datanucleus.metadata.ContainerMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.InvalidMemberMetaDataException;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class CollectionMetaData
extends ContainerMetaData {
    private static final long serialVersionUID = -5567408442228331561L;
    protected ContainerComponent element = new ContainerComponent();
    protected boolean singleElement = false;

    public CollectionMetaData(CollectionMetaData collmd) {
        super(collmd);
        this.element.embedded = collmd.element.embedded;
        this.element.serialized = collmd.element.serialized;
        this.element.dependent = collmd.element.dependent;
        this.element.typeName = collmd.element.typeName;
        this.element.classMetaData = collmd.element.classMetaData;
        this.singleElement = collmd.singleElement;
    }

    public CollectionMetaData() {
    }

    public void populate(ClassLoaderResolver clr, ClassLoader primary) {
        AbstractClassMetaData elemCmd;
        AbstractMemberMetaData mmd = (AbstractMemberMetaData)this.parent;
        if (!StringUtils.isWhitespace(this.element.typeName) && this.element.typeName.indexOf(44) > 0) {
            throw new InvalidMemberMetaDataException("044131", mmd.getClassName(), mmd.getName());
        }
        this.element.populate(mmd.getAbstractClassMetaData().getPackageName(), clr, primary);
        if (this.element.typeName == null) {
            throw new InvalidMemberMetaDataException("044133", mmd.getClassName(), mmd.getName());
        }
        Class elementTypeClass = null;
        try {
            elementTypeClass = clr.classForName(this.element.typeName, primary);
            if (!elementTypeClass.getName().equals(this.element.typeName)) {
                NucleusLogger.METADATA.info(Localiser.msg("044135", this.getFieldName(), mmd.getClassName(false), this.element.typeName, elementTypeClass.getName()));
                this.element.typeName = elementTypeClass.getName();
            }
        }
        catch (ClassNotResolvedException cnre) {
            throw new InvalidMemberMetaDataException("044134", mmd.getClassName(), this.getFieldName(), this.element.typeName);
        }
        MetaDataManager mmgr = this.getMetaDataManager();
        if (this.element.embedded == null) {
            if (mmgr.getNucleusContext().getTypeManager().isDefaultEmbeddedType(elementTypeClass)) {
                this.element.embedded = Boolean.TRUE;
            } else {
                elemCmd = mmgr.readMetaDataForClass(elementTypeClass.getName());
                if (elemCmd == null) {
                    try {
                        elemCmd = mmgr.getMetaDataForClass(elementTypeClass, clr);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (elemCmd != null) {
                    this.element.embedded = elemCmd.isEmbeddedOnly() ? Boolean.TRUE : Boolean.FALSE;
                } else if (elementTypeClass.isInterface() || elementTypeClass == Object.class) {
                    this.element.embedded = Boolean.FALSE;
                } else {
                    NucleusLogger.METADATA.debug("Member with collection of elementType=" + elementTypeClass.getName() + " not explicitly marked as embedded, so defaulting to embedded since not persistable");
                    this.element.embedded = Boolean.TRUE;
                }
            }
        } else if (Boolean.FALSE.equals(this.element.embedded) && (elemCmd = mmgr.readMetaDataForClass(elementTypeClass.getName())) == null && !elementTypeClass.isInterface() && elementTypeClass != Object.class) {
            NucleusLogger.METADATA.debug("Member with collection of element type " + elementTypeClass.getName() + " marked as not embedded, but only persistable as embedded, so resetting");
            this.element.embedded = Boolean.TRUE;
        }
        ElementMetaData elemmd = mmd.getElementMetaData();
        if (elemmd != null && elemmd.getEmbeddedMetaData() != null) {
            this.element.embedded = Boolean.TRUE;
        }
        if (Boolean.TRUE.equals(this.element.dependent) && !mmgr.getApiAdapter().isPersistable(elementTypeClass) && !elementTypeClass.isInterface() && elementTypeClass != Object.class) {
            this.element.dependent = Boolean.FALSE;
        }
        this.element.classMetaData = mmgr.getMetaDataForClassInternal(elementTypeClass, clr);
        if (this.hasExtension("implementation-classes")) {
            StringBuilder str = new StringBuilder();
            String[] implTypes = this.getValuesForExtension("implementation-classes");
            for (int i = 0; i < implTypes.length; ++i) {
                String implTypeName = ClassUtils.createFullClassName(mmd.getPackageName(), implTypes[i]);
                if (i > 0) {
                    str.append(",");
                }
                try {
                    clr.classForName(implTypeName);
                    str.append(implTypeName);
                    continue;
                }
                catch (ClassNotResolvedException cnre) {
                    try {
                        String langClassName = ClassUtils.getJavaLangClassForType(implTypeName);
                        clr.classForName(langClassName);
                        str.append(langClassName);
                        continue;
                    }
                    catch (ClassNotResolvedException cnre2) {
                        throw new InvalidMemberMetaDataException("044116", mmd.getClassName(), mmd.getName(), implTypes[i]);
                    }
                }
            }
            this.addExtension("implementation-classes", str.toString());
        }
        super.populate();
        this.setPopulated();
    }

    public boolean elementIsPersistent() {
        return this.element.classMetaData != null;
    }

    public AbstractClassMetaData getElementClassMetaData(final ClassLoaderResolver clr) {
        if (this.element.classMetaData != null && !this.element.classMetaData.isInitialised()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    CollectionMetaData.this.element.classMetaData.initialise(clr);
                    return null;
                }
            });
        }
        return this.element.classMetaData;
    }

    public boolean isEmbeddedElement() {
        if (this.element.embedded == null) {
            return false;
        }
        return this.element.embedded;
    }

    public boolean isDependentElement() {
        if (this.element.dependent == null) {
            return false;
        }
        if (this.element.classMetaData == null) {
            return false;
        }
        return this.element.dependent;
    }

    public boolean isSerializedElement() {
        if (this.element.serialized == null) {
            return false;
        }
        return this.element.serialized;
    }

    public String getElementType() {
        return this.element.typeName;
    }

    public String[] getElementTypes() {
        return ((AbstractMemberMetaData)this.getParent()).getValuesForExtension("implementation-classes");
    }

    public CollectionMetaData setElementType(String type) {
        this.element.setTypeName(type);
        return this;
    }

    public CollectionMetaData setEmbeddedElement(boolean embedded) {
        this.element.setEmbedded(embedded);
        return this;
    }

    public CollectionMetaData setSerializedElement(boolean serialized) {
        this.element.setSerialized(serialized);
        return this;
    }

    public CollectionMetaData setDependentElement(boolean dependent) {
        this.element.setDependent(dependent);
        return this;
    }

    public CollectionMetaData setSingleElement(boolean singleElement) {
        this.singleElement = singleElement;
        return this;
    }

    void getReferencedClassMetaData(List<AbstractClassMetaData> orderedCmds, Set<AbstractClassMetaData> referencedCmds, ClassLoaderResolver clr) {
        AbstractClassMetaData elementCmd = this.getMetaDataManager().getMetaDataForClass(this.element.typeName, clr);
        if (elementCmd != null) {
            elementCmd.getReferencedClassMetaData(orderedCmds, referencedCmds, clr);
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder(super.toString()).append(" [" + this.element.typeName + "]");
        if (this.element.getEmbedded() == Boolean.TRUE) {
            str.append(" embedded");
        }
        if (this.element.getSerialized() == Boolean.TRUE) {
            str.append(" serialised");
        }
        if (this.element.getDependent() == Boolean.TRUE) {
            str.append(" dependent");
        }
        return str.toString();
    }
}

