/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.updater.gui.console;

import java.io.PrintStream;
import java.util.Formatter;
import java.util.Locale;
import org.subshare.updater.gui.console.ConsolePane;
import org.subshare.updater.gui.console.NoopOutputStream;

public class ConsolePrintStream
extends PrintStream {
    private final ConsolePane consolePane;
    private Formatter formatter;

    public ConsolePrintStream(ConsolePane consolePane) {
        super(new NoopOutputStream(), true);
        this.consolePane = consolePane;
    }

    @Override
    public void write(int b) {
        if (Character.isValidCodePoint(b)) {
            this.consolePane.print(String.valueOf((char)b));
        } else {
            this.consolePane.print("#" + Integer.toHexString(b));
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        for (int i = 0; i < len; ++i) {
            this.write(buf[off + i]);
        }
    }

    @Override
    public void print(boolean b) {
        this.consolePane.print(Boolean.toString(b));
    }

    @Override
    public void print(char c) {
        this.consolePane.print(String.valueOf(c));
    }

    @Override
    public void print(int i) {
        this.consolePane.print(String.valueOf(i));
    }

    @Override
    public void print(long l) {
        this.consolePane.print(String.valueOf(l));
    }

    @Override
    public void print(float f) {
        this.consolePane.print(String.valueOf(f));
    }

    @Override
    public void print(double d) {
        this.consolePane.print(String.valueOf(d));
    }

    @Override
    public void print(char[] s) {
        this.consolePane.print(String.valueOf(s));
    }

    @Override
    public void print(String s) {
        this.consolePane.print(s);
    }

    @Override
    public void print(Object obj) {
        this.consolePane.print(String.valueOf(obj));
    }

    @Override
    public void println() {
        this.consolePane.println("");
    }

    @Override
    public void println(boolean b) {
        this.consolePane.println(Boolean.toString(b));
    }

    @Override
    public void println(char c) {
        this.consolePane.println(String.valueOf(c));
    }

    @Override
    public void println(int i) {
        this.consolePane.println(String.valueOf(i));
    }

    @Override
    public void println(long l) {
        this.consolePane.println(String.valueOf(l));
    }

    @Override
    public void println(float f) {
        this.consolePane.println(String.valueOf(f));
    }

    @Override
    public void println(double d) {
        this.consolePane.println(String.valueOf(d));
    }

    @Override
    public void println(char[] s) {
        this.consolePane.println(String.valueOf(s));
    }

    @Override
    public void println(String s) {
        this.consolePane.println(s);
    }

    @Override
    public void println(Object obj) {
        this.consolePane.println(String.valueOf(obj));
    }

    @Override
    public PrintStream printf(String format, Object ... args) {
        return this.format(format, args);
    }

    @Override
    public PrintStream printf(Locale l, String format, Object ... args) {
        return this.format(l, format, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrintStream format(String format, Object ... args) {
        ConsolePrintStream consolePrintStream = this;
        synchronized (consolePrintStream) {
            this.getFormatter().format(format, args);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrintStream format(Locale l, String format, Object ... args) {
        ConsolePrintStream consolePrintStream = this;
        synchronized (consolePrintStream) {
            this.getFormatter().format(l, format, args);
            return this;
        }
    }

    @Override
    public PrintStream append(CharSequence csq) {
        this.print(csq);
        return this;
    }

    @Override
    public PrintStream append(CharSequence csq, int start, int end) {
        this.print(csq.subSequence(start, end).toString());
        return this;
    }

    @Override
    public PrintStream append(char c) {
        this.print(c);
        return this;
    }

    private Formatter getFormatter() {
        if (this.formatter == null) {
            this.formatter = new Formatter(this);
        }
        return this.formatter;
    }
}

