/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.welcome;

import co.codewizards.cloudstore.core.util.StringUtil;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.subshare.core.observable.ObservableList;
import org.subshare.core.pgp.CreatePgpKeyParam;
import org.subshare.gui.backup.imp.ImportBackupData;
import org.subshare.gui.pgp.createkey.FxPgpUserId;
import org.subshare.gui.pgp.createkey.TimeUnit;

public class IdentityData {
    private final CreatePgpKeyParam createPgpKeyParam = new CreatePgpKeyParam();
    private final ImportBackupData importBackupData = new ImportBackupData();
    private final StringProperty firstNameProperty = new SimpleStringProperty((Object)this, "firstName");
    private final StringProperty lastNameProperty = new SimpleStringProperty((Object)this, "lastName");
    private final FxPgpUserId pgpUserId = new FxPgpUserId();
    private final BooleanProperty importBackupProperty = new SimpleBooleanProperty((Object)this, "importBackup");

    public IdentityData() {
        this.createPgpKeyParam.setValiditySeconds(TimeUnit.YEAR.getSeconds() * 10L);
        this.getPgpUserId();
        this.firstNameProperty.addListener(observable -> this.updatePgpUserIdName());
        this.lastNameProperty.addListener(observable -> this.updatePgpUserIdName());
    }

    private void updatePgpUserIdName() {
        String firstName = StringUtil.trim((String)((String)this.firstNameProperty.get()));
        String lastName = StringUtil.trim((String)((String)this.lastNameProperty.get()));
        StringBuilder sb = new StringBuilder();
        if (!StringUtil.isEmpty((String)firstName)) {
            sb.append(firstName);
        }
        if (!StringUtil.isEmpty((String)lastName)) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(lastName);
        }
        this.getPgpUserId().setName(sb.toString());
    }

    public CreatePgpKeyParam getCreatePgpKeyParam() {
        return this.createPgpKeyParam;
    }

    public ImportBackupData getImportBackupData() {
        return this.importBackupData;
    }

    public FxPgpUserId getPgpUserId() {
        ObservableList userIds = this.createPgpKeyParam.getUserIds();
        if (userIds.isEmpty() || userIds.get(0) != this.pgpUserId) {
            userIds.remove((Object)this.pgpUserId);
            userIds.add(0, (Object)this.pgpUserId);
        }
        return this.pgpUserId;
    }

    public StringProperty firstNameProperty() {
        return this.firstNameProperty;
    }

    public StringProperty lastNameProperty() {
        return this.lastNameProperty;
    }

    public BooleanProperty importBackupProperty() {
        return this.importBackupProperty;
    }
}

