/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.util;

import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DebugUtil {
    private static final Logger logger = LoggerFactory.getLogger(DebugUtil.class);
    private static final long KIB = 1024L;
    private static final long MIB = 0x100000L;
    private static final long GIB = 0x40000000L;
    private static final long TIB = 0x10000000000L;

    private DebugUtil() {
    }

    public static void logMemoryStats(Logger logger) {
        if (logger == null) {
            logger = DebugUtil.logger;
        }
        if (!logger.isInfoEnabled()) {
            return;
        }
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        long max = runtime.maxMemory();
        long allocated = runtime.totalMemory();
        long used = allocated - runtime.freeMemory();
        long available = max - used;
        logger.info("logMemoryStats: max={}, allocated={}, used={}, available={}", new Object[]{DebugUtil.getHumanReadableSize(max), DebugUtil.getHumanReadableSize(allocated), DebugUtil.getHumanReadableSize(used), DebugUtil.getHumanReadableSize(available)});
    }

    private static String getHumanReadableSize(long size) {
        if (size >= 0x10000000000L) {
            return String.format("%.1f TiB", (double)size / 1.099511627776E12);
        }
        if (size >= 0x40000000L) {
            return String.format("%.1f GiB", (double)size / 1.073741824E9);
        }
        if (size >= 0x100000L) {
            return String.format("%.1f MiB", (double)size / 1048576.0);
        }
        if (size >= 1024L) {
            return String.format("%.1f KiB", (double)size / 1024.0);
        }
        return String.format("%d B", size);
    }

    public static void logSystemProperties() {
        if (!logger.isDebugEnabled()) {
            return;
        }
        TreeMap<String, String> sortedSystemProperties = new TreeMap<String, String>();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String key = String.valueOf(entry.getKey());
            String value = String.valueOf(entry.getValue());
            sortedSystemProperties.put(key, value);
        }
        logger.debug(">>> System properties BEGIN >>>");
        for (Map.Entry<Object, Object> entry : sortedSystemProperties.entrySet()) {
            logger.debug("  * {} = {}", entry.getKey(), entry.getValue());
        }
        logger.debug("<<< System properties END <<<");
    }
}

