/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.util.PropertiesUtil;
import co.codewizards.cloudstore.local.PersistencePropertiesVariableProvider;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.UUID;

public class PersistencePropertiesProvider {
    private final UUID repositoryId;
    private final File localRoot;
    private File overridePersistencePropertiesFile;

    public PersistencePropertiesProvider(UUID repositoryId, File localRoot) {
        this.repositoryId = Objects.requireNonNull(repositoryId, "repositoryId");
        this.localRoot = Objects.requireNonNull(localRoot, "localRoot");
        if (!localRoot.isDirectory()) {
            throw new IllegalArgumentException("The given localRoot is not an existing directory: " + localRoot.getAbsolutePath());
        }
    }

    private File getMetaDir() {
        return OioFileFactory.createFile((File)this.localRoot, (String[])new String[]{LocalRepoManager.META_DIR_NAME});
    }

    public File getOverridePersistencePropertiesFile() {
        return this.overridePersistencePropertiesFile;
    }

    public void setOverridePersistencePropertiesFile(File persistencePropertiesFile) {
        this.overridePersistencePropertiesFile = persistencePropertiesFile;
    }

    public Map<String, String> getPersistenceProperties() {
        Properties rawProperties;
        File persistencePropertiesFile;
        File metaDirectory;
        File file = metaDirectory = this.overridePersistencePropertiesFile != null ? null : this.getMetaDir();
        if (metaDirectory != null && !metaDirectory.isDirectory()) {
            throw new IllegalStateException("The localRoot does not contain the meta-directory: " + metaDirectory.getAbsolutePath());
        }
        File file2 = persistencePropertiesFile = this.overridePersistencePropertiesFile != null ? this.overridePersistencePropertiesFile : OioFileFactory.createFile((File)metaDirectory, (String[])new String[]{LocalRepoManager.PERSISTENCE_PROPERTIES_FILE_NAME});
        if (!persistencePropertiesFile.isFile()) {
            throw new IllegalStateException("The persistencePropertiesFile does not exist or is not a file: " + persistencePropertiesFile.getAbsolutePath());
        }
        HashMap<String, Object> variablesMap = new HashMap<String, Object>();
        variablesMap.put("repository.id", this.repositoryId);
        variablesMap.put("repository.localRoot", this.localRoot.getPath());
        variablesMap.put("repository.metaDir", this.getMetaDir().getPath());
        LinkedList<PersistencePropertiesVariableProvider> variableProviders = new LinkedList<PersistencePropertiesVariableProvider>();
        for (PersistencePropertiesVariableProvider provider : ServiceLoader.load(PersistencePropertiesVariableProvider.class)) {
            variableProviders.add(provider);
        }
        Collections.sort(variableProviders, new Comparator<PersistencePropertiesVariableProvider>(){

            @Override
            public int compare(PersistencePropertiesVariableProvider o1, PersistencePropertiesVariableProvider o2) {
                int res = Integer.compare(o1.getPriority(), o2.getPriority());
                if (res == 0) {
                    res = o1.getClass().getName().compareTo(o2.getClass().getName());
                }
                return res;
            }
        });
        for (PersistencePropertiesVariableProvider provider : variableProviders) {
            provider.populatePersistencePropertiesVariableMap(variablesMap);
        }
        try {
            rawProperties = PropertiesUtil.load((File)persistencePropertiesFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Map persistenceProperties = PropertiesUtil.filterProperties((Map)rawProperties, variablesMap);
        return persistenceProperties;
    }
}

