/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.dbupdate;

import co.codewizards.cloudstore.local.dbupdate.AbstractDbUpdateStep;
import co.codewizards.cloudstore.local.dbupdate.DatabaseType;
import java.sql.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbUpdateStep004
extends AbstractDbUpdateStep {
    private static final Logger logger = LoggerFactory.getLogger(DbUpdateStep004.class);

    public int getVersion() {
        return 4;
    }

    public void performUpdate() throws Exception {
        logger.info("performUpdate: entered.");
        try (Connection connection = this.getDatabaseAdapterOrFail().createConnection();){
            DatabaseType databaseType = DbUpdateStep004.getDatabaseType((Connection)connection);
            if (databaseType != DatabaseType.DERBY) {
                logger.info("performUpdate: This update-step is not supported for the database-type {}. Skipping!", (Object)databaseType);
                return;
            }
            logger.info("performUpdate: Database-type: {}", (Object)databaseType);
            String tableName = "LastCryptoKeySyncToRemoteRepo";
            String columnName = "resyncMode";
            if (!DbUpdateStep004.doesTableExist((Connection)connection, (String)"LastCryptoKeySyncToRemoteRepo")) {
                logger.info("performUpdate: Table '{}' does not exist!", (Object)"LastCryptoKeySyncToRemoteRepo");
                return;
            }
            logger.info("performUpdate: Table '{}' does exist! Checking for existence of column '{}'.", (Object)"LastCryptoKeySyncToRemoteRepo", (Object)"resyncMode");
            if (!DbUpdateStep004.doesColumnExist((Connection)connection, (String)"LastCryptoKeySyncToRemoteRepo", (String)"resyncMode")) {
                DbUpdateStep004.addColumnBooleanNotNull((Connection)connection, (String)"LastCryptoKeySyncToRemoteRepo", (String)"resyncMode");
            }
        }
    }
}

