/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.dto;

import co.codewizards.cloudstore.core.objectfactory.ObjectFactoryUtil;
import java.util.Objects;
import org.subshare.core.dto.CryptoRepoFileDto;
import org.subshare.local.persistence.CryptoKey;
import org.subshare.local.persistence.CryptoRepoFile;

public class CryptoRepoFileDtoConverter {
    public static CryptoRepoFileDtoConverter create() {
        return (CryptoRepoFileDtoConverter)ObjectFactoryUtil.createObject(CryptoRepoFileDtoConverter.class);
    }

    protected CryptoRepoFileDtoConverter() {
    }

    public CryptoRepoFileDto toCryptoRepoFileDto(CryptoRepoFile cryptoRepoFile) {
        Objects.requireNonNull(cryptoRepoFile, "cryptoRepoFile");
        CryptoRepoFileDto cryptoRepoFileDto = new CryptoRepoFileDto();
        cryptoRepoFileDto.setCryptoRepoFileId(cryptoRepoFile.getCryptoRepoFileId());
        CryptoRepoFile parent = cryptoRepoFile.getParent();
        cryptoRepoFileDto.setParentCryptoRepoFileId(parent == null ? null : parent.getCryptoRepoFileId());
        CryptoKey cryptoKey = Objects.requireNonNull(cryptoRepoFile.getCryptoKey(), "cryptoRepoFile.cryptoKey");
        cryptoRepoFileDto.setCryptoKeyId(cryptoKey.getCryptoKeyId());
        cryptoRepoFileDto.setDirectory(cryptoRepoFile.isDirectory());
        byte[] repoFileDtoData = Objects.requireNonNull(cryptoRepoFile.getRepoFileDtoData(), "cryptoRepoFile.repoFileDtoData");
        cryptoRepoFileDto.setRepoFileDtoData(repoFileDtoData);
        cryptoRepoFileDto.setCryptoRepoFileCreated(cryptoRepoFile.getCryptoRepoFileCreated());
        cryptoRepoFileDto.setDeleted(cryptoRepoFile.getDeleted());
        cryptoRepoFileDto.setDeletedByIgnoreRule(cryptoRepoFile.isDeletedByIgnoreRule());
        cryptoRepoFileDto.setSignature(Objects.requireNonNull(cryptoRepoFile.getSignature(), "cryptoRepoFile.signature"));
        return cryptoRepoFileDto;
    }
}

