/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.local.persistence.Dao;
import java.util.Collection;
import java.util.Objects;
import javax.jdo.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.local.persistence.DeletedCollision;

public class DeletedCollisionDao
extends Dao<DeletedCollision, DeletedCollisionDao> {
    private static final Logger logger = LoggerFactory.getLogger(DeletedCollisionDao.class);

    public DeletedCollision getDeletedCollisionOrFail(Uid collisionId) {
        DeletedCollision result = this.getDeletedCollision(collisionId);
        Objects.requireNonNull(result, "getDeletedCollision(" + collisionId + ")");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeletedCollision getDeletedCollision(Uid collisionId) {
        Objects.requireNonNull(collisionId, "collisionId");
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getDeletedCollision_collisionId");
        try {
            DeletedCollision result;
            DeletedCollision deletedCollision = result = (DeletedCollision)((Object)query.execute((Object)collisionId.toString()));
            return deletedCollision;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DeletedCollision> getDeletedCollisionsChangedAfter(long localRevision) {
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getDeletedCollisionsChangedAfter_localRevision");
        try {
            long startTimestamp = System.currentTimeMillis();
            Collection result = (Collection)query.execute((Object)localRevision);
            logger.debug("getDeletedCollisionsChangedAfter: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            result = this.load(result);
            logger.debug("getDeletedCollisionsChangedAfter: Loading result-set with {} elements took {} ms.", (Object)result.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = result;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }
}

