/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.pgp.transport;

import co.codewizards.cloudstore.core.util.UrlUtil;
import java.net.URL;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.pgp.transport.PgpTransport;
import org.subshare.core.pgp.transport.PgpTransportFactory;

public abstract class AbstractPgpTransport
implements PgpTransport {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPgpTransport.class);
    private static final String SLASH = "/";
    private PgpTransportFactory pgpTransportFactory;
    private URL url;
    private volatile Throwable pgpTransportCreatedStackTraceException = new Exception("pgpTransportCreatedStackTraceException").fillInStackTrace();

    @Override
    public PgpTransportFactory getPgpTransportFactory() {
        return this.pgpTransportFactory;
    }

    @Override
    public void setPgpTransportFactory(PgpTransportFactory pgpTransportFactory) {
        this.pgpTransportFactory = Objects.requireNonNull(pgpTransportFactory, "pgpTransportFactory");
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(URL url) {
        url = UrlUtil.canonicalizeURL((URL)url);
        URL rr = this.url;
        if (rr != null && !rr.equals(url)) {
            throw new IllegalStateException("Cannot re-assign url!");
        }
        this.url = url;
    }

    protected void finalize() throws Throwable {
        if (this.pgpTransportCreatedStackTraceException != null) {
            logger.warn("finalize: Detected forgotten close() invocation!", this.pgpTransportCreatedStackTraceException);
        }
        super.finalize();
    }

    @Override
    public void close() {
        this.pgpTransportCreatedStackTraceException = null;
    }
}

