/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.sign;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.auth.SignatureException;
import co.codewizards.cloudstore.core.io.ByteArrayInputStream;
import co.codewizards.cloudstore.core.util.IOUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Signer;
import org.subshare.core.sign.Signable;
import org.subshare.core.sign.Signature;
import org.subshare.core.sign.SignerTransformation;
import org.subshare.core.user.UserRepoKey;
import org.subshare.core.user.UserRepoKeyPublicKeyLookup;
import org.subshare.crypto.CryptoRegistry;

public class SignableVerifier {
    private static final int BUFFER_SIZE = 32768;
    private final UserRepoKeyPublicKeyLookup lookup;
    private final Map<SignerTransformation, Signer> signerTransformation2Signer = new HashMap<SignerTransformation, Signer>(2);

    public SignableVerifier(UserRepoKeyPublicKeyLookup lookup) {
        this.lookup = Objects.requireNonNull(lookup, "lookup");
    }

    public void verify(Signable signable) throws SignatureException {
        Signature signature = Objects.requireNonNull(signable, "signable").getSignature();
        if (signature == null) {
            throw new SignatureException("There is no signature! signable.signature == null");
        }
        String signedDataType = signable.getSignedDataType();
        if (StringUtil.isEmpty((String)signedDataType)) {
            throw new IllegalArgumentException(String.format("Implementation error in class %s: signable.getSignedDataType() returned null! %s", signable.getClass().getName(), signable));
        }
        Date signatureCreated = signature.getSignatureCreated();
        if (signatureCreated == null) {
            throw new SignatureException("There is no signature! signable.signature.signatureCreated == null");
        }
        Uid signingUserRepoKeyId = signature.getSigningUserRepoKeyId();
        if (signingUserRepoKeyId == null) {
            throw new SignatureException("There is no signature! signable.signature.signingUserRepoKeyId == null");
        }
        byte[] signatureData = signature.getSignatureData();
        if (signatureData == null) {
            throw new SignatureException("There is no signature! signable.signature.signatureData == null");
        }
        if (signatureData.length < 3) {
            throw new SignatureException("There is no signature! signatureData.length < 3");
        }
        UserRepoKey.PublicKey userRepoKeyPublicKey = this.lookup.getUserRepoKeyPublicKey(signingUserRepoKeyId);
        if (userRepoKeyPublicKey == null) {
            throw new SignatureException(String.format("No public key found for signingUserRepoKeyId=%s!", signingUserRepoKeyId));
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(signatureData);
            int version = in.read();
            if (version != 1) {
                throw new SignatureException(String.format("signatureData has unsupported version=%s!", version));
            }
            int signerTransformationNumeric = IOUtil.readOrFail((InputStream)in) + (IOUtil.readOrFail((InputStream)in) << 8);
            if (signerTransformationNumeric > SignerTransformation.values().length) {
                throw new IOException(String.format("signerTransformationNumeric > SignerTransformation.values().length :: %s > %s", signerTransformationNumeric, SignerTransformation.values().length));
            }
            SignerTransformation signerTransformation = SignerTransformation.values()[signerTransformationNumeric];
            int signedDataVersion = IOUtil.readOrFail((InputStream)in) + (IOUtil.readOrFail((InputStream)in) << 8);
            int signatureBytesLength = IOUtil.readOrFail((InputStream)in) + (IOUtil.readOrFail((InputStream)in) << 8) + (IOUtil.readOrFail((InputStream)in) << 16) + (IOUtil.readOrFail((InputStream)in) << 24);
            byte[] signatureBytes = new byte[signatureBytesLength];
            IOUtil.readOrFail((InputStream)in, (byte[])signatureBytes, (int)0, (int)signatureBytesLength);
            Signer signer = this.getSigner(signerTransformation);
            signer.init(false, (CipherParameters)userRepoKeyPublicKey.getPublicKey());
            byte[] signedDataTypeBytes = signedDataType.getBytes(StandardCharsets.UTF_8);
            signer.update(signedDataTypeBytes, 0, signedDataTypeBytes.length);
            byte[] signatureCreatedBytes = IOUtil.longToBytes((long)signatureCreated.getTime());
            signer.update(signatureCreatedBytes, 0, signatureCreatedBytes.length);
            byte[] buf = new byte[32768];
            try (InputStream signedDataInputStream = signable.getSignedData(signedDataVersion);){
                int bytesRead;
                while ((bytesRead = signedDataInputStream.read(buf)) >= 0) {
                    if (bytesRead <= 0) continue;
                    signer.update(buf, 0, bytesRead);
                }
            }
            if (!signer.verifySignature(signatureBytes)) {
                throw new SignatureException("Signature not valid: " + signable);
            }
        }
        catch (IOException x) {
            throw new SignatureException((Throwable)x);
        }
    }

    private Signer getSigner(SignerTransformation signerTransformation) {
        Objects.requireNonNull(signerTransformation, "signerTransformation");
        Signer signer = this.signerTransformation2Signer.get((Object)signerTransformation);
        if (signer == null) {
            try {
                signer = CryptoRegistry.getInstance().createSigner(signerTransformation.getTransformation());
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            this.signerTransformation2Signer.put(signerTransformation, signer);
        }
        return signer;
    }
}

