/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.repo.metaonly;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.collection.ListMerger;
import co.codewizards.cloudstore.core.dto.DirectoryDto;
import co.codewizards.cloudstore.core.dto.NormalFileDto;
import co.codewizards.cloudstore.core.dto.RepoFileDto;
import co.codewizards.cloudstore.core.dto.SymlinkDto;
import co.codewizards.cloudstore.core.util.UrlUtil;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.subshare.core.dto.CryptoRepoFileDto;
import org.subshare.core.repo.ServerRepo;
import org.subshare.core.repo.listener.LocalRepoCommitEvent;
import org.subshare.core.repo.listener.LocalRepoCommitEventListener;
import org.subshare.core.repo.listener.LocalRepoCommitEventManagerImpl;
import org.subshare.core.repo.listener.WeakLocalRepoCommitEventListener;
import org.subshare.core.repo.metaonly.MetaOnlyRepoManagerImpl;
import org.subshare.core.repo.metaonly.ServerRepoFile;
import org.subshare.core.repo.metaonly.ServerRepoFileType;
import org.subshare.core.server.Server;

public class ServerRepoFileImpl
implements ServerRepoFile {
    private final ServerRepoFileImpl parent;
    private final long repoFileId;
    private CryptoRepoFileDto cryptoRepoFileDto;
    private RepoFileDto repoFileDto;
    private final Server server;
    private final ServerRepo serverRepo;
    private final UUID localRepositoryId;
    private List<ServerRepoFile> children;
    private boolean childrenInvalid;
    private final LocalRepoCommitEventListener localRepoCommitEventListener = new LocalRepoCommitEventListener(){

        @Override
        public void postCommit(LocalRepoCommitEvent event) {
            ServerRepoFileImpl.this.invalidate();
        }
    };
    private final WeakLocalRepoCommitEventListener weakLocalRepoCommitEventListener;

    public ServerRepoFileImpl(Server server, ServerRepo serverRepo, UUID localRepositoryId, CryptoRepoFileDto cryptoRepoFileDto, RepoFileDto repoFileDto) {
        this.parent = null;
        this.server = Objects.requireNonNull(server, "server");
        this.serverRepo = Objects.requireNonNull(serverRepo, "serverRepo");
        this.localRepositoryId = Objects.requireNonNull(localRepositoryId, "localRepositoryId");
        this.cryptoRepoFileDto = Objects.requireNonNull(cryptoRepoFileDto, "cryptoRepoFileDto");
        this.repoFileDto = Objects.requireNonNull(repoFileDto, "repoFileDto");
        this.repoFileId = repoFileDto.getId();
        this.weakLocalRepoCommitEventListener = new WeakLocalRepoCommitEventListener(LocalRepoCommitEventManagerImpl.getInstance(), localRepositoryId, this.localRepoCommitEventListener);
        this.weakLocalRepoCommitEventListener.addLocalRepoCommitEventListener();
    }

    public ServerRepoFileImpl(ServerRepoFileImpl parent, CryptoRepoFileDto cryptoRepoFileDto, RepoFileDto repoFileDto) {
        this.parent = Objects.requireNonNull(parent, "parent");
        this.server = parent.getServer();
        this.serverRepo = parent.getServerRepo();
        this.localRepositoryId = parent.getLocalRepositoryId();
        this.cryptoRepoFileDto = Objects.requireNonNull(cryptoRepoFileDto, "cryptoRepoFileDto");
        this.repoFileDto = Objects.requireNonNull(repoFileDto, "repoFileDto");
        this.repoFileId = repoFileDto.getId();
        this.weakLocalRepoCommitEventListener = new WeakLocalRepoCommitEventListener(LocalRepoCommitEventManagerImpl.getInstance(), this.localRepositoryId, this.localRepoCommitEventListener);
        this.weakLocalRepoCommitEventListener.addLocalRepoCommitEventListener();
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public ServerRepo getServerRepo() {
        return this.serverRepo;
    }

    @Override
    public UUID getLocalRepositoryId() {
        return this.localRepositoryId;
    }

    @Override
    public ServerRepoFile getParent() {
        return this.parent;
    }

    @Override
    public ServerRepoFileType getType() {
        RepoFileDto repoFileDto = this.getRepoFileDto();
        if (repoFileDto instanceof NormalFileDto) {
            return ServerRepoFileType.FILE;
        }
        if (repoFileDto instanceof DirectoryDto) {
            return ServerRepoFileType.DIRECTORY;
        }
        if (repoFileDto instanceof SymlinkDto) {
            return ServerRepoFileType.SYMLINK;
        }
        Objects.requireNonNull(repoFileDto, "repoFileDto");
        throw new IllegalStateException("Unknown RepoFileDto sub-class: " + repoFileDto.getClass().getName());
    }

    @Override
    public String getLocalName() {
        return this.getRepoFileDto().getName();
    }

    @Override
    public String getLocalPath() {
        String parentPath = this.parent == null ? "" : this.parent.getLocalPath();
        return ServerRepoFileImpl.appendPath(parentPath, this.getLocalName());
    }

    @Override
    public Uid getCryptoRepoFileId() {
        return this.cryptoRepoFileDto.getCryptoRepoFileId();
    }

    public String getServerName() {
        if ("/".equals(this.getLocalPath())) {
            return "";
        }
        return this.getCryptoRepoFileId().toString();
    }

    @Override
    public String getServerPath() {
        String parentPath = this.parent == null ? "" : this.parent.getServerPath();
        return ServerRepoFileImpl.appendPath(parentPath, this.getServerName());
    }

    private static String appendPath(String path1, String path2) {
        StringBuilder sb = new StringBuilder(path1.length() + path2.length() + 1);
        sb.append(path1);
        if (!path1.endsWith("/")) {
            sb.append('/');
        }
        sb.append(path2);
        return sb.toString();
    }

    @Override
    public URL getServerUrl() {
        URL url = this.server.getUrl();
        url = UrlUtil.appendNonEncodedPath((URL)url, (String)this.serverRepo.getRepositoryId().toString());
        url = UrlUtil.appendEncodedPath((URL)url, (String)this.getServerPath());
        return url;
    }

    public synchronized CryptoRepoFileDto getCryptoRepoFileDto() {
        if (this.cryptoRepoFileDto == null) {
            this.getRepoFileDto();
            Objects.requireNonNull(this.cryptoRepoFileDto, "cryptoRepoFileDto");
        }
        return this.cryptoRepoFileDto;
    }

    public synchronized RepoFileDto getRepoFileDto() {
        if (this.repoFileDto == null) {
            ServerRepoFileImpl serverRepoFile = (ServerRepoFileImpl)this.getReadOnlyMetaRepoManager().getServerRepoFile(this.serverRepo, this.repoFileId);
            this.copyFrom(Objects.requireNonNull(serverRepoFile, "serverRepoFile"));
        }
        return this.repoFileDto;
    }

    protected void copyFrom(ServerRepoFileImpl serverRepoFile) {
        Objects.requireNonNull(serverRepoFile, "serverRepoFile");
        this.repoFileDto = serverRepoFile.getRepoFileDto();
        this.cryptoRepoFileDto = serverRepoFile.getCryptoRepoFileDto();
    }

    @Override
    public long getRepoFileId() {
        return this.repoFileId;
    }

    @Override
    public synchronized List<ServerRepoFile> getChildren() {
        if (this.children == null || this.childrenInvalid) {
            List<ServerRepoFile> c = this.getReadOnlyMetaRepoManager().getChildServerRepoFiles(this);
            if (this.children == null || c == null) {
                this.children = c;
            } else {
                new ChildrenListMerger().merge(c, this.children);
            }
            this.childrenInvalid = false;
        }
        return this.children;
    }

    protected synchronized void invalidate() {
        this.childrenInvalid = true;
        this.cryptoRepoFileDto = null;
        this.repoFileDto = null;
    }

    protected MetaOnlyRepoManagerImpl getReadOnlyMetaRepoManager() {
        return (MetaOnlyRepoManagerImpl)MetaOnlyRepoManagerImpl.getInstance();
    }

    protected static class ChildrenListMerger
    extends ListMerger<ServerRepoFile, Long> {
        protected ChildrenListMerger() {
        }

        protected Long getKey(ServerRepoFile element) {
            return element.getRepoFileId();
        }

        protected void update(List<ServerRepoFile> dest, int index, ServerRepoFile sourceElement, ServerRepoFile destElement) {
            ServerRepoFileImpl se = (ServerRepoFileImpl)sourceElement;
            ServerRepoFileImpl de = (ServerRepoFileImpl)destElement;
            de.copyFrom(se);
        }
    }
}

