/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.local.persistence.Dao;
import java.util.Collection;
import java.util.UUID;
import javax.jdo.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.local.persistence.CryptoConfigPropSet;
import org.subshare.local.persistence.CryptoRepoFile;

public class CryptoConfigPropSetDao
extends Dao<CryptoConfigPropSet, CryptoConfigPropSetDao> {
    private static final Logger logger = LoggerFactory.getLogger(CryptoConfigPropSetDao.class);

    public CryptoConfigPropSet getCryptoConfigPropSetOrFail(CryptoRepoFile cryptoRepoFile) {
        CryptoConfigPropSet result = this.getCryptoConfigPropSet(cryptoRepoFile);
        if (result == null) {
            throw new IllegalArgumentException("There is no CryptoConfigPropSet for: " + (Object)((Object)cryptoRepoFile));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CryptoConfigPropSet getCryptoConfigPropSet(CryptoRepoFile cryptoRepoFile) {
        AssertUtil.assertNotNull((Object)((Object)cryptoRepoFile), (String)"cryptoRepoFile");
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getCryptoConfigPropSet_cryptoRepoFile");
        try {
            CryptoConfigPropSet result;
            CryptoConfigPropSet cryptoConfigPropSet = result = (CryptoConfigPropSet)((Object)query.execute((Object)cryptoRepoFile));
            return cryptoConfigPropSet;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CryptoConfigPropSet> getCryptoConfigPropSetsChangedAfterExclLastSyncFromRepositoryId(long localRevision, UUID exclLastSyncFromRepositoryId) {
        AssertUtil.assertNotNull((Object)exclLastSyncFromRepositoryId, (String)"exclLastSyncFromRepositoryId");
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getCryptoConfigPropSetsChangedAfter_localRevision_exclLastSyncFromRepositoryId");
        try {
            long startTimestamp = System.currentTimeMillis();
            Collection result = (Collection)query.execute((Object)localRevision, (Object)exclLastSyncFromRepositoryId.toString());
            logger.debug("getCryptoConfigPropSetsChangedAfterExclLastSyncFromRepositoryId: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            result = this.load(result);
            logger.debug("getCryptoConfigPropSetsChangedAfterExclLastSyncFromRepositoryId: Loading result-set with {} elements took {} ms.", (Object)result.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = result;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }
}

