/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.crypto.internal.symmetric;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.engines.Grain128Engine;
import org.bouncycastle.crypto.engines.Grainv1Engine;
import org.bouncycastle.crypto.engines.HC128Engine;
import org.bouncycastle.crypto.engines.HC256Engine;
import org.bouncycastle.crypto.engines.ISAACEngine;
import org.bouncycastle.crypto.engines.RC4Engine;
import org.bouncycastle.crypto.engines.Salsa20Engine;
import org.subshare.crypto.AbstractCipher;
import org.subshare.crypto.CipherOperationMode;

public class StreamCipherImpl
extends AbstractCipher {
    private final StreamCipher delegate;
    private int ivSize = -1;

    public StreamCipherImpl(String transformation, StreamCipher delegate) {
        super(transformation);
        this.delegate = delegate;
    }

    @Override
    public void _init(CipherOperationMode mode, CipherParameters parameters) throws IllegalArgumentException {
        this.delegate.init(CipherOperationMode.ENCRYPT == mode, parameters);
    }

    @Override
    public void reset() {
        this.delegate.reset();
    }

    @Override
    public int getInputBlockSize() {
        return 1;
    }

    @Override
    public int getOutputBlockSize() {
        return 1;
    }

    @Override
    public int getUpdateOutputSize(int length) {
        return length;
    }

    @Override
    public int getOutputSize(int length) {
        return length;
    }

    @Override
    public int update(byte in, byte[] out, int outOff) throws DataLengthException, IllegalStateException, CryptoException {
        out[outOff] = this.delegate.returnByte(in);
        return 1;
    }

    @Override
    public int update(byte[] in, int inOff, int inLen, byte[] out, int outOff) throws DataLengthException, IllegalStateException, CryptoException {
        return this.delegate.processBytes(in, inOff, inLen, out, outOff);
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws DataLengthException, IllegalStateException, CryptoException {
        return 0;
    }

    @Override
    public int getIVSize() {
        if (this.ivSize < 0) {
            if (this.delegate instanceof Grainv1Engine) {
                this.ivSize = 8;
            } else if (this.delegate instanceof Grain128Engine) {
                this.ivSize = 12;
            } else if (this.delegate instanceof HC128Engine) {
                this.ivSize = 16;
            } else if (this.delegate instanceof HC256Engine) {
                this.ivSize = 32;
            } else if (this.delegate instanceof ISAACEngine) {
                this.ivSize = 0;
            } else if (this.delegate instanceof RC4Engine) {
                this.ivSize = 0;
            } else if (this.delegate instanceof Salsa20Engine) {
                this.ivSize = 8;
            } else {
                throw new UnsupportedOperationException("For this delegate cipher type, this operation is not yet supported!");
            }
        }
        return this.ivSize;
    }
}

