/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.PropertiesUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;

public class PersistencePropertiesProvider {
    private final UUID repositoryId;
    private final File localRoot;

    public PersistencePropertiesProvider(UUID repositoryId, File localRoot) {
        this.repositoryId = (UUID)AssertUtil.assertNotNull((Object)repositoryId, (String)"repositoryId");
        this.localRoot = (File)AssertUtil.assertNotNull((Object)localRoot, (String)"localRoot");
        if (!localRoot.isDirectory()) {
            throw new IllegalArgumentException("The given localRoot is not an existing directory: " + localRoot.getAbsolutePath());
        }
    }

    private File getMetaDir() {
        return OioFileFactory.createFile((File)this.localRoot, (String[])new String[]{LocalRepoManager.META_DIR_NAME});
    }

    public Map<String, String> getPersistenceProperties() {
        Properties rawProperties;
        File metaDirectory = this.getMetaDir();
        if (!metaDirectory.isDirectory()) {
            throw new IllegalStateException("The localRoot does not contain the meta-directory: " + metaDirectory.getAbsolutePath());
        }
        File persistencePropertiesFile = OioFileFactory.createFile((File)metaDirectory, (String[])new String[]{LocalRepoManager.PERSISTENCE_PROPERTIES_FILE_NAME});
        if (!persistencePropertiesFile.isFile()) {
            throw new IllegalStateException("The persistencePropertiesFile does not exist or is not a file: " + persistencePropertiesFile.getAbsolutePath());
        }
        HashMap<String, Object> variablesMap = new HashMap<String, Object>();
        variablesMap.put("repository.id", this.repositoryId);
        variablesMap.put("repository.localRoot", this.localRoot.getPath());
        variablesMap.put("repository.metaDir", this.getMetaDir().getPath());
        try {
            rawProperties = PropertiesUtil.load((File)persistencePropertiesFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Map persistenceProperties = PropertiesUtil.filterProperties((Map)rawProperties, variablesMap);
        return persistenceProperties;
    }
}

