/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.pgp.keytree;

import co.codewizards.cloudstore.core.bean.Bean;
import co.codewizards.cloudstore.core.bean.PropertyBase;
import co.codewizards.cloudstore.core.bean.PropertyChangeListenerUtil;
import co.codewizards.cloudstore.core.bean.WeakPropertyChangeListener;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableView;
import org.subshare.core.pgp.Pgp;
import org.subshare.gui.pgp.keytree.PgpKeyTreePane;
import org.subshare.gui.util.PlatformUtil;

public class PgpKeyTreeItem<T>
extends TreeItem<PgpKeyTreeItem<?>> {
    private T valueObject;
    private final BooleanProperty checked = new SimpleBooleanProperty((Object)this, "checked"){

        public void set(boolean newValue) {
            super.set(newValue);
            if (newValue) {
                PgpKeyTreeItem.this.getPgpKeyTreePane().getCheckedTreeItems().add((Object)PgpKeyTreeItem.this);
            } else {
                PgpKeyTreeItem.this.getPgpKeyTreePane().getCheckedTreeItems().remove((Object)PgpKeyTreeItem.this);
            }
        }
    };
    private final PropertyChangeListener trustDbPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Platform.runLater(() -> PgpKeyTreeItem.this.updateKeyValidityAndOwnerTrust());
        }
    };
    private WeakPropertyChangeListener trustDbWeakPropertyChangeListener;
    private InvalidationListener pgpInvalidationListener = observable -> this.onPgpInvalidated();
    private PgpKeyTreePane pgpKeyTreePane;
    private final StringProperty keyValidity = new SimpleStringProperty((Object)this, "keyValidity");
    private final StringProperty ownerTrust = new SimpleStringProperty((Object)this, "ownerTrust");

    public PgpKeyTreeItem(T valueObject) {
        this(valueObject, null);
    }

    public PgpKeyTreeItem(T valueObject, Node graphic) {
        this.setValue((Object)this);
        this.valueObject = valueObject;
        this.setGraphic(graphic);
    }

    protected void updateKeyValidityAndOwnerTrust() {
        this.keyValidity.set((Object)this.getKeyValidity());
        this.ownerTrust.set((Object)this.getOwnerTrust());
    }

    protected T getValueObject() {
        return this.valueObject;
    }

    public BooleanProperty checkedProperty() {
        return this.checked;
    }

    public boolean isChecked() {
        return this.checked.get();
    }

    public void setChecked(boolean checked) {
        this.checked.set(checked);
    }

    public String getName() {
        return this.getValueObject().toString();
    }

    public String getKeyId() {
        return null;
    }

    public String getKeyValidity() {
        return null;
    }

    public ReadOnlyStringProperty keyValidityProperty() {
        if (this.keyValidity.get() == null && this.getKeyValidity() != null) {
            this.hookTrustDbPropertyChangeListener();
            this.updateKeyValidityAndOwnerTrust();
        }
        return this.keyValidity;
    }

    public String getOwnerTrust() {
        return null;
    }

    public ReadOnlyStringProperty ownerTrustProperty() {
        if (this.ownerTrust.get() == null && this.getOwnerTrust() != null) {
            this.hookTrustDbPropertyChangeListener();
            this.updateKeyValidityAndOwnerTrust();
        }
        return this.ownerTrust;
    }

    public String getCreated() {
        return null;
    }

    public String getValidTo() {
        return null;
    }

    public String getAlgorithm() {
        return null;
    }

    public String getStrength() {
        return null;
    }

    public String getUsage() {
        return null;
    }

    protected TreeTableView<PgpKeyTreeItem<?>> getTreeTableView() {
        return this.getPgpKeyTreePane().getTreeTableView();
    }

    protected PgpKeyTreePane getPgpKeyTreePane() {
        if (this.pgpKeyTreePane == null) {
            PgpKeyTreeItem parent = (PgpKeyTreeItem)this.getParent();
            AssertUtil.assertNotNull((Object)((Object)parent), (String)"parent");
            this.pgpKeyTreePane = (PgpKeyTreePane)((Object)AssertUtil.assertNotNull((Object)((Object)parent.getPgpKeyTreePane()), (String)"parent.pgpKeyTreePane"));
            this.pgpKeyTreePane.pgpProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.pgpInvalidationListener));
        }
        return this.pgpKeyTreePane;
    }

    public <I extends PgpKeyTreeItem<?>> I getThisOrParentPgpKeyTreeItemOfType(Class<I> type) {
        AssertUtil.assertNotNull(type, (String)"type");
        if (type.isInstance((Object)this)) {
            return (I)((Object)((PgpKeyTreeItem)((Object)type.cast((Object)this))));
        }
        PgpKeyTreeItem parent = (PgpKeyTreeItem)this.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getThisOrParentPgpKeyTreeItemOfType(type);
    }

    public String toString() {
        return String.format("%s[%s]", ((Object)((Object)this)).getClass().getName(), this.valueObject);
    }

    protected Pgp getPgp() {
        return this.getPgpKeyTreePane().getPgp();
    }

    protected void onPgpInvalidated() {
        if (this.unhookTrustDbPropertyChangeListener()) {
            this.hookTrustDbPropertyChangeListener();
        }
    }

    protected void hookTrustDbPropertyChangeListener() {
        PlatformUtil.assertFxApplicationThread();
        if (this.trustDbWeakPropertyChangeListener == null) {
            Pgp pgp = (Pgp)AssertUtil.assertNotNull((Object)this.getPgp(), (String)"pgp");
            this.trustDbWeakPropertyChangeListener = PropertyChangeListenerUtil.addWeakPropertyChangeListener((Bean)pgp, (PropertyBase)Pgp.PropertyEnum.trustdb, (PropertyChangeListener)this.trustDbPropertyChangeListener);
        }
    }

    protected boolean unhookTrustDbPropertyChangeListener() {
        PlatformUtil.assertFxApplicationThread();
        if (this.trustDbWeakPropertyChangeListener != null) {
            this.trustDbWeakPropertyChangeListener.removePropertyChangeListener();
            this.trustDbWeakPropertyChangeListener = null;
            return true;
        }
        return false;
    }
}

