/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.resolvecollision;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.progress.ProgressMonitor;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import org.subshare.core.dto.CollisionDto;
import org.subshare.core.dto.CollisionPrivateDto;
import org.subshare.core.dto.PlainHistoCryptoRepoFileDto;
import org.subshare.core.repo.LocalRepo;
import org.subshare.core.repo.local.PlainHistoCryptoRepoFileFilter;
import org.subshare.core.repo.local.SsLocalRepoMetaData;
import org.subshare.gui.concurrent.SsTask;
import org.subshare.gui.ls.LocalRepoManagerFactoryLs;
import org.subshare.gui.resolvecollision.CollisionDtoWithPlainHistoCryptoRepoFileDto;
import org.subshare.gui.resolvecollision.ResolveCollisionData;
import org.subshare.gui.resolvecollision.collision.CollisionData;
import org.subshare.gui.resolvecollision.collision.CollisionWizardPage;
import org.subshare.gui.resolvecollision.loading.LoadingWizardPage;
import org.subshare.gui.wizard.Wizard;
import org.subshare.gui.wizard.WizardPage;

public class ResolveCollisionWizard
extends Wizard {
    private final ResolveCollisionData resolveCollisionData;

    public ResolveCollisionWizard(ResolveCollisionData resolveCollisionData) {
        super(new LoadingWizardPage());
        this.resolveCollisionData = (ResolveCollisionData)AssertUtil.assertNotNull((Object)resolveCollisionData, (String)"resolveCollisionData");
    }

    @Override
    public void init() {
        super.init();
        this.loadDataAsync();
    }

    private void loadDataAsync() {
        final PlainHistoCryptoRepoFileFilter phcrfFilter = new PlainHistoCryptoRepoFileFilter();
        phcrfFilter.setCollisionIds(this.resolveCollisionData.getCollisionIds());
        new Service<Collection<CollisionDtoWithPlainHistoCryptoRepoFileDto>>(){

            protected Task<Collection<CollisionDtoWithPlainHistoCryptoRepoFileDto>> createTask() {
                return new SsTask<Collection<CollisionDtoWithPlainHistoCryptoRepoFileDto>>(){

                    protected Collection<CollisionDtoWithPlainHistoCryptoRepoFileDto> call() throws Exception {
                        try (LocalRepoManager localRepoManager = ResolveCollisionWizard.this.createLocalRepoManager();){
                            SsLocalRepoMetaData localRepoMetaData = (SsLocalRepoMetaData)localRepoManager.getLocalRepoMetaData();
                            Collection plainHistoCryptoRepoFileDtos = localRepoMetaData.getPlainHistoCryptoRepoFileDtos(phcrfFilter);
                            HashMap<Uid, CollisionDtoWithPlainHistoCryptoRepoFileDto> collisionId2Dto = new HashMap<Uid, CollisionDtoWithPlainHistoCryptoRepoFileDto>();
                            for (PlainHistoCryptoRepoFileDto plainHistoCryptoRepoFileDto : plainHistoCryptoRepoFileDtos) {
                                CollisionDtoWithPlainHistoCryptoRepoFileDto dto;
                                Uid collisionId;
                                for (CollisionDto collisionDto : plainHistoCryptoRepoFileDto.getCollisionDtos()) {
                                    collisionId = collisionDto.getCollisionId();
                                    dto = (CollisionDtoWithPlainHistoCryptoRepoFileDto)collisionId2Dto.get(collisionId);
                                    if (dto == null) {
                                        dto = new CollisionDtoWithPlainHistoCryptoRepoFileDto();
                                        collisionId2Dto.put(collisionId, dto);
                                    }
                                    dto.setCollisionDto(collisionDto);
                                    if (collisionDto.getHistoCryptoRepoFileId1().equals((Object)plainHistoCryptoRepoFileDto.getHistoCryptoRepoFileDto().getHistoCryptoRepoFileId())) {
                                        dto.setPlainHistoCryptoRepoFileDto1(plainHistoCryptoRepoFileDto);
                                        continue;
                                    }
                                    if (collisionDto.getHistoCryptoRepoFileId2() != null && collisionDto.getHistoCryptoRepoFileId2().equals((Object)plainHistoCryptoRepoFileDto.getHistoCryptoRepoFileDto().getHistoCryptoRepoFileId())) {
                                        dto.setPlainHistoCryptoRepoFileDto2(plainHistoCryptoRepoFileDto);
                                        continue;
                                    }
                                    throw new IllegalStateException("WTF?!");
                                }
                                for (CollisionPrivateDto cpDto : plainHistoCryptoRepoFileDto.getCollisionPrivateDtos()) {
                                    collisionId = cpDto.getCollisionId();
                                    dto = (CollisionDtoWithPlainHistoCryptoRepoFileDto)collisionId2Dto.get(collisionId);
                                    AssertUtil.assertNotNull((Object)dto, (String)("collisionId2Dto[" + collisionId + "]"));
                                    dto.setCollisionPrivateDto(cpDto);
                                }
                            }
                            ArrayList collisionDtoWithPlainHistoCryptoRepoFileDtos = new ArrayList(collisionId2Dto.values());
                            for (CollisionDtoWithPlainHistoCryptoRepoFileDto dto : collisionDtoWithPlainHistoCryptoRepoFileDtos) {
                                AssertUtil.assertNotNull((Object)dto.getCollisionDto(), (String)"dto.collisionDto");
                                AssertUtil.assertNotNull((Object)dto.getCollisionPrivateDto(), (String)"dto.collisionPrivateDto");
                                AssertUtil.assertNotNull((Object)dto.getPlainHistoCryptoRepoFileDto1(), (String)"dto.plainHistoCryptoRepoFileDto1");
                            }
                            ArrayList arrayList = collisionDtoWithPlainHistoCryptoRepoFileDtos;
                            return arrayList;
                        }
                    }

                    protected void succeeded() {
                        Collection collisionDtoWithPlainHistoCryptoRepoFileDtos;
                        try {
                            collisionDtoWithPlainHistoCryptoRepoFileDtos = (Collection)this.get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                        for (CollisionDtoWithPlainHistoCryptoRepoFileDto dto : collisionDtoWithPlainHistoCryptoRepoFileDtos) {
                            CollisionData collisionData = new CollisionData();
                            collisionData.setCollisionDtoWithPlainHistoCryptoRepoFileDto(dto);
                            ResolveCollisionWizard.this.resolveCollisionData.getCollisionDatas().add(collisionData);
                        }
                        if (ResolveCollisionWizard.this.resolveCollisionData.getCollisionDatas().isEmpty()) {
                            ResolveCollisionWizard.this.setFirstPage(null);
                        } else {
                            WizardPage lastPage = null;
                            for (CollisionData collisionData : ResolveCollisionWizard.this.resolveCollisionData.getCollisionDatas()) {
                                CollisionWizardPage currentPage = new CollisionWizardPage(collisionData);
                                if (lastPage == null) {
                                    ResolveCollisionWizard.this.setFirstPage(currentPage);
                                } else {
                                    lastPage.setNextPage(currentPage);
                                }
                                lastPage = currentPage;
                            }
                        }
                    }
                };
            }
        }.start();
    }

    @Override
    protected void finish(ProgressMonitor monitor) throws Exception {
        try (LocalRepoManager localRepoManager = this.createLocalRepoManager();){
            SsLocalRepoMetaData localRepoMetaData = (SsLocalRepoMetaData)localRepoManager.getLocalRepoMetaData();
            List<CollisionData> collisionDatas = this.resolveCollisionData.getCollisionDatas();
            for (CollisionData collisionData : collisionDatas) {
                CollisionPrivateDto collisionPrivateDto = collisionData.getCollisionDtoWithPlainHistoCryptoRepoFileDto().getCollisionPrivateDto();
                localRepoMetaData.putCollisionPrivateDto(collisionPrivateDto);
            }
        }
    }

    @Override
    public String getTitle() {
        return "Resolve collision";
    }

    private LocalRepoManager createLocalRepoManager() {
        LocalRepo localRepo = (LocalRepo)AssertUtil.assertNotNull((Object)this.resolveCollisionData.getLocalRepo(), (String)"resolveCollisionData.localRepo");
        return LocalRepoManagerFactoryLs.getLocalRepoManagerFactory().createLocalRepoManagerForExistingRepository(localRepo.getLocalRoot());
    }
}

