/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.local.persistence.AutoTrackLocalRevision;
import co.codewizards.cloudstore.local.persistence.Entity;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.Embedded;
import javax.jdo.annotations.Inheritance;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.annotations.Join;
import javax.jdo.annotations.NotPersistent;
import javax.jdo.annotations.NullValue;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.Queries;
import javax.jdo.annotations.Query;
import javax.jdo.annotations.Unique;
import javax.jdo.annotations.Uniques;
import javax.jdo.listener.StoreCallback;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.enhancer.Persistable;
import org.datanucleus.state.StateManager;
import org.subshare.core.dto.PermissionType;
import org.subshare.core.io.InputStreamSource;
import org.subshare.core.io.MultiInputStream;
import org.subshare.core.sign.Signature;
import org.subshare.core.sign.WriteProtected;
import org.subshare.local.persistence.CollisionDao;
import org.subshare.local.persistence.CryptoKey;
import org.subshare.local.persistence.CryptoRepoFile;
import org.subshare.local.persistence.CryptoRepoFilePathComparator;
import org.subshare.local.persistence.HistoCryptoRepoFile;
import org.subshare.local.persistence.SignatureImpl;

@PersistenceCapable
@Inheritance(strategy=InheritanceStrategy.NEW_TABLE)
@Uniques(value={@Unique(name="Collision_collisionId", members={"collisionId"}), @Unique(name="Collision_histoCryptoRepoFile1_histoCryptoRepoFile2_duplicateCryptoRepoFileId", members={"histoCryptoRepoFile1", "histoCryptoRepoFile2", "duplicateCryptoRepoFileId"})})
@Queries(value={@Query(name="getCollision_collisionId", value="SELECT UNIQUE WHERE this.collisionId == :collisionId"), @Query(name="getCollisionsChangedAfter_localRevision", value="SELECT WHERE this.localRevision > :localRevision"), @Query(name="getCollision_histoCryptoRepoFile1_histoCryptoRepoFile2", value="SELECT UNIQUE WHERE  (this.histoCryptoRepoFile1 == :histoCryptoRepoFile1 && this.histoCryptoRepoFile2 == :histoCryptoRepoFile2 && this.duplicateCryptoRepoFileId == null)   || (this.histoCryptoRepoFile1 == :histoCryptoRepoFile2 && this.histoCryptoRepoFile2 == :histoCryptoRepoFile1 && this.duplicateCryptoRepoFileId == null)"), @Query(name="getCollision_histoCryptoRepoFile1_duplicateCryptoRepoFileId", value="SELECT UNIQUE WHERE  this.histoCryptoRepoFile1 == :histoCryptoRepoFile1 && this.histoCryptoRepoFile2 == null && this.duplicateCryptoRepoFileId == :duplicateCryptoRepoFileId"), @Query(name="getCollisions_duplicateCryptoRepoFileId", value="SELECT WHERE  this.histoCryptoRepoFile2 == null && this.duplicateCryptoRepoFileId == :duplicateCryptoRepoFileId")})
public class Collision
extends Entity
implements WriteProtected,
AutoTrackLocalRevision,
StoreCallback,
Persistable {
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Column(length=22)
    private String collisionId;
    private long localRevision;
    @Persistent(nullValue=NullValue.EXCEPTION)
    private HistoCryptoRepoFile histoCryptoRepoFile1;
    private HistoCryptoRepoFile histoCryptoRepoFile2;
    @Column(length=22)
    private String duplicateCryptoRepoFileId;
    @Persistent(nullValue=NullValue.EXCEPTION)
    private CryptoKey cryptoKey;
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Column(jdbcType="BLOB")
    private byte[] collisionPrivateDtoData;
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Embedded(nullIndicatorColumn="signatureCreated")
    private SignatureImpl signature;
    @Join
    private Set<CryptoRepoFile> cryptoRepoFilePath;
    @NotPersistent
    private SortedSet<CryptoRepoFile> _cryptoRepoFilePath;
    private static final byte[] dnFieldFlags;
    private static final Class dnPersistableSuperclass;
    private static final Class[] dnFieldTypes;
    private static final String[] dnFieldNames;
    private static final int dnInheritedFieldCount;

    public Collision() {
    }

    public Collision(Uid collisionId) {
        this.collisionId = collisionId == null ? null : collisionId.toString();
    }

    public Uid getCollisionId() {
        if (Collision.dnGetcollisionId(this) == null) {
            Collision.dnSetcollisionId(this, this.calculateCollisionId().toString());
        }
        return new Uid(Collision.dnGetcollisionId(this));
    }

    public HistoCryptoRepoFile getHistoCryptoRepoFile1() {
        return Collision.dnGethistoCryptoRepoFile1(this);
    }

    public void setHistoCryptoRepoFile1(HistoCryptoRepoFile histoCryptoRepoFile1) {
        if (!Util.equal((Object)((Object)Collision.dnGethistoCryptoRepoFile1(this)), (Object)((Object)histoCryptoRepoFile1))) {
            Collision.dnSethistoCryptoRepoFile1(this, histoCryptoRepoFile1);
            this.updateCryptoRepoFilePath();
        }
    }

    private void updateCryptoRepoFilePath() {
        if (Collision.dnGetcryptoRepoFilePath(this) == null) {
            Collision.dnSetcryptoRepoFilePath(this, new HashSet());
        }
        Collision.dnGetcryptoRepoFilePath(this).clear();
        if (Collision.dnGethistoCryptoRepoFile1(this) != null) {
            Collision.dnGetcryptoRepoFilePath(this).addAll(Collision.dnGethistoCryptoRepoFile1(this).getCryptoRepoFile().getPathList());
        }
        this._cryptoRepoFilePath = null;
        this.getCryptoRepoFilePath();
    }

    public HistoCryptoRepoFile getHistoCryptoRepoFile2() {
        return Collision.dnGethistoCryptoRepoFile2(this);
    }

    public void setHistoCryptoRepoFile2(HistoCryptoRepoFile histoCryptoRepoFile2) {
        if (!Util.equal((Object)((Object)Collision.dnGethistoCryptoRepoFile2(this)), (Object)((Object)histoCryptoRepoFile2))) {
            Collision.dnSethistoCryptoRepoFile2(this, histoCryptoRepoFile2);
        }
    }

    public Uid getDuplicateCryptoRepoFileId() {
        return Collision.dnGetduplicateCryptoRepoFileId(this) == null ? null : new Uid(Collision.dnGetduplicateCryptoRepoFileId(this));
    }

    public void setDuplicateCryptoRepoFileId(Uid duplicateCryptoRepoFileId) {
        if (!Util.equal((Object)this.getDuplicateCryptoRepoFileId(), (Object)duplicateCryptoRepoFileId)) {
            Collision.dnSetduplicateCryptoRepoFileId(this, duplicateCryptoRepoFileId == null ? null : duplicateCryptoRepoFileId.toString());
        }
    }

    public SortedSet<CryptoRepoFile> getCryptoRepoFilePath() {
        SortedSet<CryptoRepoFile> result = this._cryptoRepoFilePath;
        if (result == null) {
            result = new TreeSet<CryptoRepoFile>(new CryptoRepoFilePathComparator());
            if (Collision.dnGetcryptoRepoFilePath(this) != null) {
                result.addAll(Collision.dnGetcryptoRepoFilePath(this));
            }
            this._cryptoRepoFilePath = result = Collections.unmodifiableSortedSet(result);
        }
        return result;
    }

    public CryptoKey getCryptoKey() {
        return Collision.dnGetcryptoKey(this);
    }

    public void setCryptoKey(CryptoKey cryptoKey) {
        if (!Util.equal((Object)((Object)Collision.dnGetcryptoKey(this)), (Object)((Object)cryptoKey))) {
            Collision.dnSetcryptoKey(this, cryptoKey);
        }
    }

    public byte[] getCollisionPrivateDtoData() {
        return Collision.dnGetcollisionPrivateDtoData(this);
    }

    public void setCollisionPrivateDtoData(byte[] collisionPrivateDtoData) {
        if (!Util.equal((byte[])Collision.dnGetcollisionPrivateDtoData(this), (byte[])collisionPrivateDtoData)) {
            Collision.dnSetcollisionPrivateDtoData(this, collisionPrivateDtoData);
        }
    }

    public String getSignedDataType() {
        return "Collision";
    }

    public int getSignedDataVersion() {
        return 0;
    }

    public InputStream getSignedData(int signedDataVersion) {
        try {
            byte separatorIndex = 0;
            InputStreamSource[] inputStreamSourceArray = new InputStreamSource[11];
            inputStreamSourceArray[0] = InputStreamSource.Helper.createInputStreamSource((Uid)this.getCollisionId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[1] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[2] = InputStreamSource.Helper.createInputStreamSource(Collision.dnGethistoCryptoRepoFile1(this) == null ? null : Collision.dnGethistoCryptoRepoFile1(this).getHistoCryptoRepoFileId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[3] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[4] = InputStreamSource.Helper.createInputStreamSource(Collision.dnGethistoCryptoRepoFile2(this) == null ? null : Collision.dnGethistoCryptoRepoFile2(this).getHistoCryptoRepoFileId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[5] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[6] = InputStreamSource.Helper.createInputStreamSource((Uid)this.getDuplicateCryptoRepoFileId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[7] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[8] = InputStreamSource.Helper.createInputStreamSource((Uid)((CryptoKey)((Object)AssertUtil.assertNotNull((Object)((Object)Collision.dnGetcryptoKey(this)), (String)"cryptoKey"))).getCryptoKeyId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[9] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[10] = InputStreamSource.Helper.createInputStreamSource((byte[])Collision.dnGetcollisionPrivateDtoData(this));
            return new MultiInputStream(inputStreamSourceArray);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public Signature getSignature() {
        return Collision.dnGetsignature(this);
    }

    public void setSignature(Signature signature) {
        if (!Util.equal((Object)Collision.dnGetsignature(this), (Object)signature)) {
            Collision.dnSetsignature(this, SignatureImpl.copy(signature));
        }
    }

    public void jdoPreStore() {
        CryptoRepoFile parent2;
        Uid collisionId = this.getCollisionId();
        CryptoRepoFile cryptoRepoFile1 = ((HistoCryptoRepoFile)((Object)AssertUtil.assertNotNull((Object)((Object)Collision.dnGethistoCryptoRepoFile1(this)), (String)"histoCryptoRepoFile1"))).getCryptoRepoFile();
        CryptoRepoFile cryptoRepoFile2 = Collision.dnGethistoCryptoRepoFile2(this) == null ? null : Collision.dnGethistoCryptoRepoFile2(this).getCryptoRepoFile();
        CryptoRepoFile parent1 = ((CryptoRepoFile)((Object)AssertUtil.assertNotNull((Object)((Object)cryptoRepoFile1), (String)"cryptoRepoFile1"))).getParent();
        CryptoRepoFile cryptoRepoFile = parent2 = cryptoRepoFile2 == null ? null : cryptoRepoFile2.getParent();
        if (Collision.dnGethistoCryptoRepoFile2(this) == null && Collision.dnGetduplicateCryptoRepoFileId(this) == null) {
            throw new IllegalStateException("Both histoCryptoRepoFile2 and duplicateCryptoRepoFileId are null! One of them must be non-null!");
        }
        if (Collision.dnGethistoCryptoRepoFile2(this) != null && Collision.dnGetduplicateCryptoRepoFileId(this) != null) {
            throw new IllegalStateException("Both histoCryptoRepoFile2 and duplicateCryptoRepoFileId are non-null! One of them must be null!");
        }
        if (Collision.dnGethistoCryptoRepoFile2(this) != null && cryptoRepoFile2 == null) {
            throw new IllegalStateException("histoCryptoRepoFile2 is not null, but cryptoRepoFile2 is null!");
        }
        if (Collision.dnGetduplicateCryptoRepoFileId(this) == null && !Util.equal((Object)((Object)parent1), (Object)((Object)parent2))) {
            throw new IllegalStateException(String.format("histoCryptoRepoFile1.cryptoRepoFile.parent != histoCryptoRepoFile2.cryptoRepoFile.parent :: histoCryptoRepoFile1=%s histoCryptoRepoFile2=%s parent1=%s parent2=%s", new Object[]{Collision.dnGethistoCryptoRepoFile1(this), Collision.dnGethistoCryptoRepoFile2(this), parent1, parent2}));
        }
        if (!collisionId.equals((Object)this.calculateCollisionId())) {
            throw new IllegalStateException("collisionId != calculateCollisionId()");
        }
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)((Object)this));
        CollisionDao collisionDao = (CollisionDao)new CollisionDao().persistenceManager(pm);
        Collision c = collisionDao.getCollision(Collision.dnGethistoCryptoRepoFile1(this), Collision.dnGethistoCryptoRepoFile2(this), this.getDuplicateCryptoRepoFileId());
        if (c != null && c != this) {
            throw new IllegalStateException(String.format("There is already another Collision between these two HistoCryptoRepoFiles/duplicateCryptoRepoFileId: %s, %s, %s", new Object[]{Collision.dnGethistoCryptoRepoFile1(this), Collision.dnGethistoCryptoRepoFile2(this), Collision.dnGetduplicateCryptoRepoFileId(this)}));
        }
    }

    private Uid calculateCollisionId() {
        byte[] bytes = ((HistoCryptoRepoFile)((Object)AssertUtil.assertNotNull((Object)((Object)Collision.dnGethistoCryptoRepoFile1(this)), (String)"histoCryptoRepoFile1"))).getHistoCryptoRepoFileId().toBytes();
        Collision.xorIntoBytes(bytes, Collision.dnGethistoCryptoRepoFile2(this) == null ? null : Collision.dnGethistoCryptoRepoFile2(this).getHistoCryptoRepoFileId());
        Collision.xorIntoBytes(bytes, this.getDuplicateCryptoRepoFileId());
        return new Uid(bytes);
    }

    protected static void xorIntoBytes(byte[] bytes, Uid uid) {
        if (uid != null) {
            byte[] bytes2 = uid.toBytes();
            if (bytes.length != bytes2.length) {
                throw new IllegalArgumentException("bytes.length != bytes2.length");
            }
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = (byte)(bytes[i] & 0xFF ^ bytes2[i] & 0xFF);
            }
        }
    }

    public long getLocalRevision() {
        return Collision.dnGetlocalRevision(this);
    }

    public void setLocalRevision(long localRevision) {
        if (!Util.equal((long)Collision.dnGetlocalRevision(this), (long)localRevision)) {
            Collision.dnSetlocalRevision(this, localRevision);
        }
    }

    public Uid getCryptoRepoFileIdControllingPermissions() {
        CryptoRepoFile cryptoRepoFile1 = ((HistoCryptoRepoFile)((Object)AssertUtil.assertNotNull((Object)((Object)Collision.dnGethistoCryptoRepoFile1(this)), (String)"histoCryptoRepoFile1"))).getCryptoRepoFile();
        CryptoRepoFile cryptoRepoFile2 = Collision.dnGethistoCryptoRepoFile2(this) == null ? cryptoRepoFile1 : Collision.dnGethistoCryptoRepoFile2(this).getCryptoRepoFile();
        AssertUtil.assertNotNull((Object)((Object)cryptoRepoFile1), (String)"cryptoRepoFile1");
        AssertUtil.assertNotNull((Object)((Object)cryptoRepoFile2), (String)"cryptoRepoFile2");
        if (cryptoRepoFile1.equals((Object)cryptoRepoFile2)) {
            return cryptoRepoFile1.getCryptoRepoFileId();
        }
        return null;
    }

    public PermissionType getPermissionTypeRequiredForWrite() {
        return PermissionType.write;
    }

    static {
        dnFieldNames = Collision.__dnFieldNamesInit();
        dnFieldTypes = Collision.__dnFieldTypesInit();
        dnFieldFlags = Collision.__dnFieldFlagsInit();
        dnInheritedFieldCount = Collision.__dnGetInheritedFieldCount();
        dnPersistableSuperclass = Collision.__dnPersistableSuperclassInit();
        EnhancementHelper.registerClass((Class)Collision.___dn$loadClass("org.subshare.local.persistence.Collision"), (String[])dnFieldNames, (Class[])dnFieldTypes, (byte[])dnFieldFlags, (Class)dnPersistableSuperclass, (Persistable)new Collision());
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        Collision result = new Collision();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        Collision result = new Collision();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.collisionId = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 1: {
                this.collisionPrivateDtoData = (byte[])this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 2: {
                this.cryptoKey = (CryptoKey)((Object)this.dnStateManager.replacingObjectField((Persistable)this, index));
                break;
            }
            case 3: {
                this.cryptoRepoFilePath = (Set)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 4: {
                this.duplicateCryptoRepoFileId = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 5: {
                this.histoCryptoRepoFile1 = (HistoCryptoRepoFile)((Object)this.dnStateManager.replacingObjectField((Persistable)this, index));
                break;
            }
            case 6: {
                this.histoCryptoRepoFile2 = (HistoCryptoRepoFile)((Object)this.dnStateManager.replacingObjectField((Persistable)this, index));
                break;
            }
            case 7: {
                this.localRevision = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 8: {
                this.signature = (SignatureImpl)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            default: {
                super.dnReplaceField(index);
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.collisionId);
                break;
            }
            case 1: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.collisionPrivateDtoData);
                break;
            }
            case 2: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.cryptoKey);
                break;
            }
            case 3: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.cryptoRepoFilePath);
                break;
            }
            case 4: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.duplicateCryptoRepoFileId);
                break;
            }
            case 5: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.histoCryptoRepoFile1);
                break;
            }
            case 6: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.histoCryptoRepoFile2);
                break;
            }
            case 7: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.localRevision);
                break;
            }
            case 8: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.signature);
                break;
            }
            default: {
                super.dnProvideField(index);
            }
        }
    }

    protected final void dnCopyField(Collision obj, int index) {
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.collisionId = obj.collisionId;
                break;
            }
            case 1: {
                this.collisionPrivateDtoData = obj.collisionPrivateDtoData;
                break;
            }
            case 2: {
                this.cryptoKey = obj.cryptoKey;
                break;
            }
            case 3: {
                this.cryptoRepoFilePath = obj.cryptoRepoFilePath;
                break;
            }
            case 4: {
                this.duplicateCryptoRepoFileId = obj.duplicateCryptoRepoFileId;
                break;
            }
            case 5: {
                this.histoCryptoRepoFile1 = obj.histoCryptoRepoFile1;
                break;
            }
            case 6: {
                this.histoCryptoRepoFile2 = obj.histoCryptoRepoFile2;
                break;
            }
            case 7: {
                this.localRevision = obj.localRevision;
                break;
            }
            case 8: {
                this.signature = obj.signature;
                break;
            }
            default: {
                super.dnCopyField((Entity)obj, index);
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Collision)) {
            throw new IllegalArgumentException("object is not an object of type org.subshare.local.persistence.Collision");
        }
        Collision other = (Collision)((Object)obj);
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"collisionId", "collisionPrivateDtoData", "cryptoKey", "cryptoRepoFilePath", "duplicateCryptoRepoFileId", "histoCryptoRepoFile1", "histoCryptoRepoFile2", "localRevision", "signature"};
    }

    private static final Class[] __dnFieldTypesInit() {
        return new Class[]{Collision.___dn$loadClass("java.lang.String"), Collision.___dn$loadClass("[B"), Collision.___dn$loadClass("org.subshare.local.persistence.CryptoKey"), Collision.___dn$loadClass("java.util.Set"), Collision.___dn$loadClass("java.lang.String"), Collision.___dn$loadClass("org.subshare.local.persistence.HistoCryptoRepoFile"), Collision.___dn$loadClass("org.subshare.local.persistence.HistoCryptoRepoFile"), Long.TYPE, Collision.___dn$loadClass("org.subshare.local.persistence.SignatureImpl")};
    }

    private static final byte[] __dnFieldFlagsInit() {
        return new byte[]{21, 26, 10, 10, 21, 10, 10, 21, 10};
    }

    protected static int __dnGetInheritedFieldCount() {
        return Entity.dnGetManagedFieldCount();
    }

    protected static int dnGetManagedFieldCount() {
        return 9 + Entity.dnGetManagedFieldCount();
    }

    private static Class __dnPersistableSuperclassInit() {
        return Collision.___dn$loadClass("co.codewizards.cloudstore.local.persistence.Entity");
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object dnSuperClone() throws CloneNotSupportedException {
        Collision o = (Collision)((Object)super.clone());
        o.dnFlags = 0;
        o.dnStateManager = null;
        return o;
    }

    private static String dnGetcollisionId(Collision objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 0 + dnInheritedFieldCount, objPC.collisionId);
        }
        return objPC.collisionId;
    }

    private static void dnSetcollisionId(Collision objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 0 + dnInheritedFieldCount, objPC.collisionId, val);
        } else {
            objPC.collisionId = val;
        }
    }

    private static byte[] dnGetcollisionPrivateDtoData(Collision objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1 + dnInheritedFieldCount)) {
            return (byte[])objPC.dnStateManager.getObjectField((Persistable)objPC, 1 + dnInheritedFieldCount, (Object)objPC.collisionPrivateDtoData);
        }
        return objPC.collisionPrivateDtoData;
    }

    private static void dnSetcollisionPrivateDtoData(Collision objPC, byte[] val) {
        if (objPC.dnStateManager == null) {
            objPC.collisionPrivateDtoData = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 1 + dnInheritedFieldCount, (Object)objPC.collisionPrivateDtoData, (Object)val);
        }
    }

    private static CryptoKey dnGetcryptoKey(Collision objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2 + dnInheritedFieldCount)) {
            return (CryptoKey)((Object)objPC.dnStateManager.getObjectField((Persistable)objPC, 2 + dnInheritedFieldCount, (Object)objPC.cryptoKey));
        }
        return objPC.cryptoKey;
    }

    private static void dnSetcryptoKey(Collision objPC, CryptoKey val) {
        if (objPC.dnStateManager == null) {
            objPC.cryptoKey = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 2 + dnInheritedFieldCount, (Object)objPC.cryptoKey, (Object)val);
        }
    }

    private static Set dnGetcryptoRepoFilePath(Collision objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3 + dnInheritedFieldCount)) {
            return (Set)objPC.dnStateManager.getObjectField((Persistable)objPC, 3 + dnInheritedFieldCount, objPC.cryptoRepoFilePath);
        }
        return objPC.cryptoRepoFilePath;
    }

    private static void dnSetcryptoRepoFilePath(Collision objPC, Set val) {
        if (objPC.dnStateManager == null) {
            objPC.cryptoRepoFilePath = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 3 + dnInheritedFieldCount, objPC.cryptoRepoFilePath, (Object)val);
        }
    }

    private static String dnGetduplicateCryptoRepoFileId(Collision objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 4 + dnInheritedFieldCount, objPC.duplicateCryptoRepoFileId);
        }
        return objPC.duplicateCryptoRepoFileId;
    }

    private static void dnSetduplicateCryptoRepoFileId(Collision objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 4 + dnInheritedFieldCount, objPC.duplicateCryptoRepoFileId, val);
        } else {
            objPC.duplicateCryptoRepoFileId = val;
        }
    }

    private static HistoCryptoRepoFile dnGethistoCryptoRepoFile1(Collision objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 5 + dnInheritedFieldCount)) {
            return (HistoCryptoRepoFile)((Object)objPC.dnStateManager.getObjectField((Persistable)objPC, 5 + dnInheritedFieldCount, (Object)objPC.histoCryptoRepoFile1));
        }
        return objPC.histoCryptoRepoFile1;
    }

    private static void dnSethistoCryptoRepoFile1(Collision objPC, HistoCryptoRepoFile val) {
        if (objPC.dnStateManager == null) {
            objPC.histoCryptoRepoFile1 = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 5 + dnInheritedFieldCount, (Object)objPC.histoCryptoRepoFile1, (Object)val);
        }
    }

    private static HistoCryptoRepoFile dnGethistoCryptoRepoFile2(Collision objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 6 + dnInheritedFieldCount)) {
            return (HistoCryptoRepoFile)((Object)objPC.dnStateManager.getObjectField((Persistable)objPC, 6 + dnInheritedFieldCount, (Object)objPC.histoCryptoRepoFile2));
        }
        return objPC.histoCryptoRepoFile2;
    }

    private static void dnSethistoCryptoRepoFile2(Collision objPC, HistoCryptoRepoFile val) {
        if (objPC.dnStateManager == null) {
            objPC.histoCryptoRepoFile2 = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 6 + dnInheritedFieldCount, (Object)objPC.histoCryptoRepoFile2, (Object)val);
        }
    }

    private static long dnGetlocalRevision(Collision objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 7 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getLongField((Persistable)objPC, 7 + dnInheritedFieldCount, objPC.localRevision);
        }
        return objPC.localRevision;
    }

    private static void dnSetlocalRevision(Collision objPC, long val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setLongField((Persistable)objPC, 7 + dnInheritedFieldCount, objPC.localRevision, val);
        } else {
            objPC.localRevision = val;
        }
    }

    private static SignatureImpl dnGetsignature(Collision objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 8 + dnInheritedFieldCount)) {
            return (SignatureImpl)objPC.dnStateManager.getObjectField((Persistable)objPC, 8 + dnInheritedFieldCount, (Object)objPC.signature);
        }
        return objPC.signature;
    }

    private static void dnSetsignature(Collision objPC, SignatureImpl val) {
        if (objPC.dnStateManager == null) {
            objPC.signature = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 8 + dnInheritedFieldCount, (Object)objPC.signature, (Object)val);
        }
    }
}

