/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.backup;

import co.codewizards.cloudstore.core.config.ConfigDir;
import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.IOutputStream;
import co.codewizards.cloudstore.core.io.LockFile;
import co.codewizards.cloudstore.core.io.LockFileFactory;
import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.HashUtil;
import co.codewizards.cloudstore.core.util.ISO8601;
import co.codewizards.cloudstore.core.util.StringUtil;
import co.codewizards.cloudstore.ls.client.LocalServerClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.TreeSet;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpKeyId;
import org.subshare.core.server.Server;
import org.subshare.core.server.ServerRegistry;
import org.subshare.gui.ls.PgpLs;
import org.subshare.gui.ls.ServerRegistryLs;

public class AbstractBackupImExporter {
    protected final LocalServerClient localServerClient;
    protected final Pgp pgp;
    protected final ServerRegistry serverRegistry;
    protected final File backupPropertiesFile;
    protected final Properties backupProperties = new Properties();

    public AbstractBackupImExporter() {
        this.localServerClient = LocalServerClient.getInstance();
        this.pgp = PgpLs.getPgpOrFail();
        this.serverRegistry = ServerRegistryLs.getServerRegistry();
        this.backupPropertiesFile = OioFileFactory.createFile((File)ConfigDir.getInstance().getFile(), (String[])new String[]{"backup.properties"});
        this.readBackupProperties();
    }

    private void readBackupProperties() {
        try (LockFile lockFile = LockFileFactory.getInstance().acquire(this.backupPropertiesFile, 30000L);
             InputStream in = StreamUtil.castStream((IInputStream)lockFile.createInputStream());){
            this.backupProperties.load(in);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    protected void writeBackupProperties() {
        try (LockFile lockFile = LockFileFactory.getInstance().acquire(this.backupPropertiesFile, 30000L);
             OutputStream out = StreamUtil.castStream((IOutputStream)lockFile.createOutputStream());){
            this.backupProperties.store(out, null);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    protected void registerPgpKeyRelatedBackupProperties(Date backupTimestamp) {
        AssertUtil.assertNotNull((Object)backupTimestamp, (String)"backupTimestamp");
        for (PgpKey masterKey : new HashSet(this.pgp.getMasterKeysWithSecretKey())) {
            TreeSet userIds = new TreeSet();
            for (PgpKey pgpKey : masterKey.getMasterKeyAndSubKeys()) {
                PgpKeyId pgpKeyId = pgpKey.getPgpKeyId();
                this.setPgpKeyLastBackupTimestamp(pgpKeyId, backupTimestamp);
                userIds.addAll(pgpKey.getUserIds());
            }
            String userIdsString = ((Object)userIds).toString();
            String userIdsSha1 = HashUtil.sha1((String)userIdsString);
            this.setPgpKeyLastBackupUserIdsSha1(masterKey.getPgpKeyId(), userIdsSha1);
        }
    }

    protected void registerServerRegistryRelatedBackupProperties(Date backupTimestamp) {
        AssertUtil.assertNotNull((Object)backupTimestamp, (String)"backupTimestamp");
        TreeSet<String> serverIdAndUrlPairs = new TreeSet<String>();
        for (Server server : this.serverRegistry.getServers()) {
            serverIdAndUrlPairs.add(AbstractBackupImExporter.getServerIdAndUrlPair(server));
        }
        String serverIdAndUrlPairsString = ((Object)serverIdAndUrlPairs).toString();
        String serverIdAndUrlPairsSha1 = HashUtil.sha1((String)serverIdAndUrlPairsString);
        this.setServerRegistryLastBackupSha1(serverIdAndUrlPairsSha1);
        this.setServerRegistryLastBackupTimestamp((Date)AssertUtil.assertNotNull((Object)backupTimestamp, (String)"now"));
    }

    protected static String getServerIdAndUrlPair(Server server) {
        return server.getServerId().toString() + server.getUrl();
    }

    protected String getPgpKeyLastBackupTimestampPropertyKey(PgpKeyId pgpKeyId) {
        AssertUtil.assertNotNull((Object)pgpKeyId, (String)"pgpKeyId");
        return String.format("pgpKey[%s].lastBackup.timestamp", pgpKeyId);
    }

    protected String getPgpKeyLastBackupUserIdsSha1PropertyKey(PgpKeyId pgpKeyId) {
        AssertUtil.assertNotNull((Object)pgpKeyId, (String)"pgpKeyId");
        return String.format("pgpKey[%s].lastBackup.userIdsSha1", pgpKeyId);
    }

    protected Date getPgpKeyLastBackupTimestamp(PgpKeyId pgpKeyId) {
        String propertyKey = this.getPgpKeyLastBackupTimestampPropertyKey(pgpKeyId);
        String value = this.backupProperties.getProperty(propertyKey);
        if (StringUtil.isEmpty((String)value)) {
            return null;
        }
        return ISO8601.parseDate((String)value);
    }

    protected void setPgpKeyLastBackupTimestamp(PgpKeyId pgpKeyId, Date date) {
        AssertUtil.assertNotNull((Object)date, (String)"date");
        String propertyKey = this.getPgpKeyLastBackupTimestampPropertyKey(pgpKeyId);
        String value = date == null ? null : ISO8601.formatDate((Date)date);
        this.backupProperties.setProperty(propertyKey, value);
    }

    protected String getPgpKeyLastBackupUserIdsSha1(PgpKeyId pgpKeyId) {
        String propertyKey = this.getPgpKeyLastBackupUserIdsSha1PropertyKey(pgpKeyId);
        String value = this.backupProperties.getProperty(propertyKey);
        return StringUtil.emptyToNull((String)value);
    }

    protected void setPgpKeyLastBackupUserIdsSha1(PgpKeyId pgpKeyId, String userIdsSha1) {
        AssertUtil.assertNotNull((Object)userIdsSha1, (String)"userIdsSha1");
        String propertyKey = this.getPgpKeyLastBackupUserIdsSha1PropertyKey(pgpKeyId);
        this.backupProperties.setProperty(propertyKey, userIdsSha1);
    }

    protected Date getServerRegistryLastBackupTimestamp() {
        String value = this.backupProperties.getProperty("serverRegistry.lastBackup.timestamp");
        if (StringUtil.isEmpty((String)value)) {
            return null;
        }
        return ISO8601.parseDate((String)value);
    }

    protected void setServerRegistryLastBackupTimestamp(Date date) {
        AssertUtil.assertNotNull((Object)date, (String)"date");
        String value = date == null ? null : ISO8601.formatDate((Date)date);
        this.backupProperties.setProperty("serverRegistry.lastBackup.timestamp", value);
    }

    protected String getServerRegistryLastBackupSha1() {
        String value = this.backupProperties.getProperty("serverRegistry.lastBackup.serverIdsAndUrlsSha1");
        return StringUtil.emptyToNull((String)value);
    }

    protected void setServerRegistryLastBackupSha1(String sha1) {
        AssertUtil.assertNotNull((Object)sha1, (String)"sha1");
        this.backupProperties.setProperty("serverRegistry.lastBackup.serverIdsAndUrlsSha1", sha1);
    }
}

