/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.localrepo.directory;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.sync.RepoSyncDaemon;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javafx.collections.ObservableSet;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import org.subshare.core.dto.CollisionPrivateDto;
import org.subshare.core.repo.LocalRepo;
import org.subshare.gui.filetree.DirectoryFileTreeItem;
import org.subshare.gui.filetree.FileFileTreeItem;
import org.subshare.gui.filetree.FileTreeItem;
import org.subshare.gui.filetree.FileTreePane;
import org.subshare.gui.filetree.repoaware.CollisionPrivateDtoSet;
import org.subshare.gui.filetree.repoaware.RepoAwareFileTreePane;
import org.subshare.gui.histo.HistoryPaneContainer;
import org.subshare.gui.histo.HistoryPaneSupport;
import org.subshare.gui.invitation.issue.IssueInvitationData;
import org.subshare.gui.invitation.issue.IssueInvitationWizard;
import org.subshare.gui.localrepo.directory.SecurityPane;
import org.subshare.gui.ls.RepoSyncDaemonLs;
import org.subshare.gui.resolvecollision.ResolveCollisionData;
import org.subshare.gui.resolvecollision.ResolveCollisionWizard;
import org.subshare.gui.util.FxmlUtil;
import org.subshare.gui.util.PlatformUtil;
import org.subshare.gui.wizard.WizardDialog;

public class LocalRepoDirectoryPane
extends VBox
implements HistoryPaneContainer {
    private final LocalRepo localRepo;
    private final File file;
    @FXML
    private TabPane tabPane;
    @FXML
    private Tab generalTab;
    @FXML
    private Tab historyTab;
    @FXML
    private Tab securityTab;
    @FXML
    private TextField pathTextField;
    @FXML
    private RepoAwareFileTreePane fileTreePane;
    @FXML
    private Button resolveCollisionInFileTreeButton;
    @FXML
    private Button resolveCollisionInHistoryButton;
    @FXML
    private Button refreshButton;
    @FXML
    private Button exportFromHistoryButton;
    private WeakReference<SecurityPane> securityPaneRef;
    private final HistoryPaneSupport historyPaneSupport;

    public LocalRepoDirectoryPane(LocalRepo localRepo, File file) {
        this.localRepo = (LocalRepo)AssertUtil.assertNotNull((Object)localRepo, (String)"localRepo");
        this.file = (File)AssertUtil.assertNotNull((Object)file, (String)"file");
        FxmlUtil.loadDynamicComponentFxml(LocalRepoDirectoryPane.class, this);
        String path = file.getAbsolutePath();
        this.pathTextField.setText(path);
        this.fileTreePane.setUseCase(String.format("localRepo:%s:%s", localRepo.getRepositoryId(), path));
        this.fileTreePane.setRootFileTreeItem(new RootDirectoryFileTreeItem(this.fileTreePane, file));
        this.fileTreePane.setLocalRepo(localRepo);
        this.fileTreePane.getSelectedFiles().addListener(observable -> this.updateResolveCollisionInFileTreeButtonDisable());
        this.updateResolveCollisionInFileTreeButtonDisable();
        this.historyPaneSupport = new HistoryPaneSupport(this);
        this.tabPane.getSelectionModel().selectedItemProperty().addListener(observable -> this.createOrForgetSecurityPane());
        this.createOrForgetSecurityPane();
        this.tabPane.getSelectionModel().selectedItemProperty().addListener(observable -> this.updateButtonVisible());
        this.updateButtonVisible();
    }

    private void createOrForgetSecurityPane() {
        SecurityPane securityPane;
        PlatformUtil.assertFxApplicationThread();
        if (this.securityTab != this.tabPane.getSelectionModel().getSelectedItem()) {
            this.securityTab.setContent(null);
            return;
        }
        SecurityPane securityPane2 = securityPane = this.securityPaneRef == null ? null : (SecurityPane)((Object)this.securityPaneRef.get());
        if (securityPane == null) {
            securityPane = new SecurityPane(this.localRepo, this.file){

                @Override
                protected void startSync() {
                    LocalRepoDirectoryPane.this.startSync();
                }
            };
            this.securityPaneRef = new WeakReference<SecurityPane>(securityPane);
        }
        if (this.securityTab.getContent() == null) {
            this.securityTab.setContent((Node)securityPane);
        }
    }

    private void updateButtonVisible() {
        this.refreshButton.setVisible(this.tabPane.getSelectionModel().getSelectedItem() == this.generalTab);
        this.refreshButton.setManaged(this.refreshButton.isVisible());
        this.resolveCollisionInFileTreeButton.setVisible(this.tabPane.getSelectionModel().getSelectedItem() == this.generalTab);
        this.resolveCollisionInFileTreeButton.setManaged(this.resolveCollisionInFileTreeButton.isVisible());
    }

    private void updateResolveCollisionInFileTreeButtonDisable() {
        Collection<CollisionPrivateDto> collisionPrivateDtos = this.getSelectedFileTreeCollisionPrivateDtos();
        this.resolveCollisionInFileTreeButton.setDisable(collisionPrivateDtos.isEmpty());
    }

    private Collection<CollisionPrivateDto> getSelectedFileTreeCollisionPrivateDtos() {
        ObservableSet<File> selectedFiles = this.fileTreePane.getSelectedFiles();
        ArrayList<CollisionPrivateDto> collisionPrivateDtos = new ArrayList<CollisionPrivateDto>();
        HashSet<Uid> collisionIds = new HashSet<Uid>();
        for (File file : selectedFiles) {
            CollisionPrivateDtoSet collisionPrivateDtoSet;
            FileTreeItem<?> treeItem = this.fileTreePane.getRootFileTreeItem().findFirst(file);
            if (treeItem == null || (collisionPrivateDtoSet = this.fileTreePane.getCollisionDtoSet(treeItem)) == null) continue;
            for (CollisionPrivateDto collisionPrivateDto : collisionPrivateDtoSet.getAllCollisionPrivateDtos()) {
                if (!collisionIds.add(collisionPrivateDto.getCollisionId())) continue;
                collisionPrivateDtos.add(collisionPrivateDto);
            }
        }
        return collisionPrivateDtos;
    }

    @FXML
    private void syncButtonClicked(ActionEvent event) {
        this.startSync();
    }

    private void startSync() {
        RepoSyncDaemon repoSyncDaemon = RepoSyncDaemonLs.getRepoSyncDaemon();
        repoSyncDaemon.startSync(this.localRepo.getLocalRoot());
    }

    @FXML
    private void inviteButtonClicked(ActionEvent event) {
        IssueInvitationWizard wizard = new IssueInvitationWizard(new IssueInvitationData(this.localRepo, this.file));
        WizardDialog dialog = new WizardDialog(this.getScene().getWindow(), wizard);
        dialog.show();
    }

    @FXML
    private void refreshButtonClicked(ActionEvent event) {
        this.fileTreePane.refresh();
    }

    @FXML
    private void resolveCollisionInFileTreeButtonClicked(ActionEvent event) {
        Collection<CollisionPrivateDto> collisionPrivateDtos = this.getSelectedFileTreeCollisionPrivateDtos();
        HashSet<Uid> collisionIds = new HashSet<Uid>(collisionPrivateDtos.size());
        for (CollisionPrivateDto collisionPrivateDto : collisionPrivateDtos) {
            collisionIds.add(collisionPrivateDto.getCollisionId());
        }
        ResolveCollisionData resolveCollisionData = new ResolveCollisionData(this.localRepo, collisionIds);
        ResolveCollisionWizard wizard = new ResolveCollisionWizard(resolveCollisionData);
        WizardDialog dialog = new WizardDialog(this.tabPane.getScene().getWindow(), wizard);
        dialog.show();
    }

    @Override
    public LocalRepo getLocalRepo() {
        return this.localRepo;
    }

    @Override
    public String getLocalPath() {
        return this.localRepo.getLocalPath(this.file);
    }

    @Override
    public TabPane getTabPane() {
        return this.tabPane;
    }

    @Override
    public Tab getHistoryTab() {
        return this.historyTab;
    }

    @Override
    public Button getResolveCollisionInHistoryButton() {
        return this.resolveCollisionInHistoryButton;
    }

    @Override
    public Button getExportFromHistoryButton() {
        return this.exportFromHistoryButton;
    }

    private static class RootDirectoryFileTreeItem
    extends DirectoryFileTreeItem {
        private final FileTreePane fileTreePane;

        public RootDirectoryFileTreeItem(FileTreePane fileTreePane, File file) {
            super(file);
            this.fileTreePane = (FileTreePane)((Object)AssertUtil.assertNotNull((Object)((Object)fileTreePane), (String)"fileTreePane"));
            this.hookUpdateInvalidationListener(fileTreePane);
        }

        @Override
        protected FileTreePane getFileTreePane() {
            return this.fileTreePane;
        }

        @Override
        protected List<FileTreeItem<?>> loadChildren() {
            List<FileTreeItem<?>> children = super.loadChildren();
            children.removeIf(fti -> fti instanceof FileFileTreeItem && ((FileFileTreeItem)((Object)fti)).getFile().getName().equals(LocalRepoManager.META_DIR_NAME));
            return children;
        }
    }
}

