/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.pgp.keytree;

import java.util.HashSet;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import org.subshare.core.pgp.Pgp;
import org.subshare.gui.ls.PgpLs;
import org.subshare.gui.pgp.keytree.PgpKeyTreeItem;
import org.subshare.gui.util.FxmlUtil;

public class PgpKeyTreePane
extends BorderPane {
    private final ObjectProperty<Pgp> pgp = new SimpleObjectProperty<Pgp>((Object)this, "pgp"){

        public Pgp get() {
            Pgp result = (Pgp)super.get();
            if (result == null) {
                result = PgpLs.getPgpOrFail();
                this.set(result);
            }
            return result;
        }
    };
    @FXML
    private TreeTableView<PgpKeyTreeItem<?>> treeTableView;
    @FXML
    private TreeTableColumn<PgpKeyTreeItem<?>, String> nameTreeTableColumn;
    private final ObservableSet<Class<? extends PgpKeyTreeItem<?>>> checkBoxVisibleForPgpKeyTreeItemClasses = FXCollections.observableSet(new HashSet());
    private final ObservableSet<PgpKeyTreeItem<?>> checkedTreeItems = FXCollections.observableSet(new HashSet());

    public PgpKeyTreePane() {
        FxmlUtil.loadDynamicComponentFxml(PgpKeyTreePane.class, this);
        this.treeTableView.setShowRoot(false);
        this.treeTableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.nameTreeTableColumn.setCellFactory(new Callback<TreeTableColumn<PgpKeyTreeItem<?>, String>, TreeTableCell<PgpKeyTreeItem<?>, String>>(){

            public TreeTableCell<PgpKeyTreeItem<?>, String> call(TreeTableColumn<PgpKeyTreeItem<?>, String> param) {
                return new NameCell();
            }
        });
        this.checkedTreeItems.addListener(new SetChangeListener<PgpKeyTreeItem<?>>(){

            public void onChanged(SetChangeListener.Change<? extends PgpKeyTreeItem<?>> change) {
                PgpKeyTreeItem elementRemoved;
                PgpKeyTreeItem elementAdded = (PgpKeyTreeItem)((Object)change.getElementAdded());
                if (elementAdded != null) {
                    elementAdded.setChecked(true);
                }
                if ((elementRemoved = (PgpKeyTreeItem)((Object)change.getElementRemoved())) != null) {
                    elementRemoved.setChecked(false);
                }
            }
        });
    }

    public ObservableSet<Class<? extends PgpKeyTreeItem<?>>> getCheckBoxVisibleForPgpKeyTreeItemClasses() {
        return this.checkBoxVisibleForPgpKeyTreeItemClasses;
    }

    public TreeTableView<PgpKeyTreeItem<?>> getTreeTableView() {
        return this.treeTableView;
    }

    public ObservableSet<PgpKeyTreeItem<?>> getCheckedTreeItems() {
        return this.checkedTreeItems;
    }

    public void requestFocus() {
        super.requestFocus();
        this.treeTableView.requestFocus();
    }

    public Pgp getPgp() {
        return (Pgp)this.pgp.get();
    }

    public void setPgp(Pgp pgp) {
        this.pgp.set((Object)pgp);
    }

    public ObjectProperty<Pgp> pgpProperty() {
        return this.pgp;
    }

    private class NameCell
    extends TreeTableCell<PgpKeyTreeItem<?>, String> {
        private NameCell() {
        }

        protected void updateItem(String cellValue, boolean empty) {
            super.updateItem((Object)cellValue, empty);
            PgpKeyTreeItem treeItem = (PgpKeyTreeItem)((Object)this.getTreeTableRow().getItem());
            this.setGraphic(null);
            this.setText(cellValue);
            if (treeItem != null && PgpKeyTreePane.this.checkBoxVisibleForPgpKeyTreeItemClasses.contains(((Object)((Object)treeItem)).getClass())) {
                CheckBox checkBox = new CheckBox();
                checkBox.selectedProperty().bindBidirectional((Property)treeItem.checkedProperty());
                this.setGraphic((Node)checkBox);
            }
        }
    }
}

