/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.crypto;

import co.codewizards.cloudstore.core.io.ByteArrayOutputStream;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.IOUtil;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.KeyParameter;
import org.subshare.core.crypto.DecrypterInputStream;
import org.subshare.core.io.LimitedInputStream;

public class AsymCombiDecrypterInputStream
extends FilterInputStream {
    public static final int MAGIC_BYTE = 195;
    private final AsymmetricKeyParameter privateKey;
    private final Header header;
    private final InputStream symIn;

    public AsymCombiDecrypterInputStream(InputStream in, AsymmetricKeyParameter privateKey) throws IOException {
        super((InputStream)AssertUtil.assertNotNull((Object)in, (String)"in"));
        this.privateKey = (AsymmetricKeyParameter)AssertUtil.assertNotNull((Object)privateKey, (String)"privateKey");
        this.header = this.readHeader();
        this.symIn = new DecrypterInputStream(in, (CipherParameters)this.header.symmetricKey);
    }

    private Header readHeader() throws IOException {
        KeyParameter symmetricKey;
        int magicByte = this.in.read();
        if (195 != magicByte) {
            throw new IOException(String.format("First byte from input does not match expected magic number! expected=%s found=%s", 195, magicByte));
        }
        int version = this.in.read();
        if (version != 1) {
            throw new IOException("version != 1 :: version == " + version);
        }
        int encryptedSymmetricKeyLength = this.readOrFail() + (this.readOrFail() << 8);
        try (DecrypterInputStream asymIn = new DecrypterInputStream(new LimitedInputStream(this.in, encryptedSymmetricKeyLength, encryptedSymmetricKeyLength), (CipherParameters)this.privateKey);){
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            IOUtil.transferStreamData((InputStream)asymIn, (OutputStream)bout);
            symmetricKey = new KeyParameter(bout.toByteArray());
        }
        return new Header(version, symmetricKey);
    }

    @Override
    public int read() throws IOException {
        return this.symIn.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.symIn.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.symIn.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.symIn.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.symIn.available();
    }

    @Override
    public void close() throws IOException {
        this.symIn.close();
    }

    @Override
    public void mark(int readlimit) {
        this.symIn.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.symIn.reset();
    }

    @Override
    public boolean markSupported() {
        return this.symIn.markSupported();
    }

    private int readOrFail() throws IOException {
        return IOUtil.readOrFail((InputStream)this.in);
    }

    protected static class Header {
        public final int version;
        public final KeyParameter symmetricKey;

        public Header(int version, KeyParameter symmetricKey) {
            this.version = version;
            this.symmetricKey = (KeyParameter)AssertUtil.assertNotNull((Object)symmetricKey, (String)"symmetricKey");
        }
    }
}

