/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.wot;

import org.bouncycastle.openpgp.wot.internal.Util;

public enum TrustModel {
    CLASSIC(0, "classic"),
    PGP(1, "PGP"),
    EXTERNAL(2, "external"),
    ALWAYS(3, "always"),
    DIRECT(4, "direct");

    private final int numericId;
    private final String stringId;
    private static volatile TrustModel[] numericId2TrustModel;

    private TrustModel(int numericId, String stringId) {
        this.numericId = numericId;
        this.stringId = Util.assertNotNull(stringId, "stringId");
    }

    public int getNumericId() {
        return this.numericId;
    }

    public String getStringId() {
        return this.stringId;
    }

    public String toString() {
        return this.stringId;
    }

    public static TrustModel fromNumericId(int numericId) throws IllegalArgumentException {
        if (numericId < 0 || numericId >= TrustModel.getNumericId2TrustModel().length) {
            throw new IllegalArgumentException("numericId unknown: " + numericId);
        }
        TrustModel trustModel = TrustModel.getNumericId2TrustModel()[numericId];
        if (trustModel == null) {
            throw new IllegalArgumentException("numericId unknown: " + numericId);
        }
        return trustModel;
    }

    private static TrustModel[] getNumericId2TrustModel() {
        if (numericId2TrustModel == null) {
            int maxNumericId = 0;
            for (TrustModel trustModel : TrustModel.values()) {
                maxNumericId = Math.max(maxNumericId, trustModel.getNumericId());
            }
            TrustModel[] array = new TrustModel[maxNumericId + 1];
            TrustModel[] trustModelArray = TrustModel.values();
            int n = trustModelArray.length;
            for (int i = 0; i < n; ++i) {
                TrustModel trustModel;
                array[trustModel.getNumericId()] = trustModel = trustModelArray[i];
            }
            numericId2TrustModel = array;
        }
        return numericId2TrustModel;
    }
}

