/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.local.persistence.AutoTrackLocalRevision;
import co.codewizards.cloudstore.local.persistence.Entity;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.UUID;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.Embedded;
import javax.jdo.annotations.Index;
import javax.jdo.annotations.Indices;
import javax.jdo.annotations.Inheritance;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.annotations.NullValue;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.Queries;
import javax.jdo.annotations.Query;
import javax.jdo.annotations.Unique;
import javax.jdo.annotations.Uniques;
import javax.jdo.listener.StoreCallback;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.enhancer.Persistable;
import org.datanucleus.state.StateManager;
import org.subshare.core.dto.CryptoKeyRole;
import org.subshare.core.dto.PermissionType;
import org.subshare.core.io.InputStreamSource;
import org.subshare.core.io.MultiInputStream;
import org.subshare.core.sign.Signature;
import org.subshare.core.sign.WriteProtected;
import org.subshare.local.persistence.CryptoKey;
import org.subshare.local.persistence.CryptoRepoFile;
import org.subshare.local.persistence.HistoFrame;
import org.subshare.local.persistence.SignatureImpl;

@PersistenceCapable
@Inheritance(strategy=InheritanceStrategy.NEW_TABLE)
@Uniques(value={@Unique(name="UK_HistoCryptoRepoFile_histoCryptoRepoFileId", members={"histoCryptoRepoFileId"}), @Unique(name="UK_HistoCryptoRepoFile_cryptoRepoFile_histoFrame", members={"cryptoRepoFile", "histoFrame"})})
@Indices(value={@Index(name="HistoCryptoRepoFile_histoCryptoRepoFileId", members={"histoCryptoRepoFileId"}), @Index(name="HistoCryptoRepoFile_localRevision", members={"localRevision"}), @Index(name="HistoCryptoRepoFile_cryptoRepoFile_histoFrame", members={"cryptoRepoFile", "histoFrame"}), @Index(name="HistoCryptoRepoFile_histoFrame", members={"histoFrame"})})
@Queries(value={@Query(name="getHistoCryptoRepoFile_histoCryptoRepoFileId", value="SELECT UNIQUE WHERE this.histoCryptoRepoFileId == :histoCryptoRepoFileId"), @Query(name="getHistoCryptoRepoFiles_cryptoRepoFile", value="SELECT WHERE this.cryptoRepoFile == :cryptoRepoFile"), @Query(name="getHistoCryptoRepoFiles_histoFrame", value="SELECT WHERE this.histoFrame == :histoFrame"), @Query(name="getHistoCryptoRepoFilesByCollisions", value="SELECT WHERE  collisionIds.contains(collision.collisionId)  && (this == collision.histoCryptoRepoFile1 || this == collision.histoCryptoRepoFile2) VARIABLES org.subshare.local.persistence.Collision collision PARAMETERS java.util.Set collisionIds"), @Query(name="getHistoCryptoRepoFilesChangedAfter_localRevision_exclLastSyncFromRepositoryId", value="SELECT WHERE this.localRevision > :localRevision && (this.lastSyncFromRepositoryId == null || this.lastSyncFromRepositoryId != :lastSyncFromRepositoryId)"), @Query(name="getHistoCryptoRepoFilesWithoutPlainHistoCryptoRepoFile", value="SELECT WHERE 0 == (SELECT count(p) FROM org.subshare.local.persistence.PlainHistoCryptoRepoFile p WHERE p.histoCryptoRepoFile == this)")})
public class HistoCryptoRepoFile
extends Entity
implements WriteProtected,
AutoTrackLocalRevision,
StoreCallback,
Persistable {
    @Persistent(nullValue=NullValue.EXCEPTION)
    private String histoCryptoRepoFileId;
    private HistoCryptoRepoFile previousHistoCryptoRepoFile;
    @Persistent(nullValue=NullValue.EXCEPTION)
    private CryptoRepoFile cryptoRepoFile;
    @Persistent(nullValue=NullValue.EXCEPTION)
    private HistoFrame histoFrame;
    private long localRevision;
    private String lastSyncFromRepositoryId;
    @Persistent(nullValue=NullValue.EXCEPTION)
    private CryptoKey cryptoKey;
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Column(jdbcType="BLOB")
    private byte[] repoFileDtoData;
    private Date deleted;
    @Column(defaultValue="N")
    private boolean deletedByIgnoreRule;
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Embedded(nullIndicatorColumn="signatureCreated")
    private SignatureImpl signature;
    private static final byte[] dnFieldFlags;
    private static final Class dnPersistableSuperclass;
    private static final Class[] dnFieldTypes;
    private static final String[] dnFieldNames;
    private static final int dnInheritedFieldCount;

    public HistoCryptoRepoFile() {
    }

    public HistoCryptoRepoFile(Uid histoCryptoRepoFileId) {
        this.histoCryptoRepoFileId = histoCryptoRepoFileId == null ? null : histoCryptoRepoFileId.toString();
    }

    public Uid getHistoCryptoRepoFileId() {
        if (HistoCryptoRepoFile.dnGethistoCryptoRepoFileId(this) == null) {
            HistoCryptoRepoFile.dnSethistoCryptoRepoFileId(this, new Uid().toString());
        }
        return new Uid(HistoCryptoRepoFile.dnGethistoCryptoRepoFileId(this));
    }

    public CryptoRepoFile getCryptoRepoFile() {
        return HistoCryptoRepoFile.dnGetcryptoRepoFile(this);
    }

    public void setCryptoRepoFile(CryptoRepoFile cryptoRepoFile) {
        if (Util.equal((Object)((Object)HistoCryptoRepoFile.dnGetcryptoRepoFile(this)), (Object)((Object)cryptoRepoFile))) {
            return;
        }
        if (HistoCryptoRepoFile.dnGetcryptoRepoFile(this) != null) {
            throw new IllegalStateException("this.cryptoRepoFile already assigned! Cannot re-assign!");
        }
        HistoCryptoRepoFile.dnSetcryptoRepoFile(this, cryptoRepoFile);
    }

    public HistoFrame getHistoFrame() {
        return HistoCryptoRepoFile.dnGethistoFrame(this);
    }

    public void setHistoFrame(HistoFrame histoFrame) {
        if (Util.equal((Object)((Object)HistoCryptoRepoFile.dnGethistoFrame(this)), (Object)((Object)histoFrame))) {
            return;
        }
        if (HistoCryptoRepoFile.dnGethistoFrame(this) != null) {
            throw new IllegalStateException("this.histoFrame already assigned! Cannot re-assign!");
        }
        HistoCryptoRepoFile.dnSethistoFrame(this, histoFrame);
    }

    public HistoCryptoRepoFile getPreviousHistoCryptoRepoFile() {
        return HistoCryptoRepoFile.dnGetpreviousHistoCryptoRepoFile(this);
    }

    public void setPreviousHistoCryptoRepoFile(HistoCryptoRepoFile previousHistoCryptoRepoFile) {
        if (!Util.equal((Object)((Object)HistoCryptoRepoFile.dnGetpreviousHistoCryptoRepoFile(this)), (Object)((Object)previousHistoCryptoRepoFile))) {
            HistoCryptoRepoFile.dnSetpreviousHistoCryptoRepoFile(this, previousHistoCryptoRepoFile);
        }
    }

    public CryptoKey getCryptoKey() {
        return HistoCryptoRepoFile.dnGetcryptoKey(this);
    }

    public void setCryptoKey(CryptoKey cryptoKey) {
        if (!Util.equal((Object)((Object)HistoCryptoRepoFile.dnGetcryptoKey(this)), (Object)((Object)cryptoKey))) {
            CryptoKeyRole cryptoKeyRole;
            if (cryptoKey != null && CryptoKeyRole.dataKey != (cryptoKeyRole = (CryptoKeyRole)AssertUtil.assertNotNull((Object)cryptoKey.getCryptoKeyRole(), (String)"cryptoKey.cryptoKeyRole"))) {
                throw new IllegalArgumentException("cryptoKey.cryptoKeyRole != dataKey");
            }
            HistoCryptoRepoFile.dnSetcryptoKey(this, cryptoKey);
        }
    }

    public byte[] getRepoFileDtoData() {
        return HistoCryptoRepoFile.dnGetrepoFileDtoData(this);
    }

    public void setRepoFileDtoData(byte[] repoFileDtoData) {
        if (!Util.equal((byte[])HistoCryptoRepoFile.dnGetrepoFileDtoData(this), (byte[])repoFileDtoData)) {
            HistoCryptoRepoFile.dnSetrepoFileDtoData(this, repoFileDtoData);
        }
    }

    public Date getDeleted() {
        return HistoCryptoRepoFile.dnGetdeleted(this);
    }

    public void setDeleted(Date deleted) {
        if (!Util.equal((Object)HistoCryptoRepoFile.dnGetdeleted(this), (Object)deleted)) {
            HistoCryptoRepoFile.dnSetdeleted(this, deleted);
        }
    }

    public boolean isDeletedByIgnoreRule() {
        return HistoCryptoRepoFile.dnGetdeletedByIgnoreRule(this);
    }

    public void setDeletedByIgnoreRule(boolean deletedByIgnoreRule) {
        if (!Util.equal((boolean)HistoCryptoRepoFile.dnGetdeletedByIgnoreRule(this), (boolean)deletedByIgnoreRule)) {
            HistoCryptoRepoFile.dnSetdeletedByIgnoreRule(this, deletedByIgnoreRule);
        }
    }

    public long getLocalRevision() {
        return HistoCryptoRepoFile.dnGetlocalRevision(this);
    }

    public void setLocalRevision(long localRevision) {
        if (!Util.equal((long)HistoCryptoRepoFile.dnGetlocalRevision(this), (long)localRevision)) {
            HistoCryptoRepoFile.dnSetlocalRevision(this, localRevision);
        }
    }

    public void jdoPreStore() {
        this.getHistoCryptoRepoFileId();
    }

    public String getSignedDataType() {
        return "HistoCryptoRepoFile";
    }

    public UUID getLastSyncFromRepositoryId() {
        return HistoCryptoRepoFile.dnGetlastSyncFromRepositoryId(this) == null ? null : UUID.fromString(HistoCryptoRepoFile.dnGetlastSyncFromRepositoryId(this));
    }

    public void setLastSyncFromRepositoryId(UUID repositoryId) {
        if (!Util.equal((Object)this.getLastSyncFromRepositoryId(), (Object)repositoryId)) {
            HistoCryptoRepoFile.dnSetlastSyncFromRepositoryId(this, repositoryId == null ? null : repositoryId.toString());
        }
    }

    public int getSignedDataVersion() {
        return 1;
    }

    public InputStream getSignedData(int signedDataVersion) {
        try {
            byte separatorIndex = 0;
            InputStreamSource[] inputStreamSourceArray = new InputStreamSource[13];
            inputStreamSourceArray[0] = InputStreamSource.Helper.createInputStreamSource((Uid)this.getHistoCryptoRepoFileId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[1] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[2] = InputStreamSource.Helper.createInputStreamSource(HistoCryptoRepoFile.dnGetpreviousHistoCryptoRepoFile(this) == null ? null : HistoCryptoRepoFile.dnGetpreviousHistoCryptoRepoFile(this).getHistoCryptoRepoFileId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[3] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[4] = InputStreamSource.Helper.createInputStreamSource((Uid)((CryptoRepoFile)((Object)AssertUtil.assertNotNull((Object)((Object)HistoCryptoRepoFile.dnGetcryptoRepoFile(this)), (String)"cryptoRepoFile"))).getCryptoRepoFileId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[5] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[6] = InputStreamSource.Helper.createInputStreamSource((Uid)((HistoFrame)((Object)AssertUtil.assertNotNull((Object)((Object)HistoCryptoRepoFile.dnGethistoFrame(this)), (String)"histoFrame"))).getHistoFrameId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[7] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[8] = InputStreamSource.Helper.createInputStreamSource((Uid)((CryptoKey)((Object)AssertUtil.assertNotNull((Object)((Object)HistoCryptoRepoFile.dnGetcryptoKey(this)), (String)"cryptoKey"))).getCryptoKeyId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[9] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[10] = InputStreamSource.Helper.createInputStreamSource((byte[])this.getRepoFileDtoData());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[11] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[12] = InputStreamSource.Helper.createInputStreamSource((Date)HistoCryptoRepoFile.dnGetdeleted(this));
            LinkedList<InputStreamSource> inputStreamSources = new LinkedList<InputStreamSource>(Arrays.asList(inputStreamSourceArray));
            if (signedDataVersion >= 1) {
                separatorIndex = (byte)(separatorIndex + 1);
                inputStreamSources.add(InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex));
                inputStreamSources.add(InputStreamSource.Helper.createInputStreamSource((boolean)HistoCryptoRepoFile.dnGetdeletedByIgnoreRule(this)));
            }
            if (signedDataVersion < 0 || signedDataVersion > 1) {
                throw new IllegalStateException("signedDataVersion=" + signedDataVersion);
            }
            return new MultiInputStream(inputStreamSources);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public Signature getSignature() {
        return HistoCryptoRepoFile.dnGetsignature(this);
    }

    public void setSignature(Signature signature) {
        if (!Util.equal((Object)HistoCryptoRepoFile.dnGetsignature(this), (Object)signature)) {
            HistoCryptoRepoFile.dnSetsignature(this, SignatureImpl.copy(signature));
        }
    }

    public Uid getCryptoRepoFileIdControllingPermissions() {
        return (Uid)AssertUtil.assertNotNull((Object)((CryptoRepoFile)((Object)AssertUtil.assertNotNull((Object)((Object)HistoCryptoRepoFile.dnGetcryptoRepoFile(this)), (String)"cryptoRepoFile"))).getCryptoRepoFileId(), (String)"cryptoRepoFileId");
    }

    public PermissionType getPermissionTypeRequiredForWrite() {
        return PermissionType.write;
    }

    public String toString() {
        return String.format("%s{histoCryptoRepoFileId=%s, cryptoRepoFileId=%s}", super.toString(), HistoCryptoRepoFile.dnGethistoCryptoRepoFileId(this), HistoCryptoRepoFile.dnGetcryptoRepoFile(this) == null ? null : HistoCryptoRepoFile.dnGetcryptoRepoFile(this).getCryptoRepoFileId());
    }

    static {
        dnFieldNames = HistoCryptoRepoFile.__dnFieldNamesInit();
        dnFieldTypes = HistoCryptoRepoFile.__dnFieldTypesInit();
        dnFieldFlags = HistoCryptoRepoFile.__dnFieldFlagsInit();
        dnInheritedFieldCount = HistoCryptoRepoFile.__dnGetInheritedFieldCount();
        dnPersistableSuperclass = HistoCryptoRepoFile.__dnPersistableSuperclassInit();
        EnhancementHelper.registerClass((Class)HistoCryptoRepoFile.___dn$loadClass("org.subshare.local.persistence.HistoCryptoRepoFile"), (String[])dnFieldNames, (Class[])dnFieldTypes, (byte[])dnFieldFlags, (Class)dnPersistableSuperclass, (Persistable)new HistoCryptoRepoFile());
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        HistoCryptoRepoFile result = new HistoCryptoRepoFile();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        HistoCryptoRepoFile result = new HistoCryptoRepoFile();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.cryptoKey = (CryptoKey)((Object)this.dnStateManager.replacingObjectField((Persistable)this, index));
                break;
            }
            case 1: {
                this.cryptoRepoFile = (CryptoRepoFile)((Object)this.dnStateManager.replacingObjectField((Persistable)this, index));
                break;
            }
            case 2: {
                this.deleted = (Date)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 3: {
                this.deletedByIgnoreRule = this.dnStateManager.replacingBooleanField((Persistable)this, index);
                break;
            }
            case 4: {
                this.histoCryptoRepoFileId = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 5: {
                this.histoFrame = (HistoFrame)((Object)this.dnStateManager.replacingObjectField((Persistable)this, index));
                break;
            }
            case 6: {
                this.lastSyncFromRepositoryId = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 7: {
                this.localRevision = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 8: {
                this.previousHistoCryptoRepoFile = (HistoCryptoRepoFile)((Object)this.dnStateManager.replacingObjectField((Persistable)this, index));
                break;
            }
            case 9: {
                this.repoFileDtoData = (byte[])this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 10: {
                this.signature = (SignatureImpl)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            default: {
                super.dnReplaceField(index);
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.cryptoKey);
                break;
            }
            case 1: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.cryptoRepoFile);
                break;
            }
            case 2: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.deleted);
                break;
            }
            case 3: {
                this.dnStateManager.providedBooleanField((Persistable)this, index, this.deletedByIgnoreRule);
                break;
            }
            case 4: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.histoCryptoRepoFileId);
                break;
            }
            case 5: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.histoFrame);
                break;
            }
            case 6: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.lastSyncFromRepositoryId);
                break;
            }
            case 7: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.localRevision);
                break;
            }
            case 8: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.previousHistoCryptoRepoFile);
                break;
            }
            case 9: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.repoFileDtoData);
                break;
            }
            case 10: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.signature);
                break;
            }
            default: {
                super.dnProvideField(index);
            }
        }
    }

    protected final void dnCopyField(HistoCryptoRepoFile obj, int index) {
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.cryptoKey = obj.cryptoKey;
                break;
            }
            case 1: {
                this.cryptoRepoFile = obj.cryptoRepoFile;
                break;
            }
            case 2: {
                this.deleted = obj.deleted;
                break;
            }
            case 3: {
                this.deletedByIgnoreRule = obj.deletedByIgnoreRule;
                break;
            }
            case 4: {
                this.histoCryptoRepoFileId = obj.histoCryptoRepoFileId;
                break;
            }
            case 5: {
                this.histoFrame = obj.histoFrame;
                break;
            }
            case 6: {
                this.lastSyncFromRepositoryId = obj.lastSyncFromRepositoryId;
                break;
            }
            case 7: {
                this.localRevision = obj.localRevision;
                break;
            }
            case 8: {
                this.previousHistoCryptoRepoFile = obj.previousHistoCryptoRepoFile;
                break;
            }
            case 9: {
                this.repoFileDtoData = obj.repoFileDtoData;
                break;
            }
            case 10: {
                this.signature = obj.signature;
                break;
            }
            default: {
                super.dnCopyField((Entity)obj, index);
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof HistoCryptoRepoFile)) {
            throw new IllegalArgumentException("object is not an object of type org.subshare.local.persistence.HistoCryptoRepoFile");
        }
        HistoCryptoRepoFile other = (HistoCryptoRepoFile)((Object)obj);
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"cryptoKey", "cryptoRepoFile", "deleted", "deletedByIgnoreRule", "histoCryptoRepoFileId", "histoFrame", "lastSyncFromRepositoryId", "localRevision", "previousHistoCryptoRepoFile", "repoFileDtoData", "signature"};
    }

    private static final Class[] __dnFieldTypesInit() {
        return new Class[]{HistoCryptoRepoFile.___dn$loadClass("org.subshare.local.persistence.CryptoKey"), HistoCryptoRepoFile.___dn$loadClass("org.subshare.local.persistence.CryptoRepoFile"), HistoCryptoRepoFile.___dn$loadClass("java.util.Date"), Boolean.TYPE, HistoCryptoRepoFile.___dn$loadClass("java.lang.String"), HistoCryptoRepoFile.___dn$loadClass("org.subshare.local.persistence.HistoFrame"), HistoCryptoRepoFile.___dn$loadClass("java.lang.String"), Long.TYPE, HistoCryptoRepoFile.___dn$loadClass("org.subshare.local.persistence.HistoCryptoRepoFile"), HistoCryptoRepoFile.___dn$loadClass("[B"), HistoCryptoRepoFile.___dn$loadClass("org.subshare.local.persistence.SignatureImpl")};
    }

    private static final byte[] __dnFieldFlagsInit() {
        return new byte[]{10, 10, 21, 21, 21, 10, 21, 21, 10, 26, 10};
    }

    protected static int __dnGetInheritedFieldCount() {
        return Entity.dnGetManagedFieldCount();
    }

    protected static int dnGetManagedFieldCount() {
        return 11 + Entity.dnGetManagedFieldCount();
    }

    private static Class __dnPersistableSuperclassInit() {
        return HistoCryptoRepoFile.___dn$loadClass("co.codewizards.cloudstore.local.persistence.Entity");
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object dnSuperClone() throws CloneNotSupportedException {
        HistoCryptoRepoFile o = (HistoCryptoRepoFile)((Object)super.clone());
        o.dnFlags = 0;
        o.dnStateManager = null;
        return o;
    }

    private static CryptoKey dnGetcryptoKey(HistoCryptoRepoFile objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0 + dnInheritedFieldCount)) {
            return (CryptoKey)((Object)objPC.dnStateManager.getObjectField((Persistable)objPC, 0 + dnInheritedFieldCount, (Object)objPC.cryptoKey));
        }
        return objPC.cryptoKey;
    }

    private static void dnSetcryptoKey(HistoCryptoRepoFile objPC, CryptoKey val) {
        if (objPC.dnStateManager == null) {
            objPC.cryptoKey = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 0 + dnInheritedFieldCount, (Object)objPC.cryptoKey, (Object)val);
        }
    }

    private static CryptoRepoFile dnGetcryptoRepoFile(HistoCryptoRepoFile objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1 + dnInheritedFieldCount)) {
            return (CryptoRepoFile)((Object)objPC.dnStateManager.getObjectField((Persistable)objPC, 1 + dnInheritedFieldCount, (Object)objPC.cryptoRepoFile));
        }
        return objPC.cryptoRepoFile;
    }

    private static void dnSetcryptoRepoFile(HistoCryptoRepoFile objPC, CryptoRepoFile val) {
        if (objPC.dnStateManager == null) {
            objPC.cryptoRepoFile = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 1 + dnInheritedFieldCount, (Object)objPC.cryptoRepoFile, (Object)val);
        }
    }

    private static Date dnGetdeleted(HistoCryptoRepoFile objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2 + dnInheritedFieldCount)) {
            return (Date)objPC.dnStateManager.getObjectField((Persistable)objPC, 2 + dnInheritedFieldCount, (Object)objPC.deleted);
        }
        return objPC.deleted;
    }

    private static void dnSetdeleted(HistoCryptoRepoFile objPC, Date val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 2 + dnInheritedFieldCount, (Object)objPC.deleted, (Object)val);
        } else {
            objPC.deleted = val;
        }
    }

    private static boolean dnGetdeletedByIgnoreRule(HistoCryptoRepoFile objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getBooleanField((Persistable)objPC, 3 + dnInheritedFieldCount, objPC.deletedByIgnoreRule);
        }
        return objPC.deletedByIgnoreRule;
    }

    private static void dnSetdeletedByIgnoreRule(HistoCryptoRepoFile objPC, boolean val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setBooleanField((Persistable)objPC, 3 + dnInheritedFieldCount, objPC.deletedByIgnoreRule, val);
        } else {
            objPC.deletedByIgnoreRule = val;
        }
    }

    private static String dnGethistoCryptoRepoFileId(HistoCryptoRepoFile objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 4 + dnInheritedFieldCount, objPC.histoCryptoRepoFileId);
        }
        return objPC.histoCryptoRepoFileId;
    }

    private static void dnSethistoCryptoRepoFileId(HistoCryptoRepoFile objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 4 + dnInheritedFieldCount, objPC.histoCryptoRepoFileId, val);
        } else {
            objPC.histoCryptoRepoFileId = val;
        }
    }

    private static HistoFrame dnGethistoFrame(HistoCryptoRepoFile objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 5 + dnInheritedFieldCount)) {
            return (HistoFrame)((Object)objPC.dnStateManager.getObjectField((Persistable)objPC, 5 + dnInheritedFieldCount, (Object)objPC.histoFrame));
        }
        return objPC.histoFrame;
    }

    private static void dnSethistoFrame(HistoCryptoRepoFile objPC, HistoFrame val) {
        if (objPC.dnStateManager == null) {
            objPC.histoFrame = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 5 + dnInheritedFieldCount, (Object)objPC.histoFrame, (Object)val);
        }
    }

    private static String dnGetlastSyncFromRepositoryId(HistoCryptoRepoFile objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 6 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 6 + dnInheritedFieldCount, objPC.lastSyncFromRepositoryId);
        }
        return objPC.lastSyncFromRepositoryId;
    }

    private static void dnSetlastSyncFromRepositoryId(HistoCryptoRepoFile objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 6 + dnInheritedFieldCount, objPC.lastSyncFromRepositoryId, val);
        } else {
            objPC.lastSyncFromRepositoryId = val;
        }
    }

    private static long dnGetlocalRevision(HistoCryptoRepoFile objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 7 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getLongField((Persistable)objPC, 7 + dnInheritedFieldCount, objPC.localRevision);
        }
        return objPC.localRevision;
    }

    private static void dnSetlocalRevision(HistoCryptoRepoFile objPC, long val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setLongField((Persistable)objPC, 7 + dnInheritedFieldCount, objPC.localRevision, val);
        } else {
            objPC.localRevision = val;
        }
    }

    private static HistoCryptoRepoFile dnGetpreviousHistoCryptoRepoFile(HistoCryptoRepoFile objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 8 + dnInheritedFieldCount)) {
            return (HistoCryptoRepoFile)((Object)objPC.dnStateManager.getObjectField((Persistable)objPC, 8 + dnInheritedFieldCount, (Object)objPC.previousHistoCryptoRepoFile));
        }
        return objPC.previousHistoCryptoRepoFile;
    }

    private static void dnSetpreviousHistoCryptoRepoFile(HistoCryptoRepoFile objPC, HistoCryptoRepoFile val) {
        if (objPC.dnStateManager == null) {
            objPC.previousHistoCryptoRepoFile = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 8 + dnInheritedFieldCount, (Object)objPC.previousHistoCryptoRepoFile, (Object)val);
        }
    }

    private static byte[] dnGetrepoFileDtoData(HistoCryptoRepoFile objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 9 + dnInheritedFieldCount)) {
            return (byte[])objPC.dnStateManager.getObjectField((Persistable)objPC, 9 + dnInheritedFieldCount, (Object)objPC.repoFileDtoData);
        }
        return objPC.repoFileDtoData;
    }

    private static void dnSetrepoFileDtoData(HistoCryptoRepoFile objPC, byte[] val) {
        if (objPC.dnStateManager == null) {
            objPC.repoFileDtoData = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 9 + dnInheritedFieldCount, (Object)objPC.repoFileDtoData, (Object)val);
        }
    }

    private static SignatureImpl dnGetsignature(HistoCryptoRepoFile objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 10 + dnInheritedFieldCount)) {
            return (SignatureImpl)objPC.dnStateManager.getObjectField((Persistable)objPC, 10 + dnInheritedFieldCount, (Object)objPC.signature);
        }
        return objPC.signature;
    }

    private static void dnSetsignature(HistoCryptoRepoFile objPC, SignatureImpl val) {
        if (objPC.dnStateManager == null) {
            objPC.signature = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 10 + dnInheritedFieldCount, (Object)objPC.signature, (Object)val);
        }
    }
}

