/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.crypto;

import co.codewizards.cloudstore.core.util.AssertUtil;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.subshare.core.crypto.CipherTransformation;
import org.subshare.core.crypto.EncrypterDecrypterStreamUtil;
import org.subshare.core.crypto.IvFactory;
import org.subshare.core.dto.CryptoKeyType;
import org.subshare.crypto.Cipher;
import org.subshare.crypto.CipherOperationMode;
import org.subshare.crypto.CryptoRegistry;

public class EncrypterOutputStream
extends FilterOutputStream {
    public static final int MAGIC_BYTE = 60;
    private final CipherTransformation cipherTransformation;
    private final Cipher cipher;
    private final byte[] iv;
    private byte[] cipherBuffer;
    private boolean closed;
    private boolean closeUnderlyingStream = true;

    public EncrypterOutputStream(OutputStream out, CipherTransformation cipherTransformation, CipherParameters key) throws IOException {
        this(out, cipherTransformation, key, null);
    }

    public EncrypterOutputStream(OutputStream out, CipherTransformation cipherTransformation, CipherParameters key, IvFactory ivFactory) throws IOException {
        super((OutputStream)AssertUtil.assertNotNull((Object)out, (String)"out"));
        this.cipherTransformation = (CipherTransformation)((Object)AssertUtil.assertNotNull((Object)((Object)cipherTransformation), (String)"cipherTransformation"));
        EncrypterDecrypterStreamUtil.assertValidKey(cipherTransformation, key);
        this.cipher = this.createCipher();
        if (ivFactory == null) {
            this.iv = null;
        } else {
            if (CryptoKeyType.asymmetric == cipherTransformation.getType()) {
                throw new IllegalArgumentException("Cannot use an IV in asymmetric encryption!");
            }
            ivFactory.setCipher(this.cipher);
            this.iv = ivFactory.createIv();
            ivFactory.setCipher(null);
        }
        Object cipherParameters = this.iv == null ? key : new ParametersWithIV(key, this.iv);
        this.cipher.init(CipherOperationMode.ENCRYPT, cipherParameters);
        this.writeHeader();
    }

    private Cipher createCipher() {
        try {
            return CryptoRegistry.getInstance().createCipher(this.cipherTransformation.getTransformation());
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeHeader() throws IOException {
        this.out.write(60);
        this.out.write(1);
        int cipherTransformationNumeric = this.cipherTransformation.ordinal();
        if (cipherTransformationNumeric > 65535) {
            throw new IllegalStateException("cipherTransformationNumeric > 65535");
        }
        this.out.write(cipherTransformationNumeric);
        this.out.write(cipherTransformationNumeric >>> 8);
        int ivLength = this.iv == null ? 0 : this.iv.length;
        if (ivLength > 65535) {
            throw new IllegalStateException("ivLength > 65535");
        }
        this.out.write(ivLength);
        this.out.write(ivLength >>> 8);
        if (ivLength > 0) {
            this.out.write(this.iv);
        }
    }

    @Override
    public void write(int b) throws IOException {
        int bytesWritten;
        this.assertNotClosed();
        int outputSize = this.cipher.getOutputSize(1);
        this.ensureCipherBufferMinLength(outputSize);
        try {
            bytesWritten = this.cipher.update((byte)b, this.cipherBuffer, 0);
        }
        catch (IllegalStateException | CryptoException | DataLengthException e) {
            throw new IOException(e);
        }
        if (bytesWritten > 0) {
            this.out.write(this.cipherBuffer, 0, bytesWritten);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int bytesWritten;
        this.assertNotClosed();
        int outputSize = this.cipher.getOutputSize(len);
        this.ensureCipherBufferMinLength(outputSize);
        try {
            bytesWritten = this.cipher.update(b, off, len, this.cipherBuffer, 0);
        }
        catch (IllegalStateException | CryptoException | DataLengthException e) {
            throw new IOException(e);
        }
        if (bytesWritten > 0) {
            this.out.write(this.cipherBuffer, 0, bytesWritten);
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("EncrypterOutputStream already closed!");
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            int bytesWritten;
            this.closed = true;
            int outputSize = this.cipher.getOutputSize(0);
            this.ensureCipherBufferMinLength(outputSize);
            try {
                bytesWritten = this.cipher.doFinal(this.cipherBuffer, 0);
            }
            catch (IllegalStateException | CryptoException | DataLengthException e) {
                throw new IOException(e);
            }
            if (bytesWritten > 0) {
                this.out.write(this.cipherBuffer, 0, bytesWritten);
            }
            if (this.isCloseUnderlyingStream()) {
                this.out.close();
            }
        }
    }

    public boolean isCloseUnderlyingStream() {
        return this.closeUnderlyingStream;
    }

    public void setCloseUnderlyingStream(boolean closeUnderlyingStream) {
        this.closeUnderlyingStream = closeUnderlyingStream;
    }

    private void ensureCipherBufferMinLength(int minLength) {
        if (minLength < 0) {
            throw new IllegalArgumentException("minLength < 0");
        }
        if (this.cipherBuffer == null || this.cipherBuffer.length < minLength) {
            this.cipherBuffer = new byte[minLength];
        }
    }
}

