/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.io;

import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.io.InputStreamSource;

public class MultiInputStream
extends InputStream
implements IInputStream {
    private static final Logger logger = LoggerFactory.getLogger(MultiInputStream.class);
    private final Iterator<? extends InputStreamSource> inputStreamSourcesIterator;
    private InputStream inputStream;

    public MultiInputStream(InputStreamSource ... inputStreamSources) throws IOException {
        this(Arrays.asList((Object[])AssertUtil.assertNotNull((Object)inputStreamSources, (String)"inputStreamSources")));
    }

    public MultiInputStream(Collection<? extends InputStreamSource> inputStreamSources) throws IOException {
        this(((Collection)AssertUtil.assertNotNull(inputStreamSources, (String)"inputStreamSources")).iterator());
    }

    public MultiInputStream(Iterator<? extends InputStreamSource> inputStreamSourcesIterator) throws IOException {
        this.inputStreamSourcesIterator = (Iterator)AssertUtil.assertNotNull(inputStreamSourcesIterator, (String)"inputStreamSourcesIterator");
        this.nextInputStream();
    }

    private void nextInputStream() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        this.inputStream = this.inputStreamSourcesIterator.hasNext() ? this.inputStreamSourcesIterator.next().createInputStream() : null;
    }

    @Override
    public int read() throws IOException {
        int result;
        while ((result = this.inputStream == null ? -1 : this.inputStream.read()) < 0) {
            this.nextInputStream();
            if (this.inputStream != null) continue;
            break;
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result;
        while ((result = this.inputStream == null ? -1 : this.inputStream.read(b, off, len)) <= 0) {
            this.nextInputStream();
            if (this.inputStream != null) continue;
            break;
        }
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        long result;
        while ((result = this.inputStream == null ? 0L : this.inputStream.skip(n)) <= 0L) {
            this.nextInputStream();
            if (this.inputStream != null) continue;
            break;
        }
        return result;
    }

    @Override
    public int available() throws IOException {
        int result;
        while ((result = this.inputStream == null ? 0 : this.inputStream.available()) <= 0) {
            this.nextInputStream();
            if (this.inputStream != null) continue;
            break;
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        ArrayList<Exception> errors = new ArrayList<Exception>(1);
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (Exception x) {
                errors.add(x);
                logger.warn("close: Closing underlying InputStream failed: " + x, (Throwable)x);
            }
            this.inputStream = null;
        }
        while (this.inputStreamSourcesIterator.hasNext()) {
            InputStreamSource inputStreamSource = this.inputStreamSourcesIterator.next();
            try {
                inputStreamSource.discard();
            }
            catch (Exception x) {
                errors.add(x);
                logger.warn("close: Discarding underlying InputStreamSource failed: " + x, (Throwable)x);
            }
        }
        if (!errors.isEmpty()) {
            throw new IOException((Throwable)errors.get(0));
        }
    }
}

