/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.repo.sync;

import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.IOUtil;

public class PaddingUtil {
    private static final int chunkPayloadLengthBytesLength = 4;

    private PaddingUtil() {
    }

    public static byte[] addPadding(byte[] fileData, int paddingLength) {
        AssertUtil.assertNotNull((Object)fileData, (String)"fileData");
        if (paddingLength < 0) {
            throw new IllegalArgumentException("paddingLength < 0");
        }
        int index = -1;
        byte[] result = new byte[5 + fileData.length + paddingLength];
        result[++index] = 1;
        byte[] lengthBytes = IOUtil.intToBytes((int)fileData.length);
        if (lengthBytes.length != 4) {
            throw new IllegalStateException("lengthBytes.length != chunkPayloadLengthBytesLength");
        }
        for (int i = 0; i < lengthBytes.length; ++i) {
            result[++index] = lengthBytes[i];
        }
        System.arraycopy(fileData, 0, result, ++index, fileData.length);
        return result;
    }

    public static byte[] removePadding(byte[] fileData) {
        AssertUtil.assertNotNull((Object)fileData, (String)"fileData");
        int index = -1;
        byte version = fileData[++index];
        if (version != 1) {
            throw new IllegalArgumentException(String.format("version == %d != 1", version));
        }
        byte[] lengthBytes = new byte[4];
        for (int i = 0; i < lengthBytes.length; ++i) {
            lengthBytes[i] = fileData[++index];
        }
        int length = IOUtil.bytesToInt((byte[])lengthBytes);
        byte[] result = new byte[length];
        System.arraycopy(fileData, ++index, result, 0, result.length);
        return result;
    }
}

