/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.util;

import java.util.Collection;

public final class AssertUtil {
    private AssertUtil() {
    }

    public static final <T> T assertNotNull(T object, String name) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("%s == null", name));
        }
        return object;
    }

    public static final <T> T assertNotNull(T object, String name, String additionalInfoTemplate, Object ... additionalInfoArgs) {
        if (additionalInfoTemplate == null) {
            return AssertUtil.assertNotNull(object, name);
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("%s == null :: ", name) + String.format(additionalInfoTemplate, additionalInfoArgs));
        }
        return object;
    }

    public static final <T> T[] assertNotNullAndNoNullElement(T[] array, String name) {
        AssertUtil.assertNotNull(array, name);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) continue;
            throw new IllegalArgumentException(String.format("%s[%s] == null", name, i));
        }
        return array;
    }

    public static final <E, T extends Collection<E>> T assertNotNullAndNoNullElement(T collection, String name) {
        AssertUtil.assertNotNull(collection, name);
        int i = -1;
        for (E element : collection) {
            ++i;
            if (element != null) continue;
            throw new IllegalArgumentException(String.format("%s[%s] == null", name, i));
        }
        return collection;
    }

    public static final <E, T extends Collection<E>> T assertNotEmpty(T collection, String name) {
        AssertUtil.assertNotNull(collection, name);
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(String.format("%s is empty", name));
        }
        return collection;
    }
}

