/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.ignore;

import co.codewizards.cloudstore.core.config.Config;
import co.codewizards.cloudstore.core.config.ConfigImpl;
import co.codewizards.cloudstore.core.ignore.IgnoreRule;
import co.codewizards.cloudstore.core.ignore.IgnoreRuleImpl;
import co.codewizards.cloudstore.core.ignore.IgnoreRuleManager;
import co.codewizards.cloudstore.core.objectfactory.ObjectFactoryUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.repo.local.LocalRepoHelper;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Util;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgnoreRuleManagerImpl
implements IgnoreRuleManager {
    private static final Logger logger = LoggerFactory.getLogger(IgnoreRuleManagerImpl.class);
    private final File directory;
    private Config config;
    private List<IgnoreRule> ignoreRules;
    private Long configVersion;
    private static final Object classMutex = IgnoreRuleManagerImpl.class;
    private final Object instanceMutex = this;
    private static final long fileRefsCleanPeriod = 60000L;
    private static long fileRefsCleanLastTimestamp;
    private static final LinkedHashSet<File> fileHardRefs;
    private static final int fileHardRefsMaxSize = 10;
    private static final LinkedList<SoftReference<File>> fileSoftRefs;
    private static final Map<File, IgnoreRuleManagerImpl> file2IgnoreRuleManager;

    protected IgnoreRuleManagerImpl(File directory) {
        this.directory = AssertUtil.assertNotNull(directory, "directory");
        this.config = ConfigImpl.getInstanceForDirectory(this.directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanFileRefs() {
        Object object = classMutex;
        synchronized (object) {
            if (System.currentTimeMillis() - fileRefsCleanLastTimestamp < 60000L) {
                return;
            }
            Iterator it = fileSoftRefs.iterator();
            while (it.hasNext()) {
                SoftReference fileRef = (SoftReference)it.next();
                if (fileRef.get() != null) continue;
                it.remove();
            }
            fileRefsCleanLastTimestamp = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IgnoreRuleManager getInstanceForDirectory(File directory) {
        IgnoreRuleManagerImpl irm;
        AssertUtil.assertNotNull(directory, "directory");
        IgnoreRuleManagerImpl.cleanFileRefs();
        File irm_dir = null;
        Object object = classMutex;
        synchronized (object) {
            irm = file2IgnoreRuleManager.get(directory);
            if (irm != null && (irm_dir = irm.directory) == null) {
                irm = null;
            }
            if (irm == null) {
                File localRoot = LocalRepoHelper.getLocalRootContainingFile(directory);
                if (localRoot == null) {
                    throw new IllegalArgumentException("directory is not inside a repository: " + directory.getAbsolutePath());
                }
                irm = new IgnoreRuleManagerImpl(directory);
                file2IgnoreRuleManager.put(directory, irm);
                fileSoftRefs.add(new SoftReference<File>(directory));
                irm_dir = irm.directory;
            }
            AssertUtil.assertNotNull(irm_dir, "irm_dir");
        }
        IgnoreRuleManagerImpl.refreshFileHardRefAndCleanOldHardRefs(irm_dir);
        return irm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IgnoreRule> getIgnoreRules() {
        this.refreshFileHardRefAndCleanOldHardRefs();
        Object object = this.instanceMutex;
        synchronized (object) {
            Long newConfigVersion = this.config.getVersion();
            if (!Util.equal(this.configVersion, newConfigVersion)) {
                this.ignoreRules = null;
            }
            if (this.ignoreRules == null) {
                Set<String> ignoreRuleIds = this.getIgnoreRuleIds();
                ArrayList<IgnoreRule> result = new ArrayList<IgnoreRule>(ignoreRuleIds.size());
                for (String ignoreRuleId : ignoreRuleIds) {
                    IgnoreRule ignoreRule = this.loadIgnoreRule(ignoreRuleId);
                    if (ignoreRule == null) continue;
                    result.add(ignoreRule);
                }
                this.configVersion = newConfigVersion;
                this.ignoreRules = Collections.unmodifiableList(result);
                logger.debug("getIgnoreRules: Loaded for newConfigVersion={}: {}", (Object)newConfigVersion, this.ignoreRules);
            }
            return this.ignoreRules;
        }
    }

    private Set<String> getIgnoreRuleIds() {
        HashSet<String> result = new HashSet<String>();
        Map<String, List<String>> key2Groups = this.config.getKey2GroupsMatching(Pattern.compile("ignore\\[([^]]*)\\].*"));
        for (List<String> groups : key2Groups.values()) {
            String ignoreRuleId = groups.get(0);
            result.add(ignoreRuleId);
        }
        return result;
    }

    @Override
    public boolean isIgnored(File file) {
        String fileName = AssertUtil.assertNotNull(file, "file").getName();
        if (!this.directory.equals(file.getParentFile())) {
            throw new IllegalArgumentException(String.format("file '%s' is not located within parent-directory '%s'!", file.getAbsolutePath(), this.directory.getAbsolutePath()));
        }
        if (fileName.equalsIgnoreCase(Config.PROPERTIES_FILE_NAME_FOR_DIRECTORY_LOCAL)) {
            return true;
        }
        if (fileName.equalsIgnoreCase(Config.PROPERTIES_FILE_NAME_FOR_DIRECTORY)) {
            return false;
        }
        for (IgnoreRule ignoreRule : this.getIgnoreRules()) {
            boolean matches;
            if (!ignoreRule.isEnabled() || !(matches = ignoreRule.getNameRegexPattern().matcher(fileName).matches())) continue;
            return true;
        }
        return false;
    }

    private IgnoreRule loadIgnoreRule(String ignoreRuleId) {
        AssertUtil.assertNotNull(ignoreRuleId, "ignoreRuleId");
        String namePattern = this.config.getProperty(this.getConfigKeyNamePattern(ignoreRuleId), null);
        String nameRegex = this.config.getProperty(this.getConfigKeyNameRegex(ignoreRuleId), null);
        if (namePattern == null && nameRegex == null) {
            return null;
        }
        if (namePattern != null && nameRegex != null) {
            logger.warn("loadIgnoreRule: ignoreRuleId={}: namePattern='{}' and nameRegex='{}' are both specified! Ignoring namePattern!", new Object[]{ignoreRuleId, namePattern, nameRegex});
            namePattern = null;
        }
        IgnoreRule ignoreRule = ObjectFactoryUtil.createObject(IgnoreRuleImpl.class);
        ignoreRule.setIgnoreRuleId(ignoreRuleId);
        ignoreRule.setNamePattern(namePattern);
        ignoreRule.setNameRegex(nameRegex);
        ignoreRule.setEnabled(this.config.getPropertyAsBoolean(this.getConfigKeyEnabled(ignoreRuleId), true));
        ignoreRule.setCaseSensitive(this.config.getPropertyAsBoolean(this.getConfigKeyCaseSensitive(ignoreRuleId), false));
        return ignoreRule;
    }

    private String getConfigKeyNamePattern(String ignoreRuleId) {
        return this.getConfigKeyIgnorePrefix(ignoreRuleId) + "namePattern";
    }

    private String getConfigKeyNameRegex(String ignoreRuleId) {
        return this.getConfigKeyIgnorePrefix(ignoreRuleId) + "nameRegex";
    }

    private String getConfigKeyEnabled(String ignoreRuleId) {
        return this.getConfigKeyIgnorePrefix(ignoreRuleId) + "enabled";
    }

    private String getConfigKeyCaseSensitive(String ignoreRuleId) {
        return this.getConfigKeyIgnorePrefix(ignoreRuleId) + "caseSensitive";
    }

    private String getConfigKeyIgnorePrefix(String ignoreRuleId) {
        AssertUtil.assertNotNull(ignoreRuleId, "ignoreRuleId");
        return "ignore[" + ignoreRuleId + "].";
    }

    private static final void refreshFileHardRefAndCleanOldHardRefs(IgnoreRuleManagerImpl ignoreRuleManager) {
        File dir = AssertUtil.assertNotNull(ignoreRuleManager, (String)"ignoreRuleManager").directory;
        if (dir != null) {
            IgnoreRuleManagerImpl.refreshFileHardRefAndCleanOldHardRefs(dir);
        }
    }

    private final void refreshFileHardRefAndCleanOldHardRefs() {
        IgnoreRuleManagerImpl.refreshFileHardRefAndCleanOldHardRefs(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void refreshFileHardRefAndCleanOldHardRefs(File dir) {
        AssertUtil.assertNotNull(dir, "dir");
        LinkedHashSet<File> linkedHashSet = fileHardRefs;
        synchronized (linkedHashSet) {
            fileHardRefs.remove(dir);
            fileHardRefs.add(dir);
            while (fileHardRefs.size() > 10) {
                fileHardRefs.remove(fileHardRefs.iterator().next());
            }
        }
    }

    static {
        fileHardRefs = new LinkedHashSet();
        fileSoftRefs = new LinkedList();
        file2IgnoreRuleManager = new WeakHashMap<File, IgnoreRuleManagerImpl>();
    }
}

