/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.util;

import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Util;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtil {
    private static final Logger logger = LoggerFactory.getLogger(ReflectionUtil.class);
    private static final Map<Class<?>, Reference<List<Field>>> class2AllDeclaredFields = Collections.synchronizedMap(new WeakHashMap());

    private ReflectionUtil() {
    }

    public static <T> T invokeConstructor(Class<T> clazz, Object ... args) {
        String methodNameWithParameterTypes;
        AssertUtil.assertNotNull(clazz, "clazz");
        Class<?>[] argTypes = ReflectionUtil.getArgumentTypes(args);
        ArrayList compatibleConstructors = new ArrayList();
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (!ReflectionUtil.isConstructorCompatible(constructor, argTypes)) continue;
            compatibleConstructors.add(constructor);
        }
        if (compatibleConstructors.isEmpty()) {
            methodNameWithParameterTypes = ReflectionUtil.createMethodNameWithParameterTypes(clazz.getSimpleName(), argTypes);
            throw new IllegalArgumentException(new NoSuchMethodException(String.format("None of the constructors of %s matches %s (or an equivalent using super-types of these parameter-types)!", clazz.getName(), methodNameWithParameterTypes)));
        }
        if (compatibleConstructors.size() > 1 && logger.isDebugEnabled()) {
            methodNameWithParameterTypes = ReflectionUtil.createMethodNameWithParameterTypes(clazz.getSimpleName(), argTypes);
            String msg = String.format("%s declares multiple constructors matching %s (or an equivalent using super-types of these parameter-types)!", clazz.getName(), methodNameWithParameterTypes);
            logger.warn("invokeConstructor: {}", (Object)msg);
        }
        return Util.cast(ReflectionUtil.invoke((Constructor)compatibleConstructors.get(0), args));
    }

    public static <T> T invokeConstructor(Class<T> clazz, Class<?>[] parameterTypes, Object ... args) {
        Constructor<T> constructor = ReflectionUtil.getDeclaredConstructorOrFail(clazz, parameterTypes);
        return ReflectionUtil.invoke(constructor, args);
    }

    public static <T> T invokeStatic(Class<?> clazz, String methodName, Object ... args) {
        AssertUtil.assertNotNull(clazz, "clazz");
        AssertUtil.assertNotNull(methodName, "methodName");
        return ReflectionUtil.invoke(clazz, null, methodName, args);
    }

    public static <T> T invokeStatic(Class<?> clazz, String methodName, Class<?>[] parameterTypes, Object ... args) {
        Method method = ReflectionUtil.getDeclaredMethodOrFail(clazz, methodName, parameterTypes);
        return ReflectionUtil.invoke(null, method, args);
    }

    public static <T> T invoke(Object object, String methodName, Object ... args) {
        AssertUtil.assertNotNull(object, "object");
        AssertUtil.assertNotNull(methodName, "methodName");
        return ReflectionUtil.invoke(object.getClass(), object, methodName, args);
    }

    private static <T> T invoke(Class<?> clazz, Object object, String methodName, Object ... args) {
        String methodNameWithParameterTypes;
        AssertUtil.assertNotNull(clazz, "clazz");
        AssertUtil.assertNotNull(methodName, "methodName");
        Class<?>[] argTypes = ReflectionUtil.getArgumentTypes(args);
        List<Method> methods = ReflectionUtil.getDeclaredMethods(clazz, methodName);
        ArrayList<Method> compatibleMethods = new ArrayList<Method>(Math.min(5, methods.size()));
        for (Method method : methods) {
            if (!ReflectionUtil.isMethodCompatible(method, argTypes)) continue;
            compatibleMethods.add(method);
        }
        if (compatibleMethods.isEmpty()) {
            methodNameWithParameterTypes = ReflectionUtil.createMethodNameWithParameterTypes(methodName, argTypes);
            throw new IllegalArgumentException(new NoSuchMethodException(String.format("Neither %s nor one of its super-classes declares the method %s (or an equivalent using super-types of these parameter-types)!", clazz.getName(), methodNameWithParameterTypes)));
        }
        if (compatibleMethods.size() > 1 && logger.isDebugEnabled()) {
            methodNameWithParameterTypes = ReflectionUtil.createMethodNameWithParameterTypes(methodName, argTypes);
            String msg = String.format("%s and its super-classes declare multiple methods matching %s (or an equivalent using super-types of these parameter-types)!", clazz.getName(), methodNameWithParameterTypes);
            logger.warn("invoke: {}", (Object)msg);
        }
        return ReflectionUtil.invoke(object, (Method)compatibleMethods.get(0), args);
    }

    private static Class<?>[] getArgumentTypes(Object ... args) {
        Class[] argTypes = args == null ? new Class[]{} : new Class[args.length];
        for (int i = 0; i < argTypes.length; ++i) {
            argTypes[i] = args[i] == null ? null : args[i].getClass();
        }
        return argTypes;
    }

    public static <T> T invoke(Object object, String methodName, Class<?>[] parameterTypes, Object ... args) {
        AssertUtil.assertNotNull(object, "object");
        AssertUtil.assertNotNull(methodName, "methodName");
        if (parameterTypes == null) {
            return ReflectionUtil.invoke(object, methodName, args);
        }
        Method method = ReflectionUtil.getDeclaredMethodOrFail(object.getClass(), methodName, parameterTypes);
        return ReflectionUtil.invoke(object, method, args);
    }

    private static <T> T invoke(Constructor<T> constructor, Object ... args) {
        try {
            constructor.setAccessible(true);
            T result = constructor.newInstance(args);
            return Util.cast(result);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private static <T> T invoke(Object object, Method method, Object ... args) {
        try {
            method.setAccessible(true);
            Object result = method.invoke(object, args);
            return Util.cast(result);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    private static boolean isConstructorCompatible(Constructor constructor, Class<?>[] argTypes) {
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        return ReflectionUtil.areMethodParametersCompatible(parameterTypes, argTypes);
    }

    private static boolean isMethodCompatible(Method method, Class<?>[] argTypes) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return ReflectionUtil.areMethodParametersCompatible(parameterTypes, argTypes);
    }

    private static boolean areMethodParametersCompatible(Class<?>[] parameterTypes, Class<?>[] argTypes) {
        if (argTypes.length != parameterTypes.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (argTypes[i] == null || parameterTypes[i].isAssignableFrom(argTypes[i]) || ReflectionUtil.isSimpleTypeAssignmentPossible(parameterTypes[i], argTypes[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isSimpleTypeAssignmentPossible(Class<?> parameterType, Class<?> argType) {
        if (parameterType == Boolean.TYPE && argType == Boolean.class) {
            return true;
        }
        if (parameterType == Byte.TYPE && argType == Byte.class) {
            return true;
        }
        if (parameterType == Character.TYPE && argType == Character.class) {
            return true;
        }
        if (parameterType == Double.TYPE && argType == Double.class) {
            return true;
        }
        if (parameterType == Float.TYPE && argType == Float.class) {
            return true;
        }
        if (parameterType == Integer.TYPE && argType == Integer.class) {
            return true;
        }
        if (parameterType == Long.TYPE && argType == Long.class) {
            return true;
        }
        return parameterType == Short.TYPE && argType == Short.class;
    }

    public static List<Method> getDeclaredMethods(Class<?> clazz, String name) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = c.getDeclaredMethods()) {
                if (!name.equals(method.getName())) continue;
                result.add(method);
            }
        }
        return result;
    }

    public static <T> Constructor<T> getDeclaredConstructorOrFail(Class<T> clazz, Class<?>[] parameterTypes) {
        Constructor<T> constructor;
        try {
            constructor = clazz.getDeclaredConstructor(parameterTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            String methodNameWithParameterTypes = ReflectionUtil.createMethodNameWithParameterTypes(clazz.getName(), parameterTypes);
            throw new IllegalArgumentException(new NoSuchMethodException(String.format("%s does not declare the method %s!", clazz.getName(), methodNameWithParameterTypes)).initCause(e));
        }
        return constructor;
    }

    public static Method getDeclaredMethodOrFail(Class<?> clazz, String name, Class<?>[] parameterTypes) {
        Method method = ReflectionUtil.getDeclaredMethod(clazz, name, parameterTypes);
        if (method == null) {
            String methodNameWithParameterTypes = ReflectionUtil.createMethodNameWithParameterTypes(name, parameterTypes);
            throw new IllegalArgumentException(new NoSuchMethodException(String.format("Neither %s nor one of its super-classes declares the method %s!", clazz.getName(), methodNameWithParameterTypes)));
        }
        return method;
    }

    private static String createMethodNameWithParameterTypes(String name, Class<?>[] parameterTypes) {
        StringBuilder sb = new StringBuilder();
        if (parameterTypes == null) {
            return name + "(...)";
        }
        for (Class<?> parameterType : parameterTypes) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(parameterType.getName());
        }
        return name + '(' + sb.toString() + ')';
    }

    public static Method getDeclaredMethod(Class<?> clazz, String name, Class<?>[] parameterTypes) {
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            try {
                Method declaredMethod = c.getDeclaredMethod(name, parameterTypes);
                return declaredMethod;
            }
            catch (NoSuchMethodException x) {
                Util.doNothing();
                continue;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Field> getAllDeclaredFields(Class<?> clazz) {
        AssertUtil.assertNotNull(clazz, "clazz");
        Class<?> clazz2 = clazz;
        synchronized (clazz2) {
            List<Field> result;
            Reference<List<Field>> resultRef = class2AllDeclaredFields.get(clazz);
            List<Field> list = result = resultRef == null ? null : resultRef.get();
            if (result == null) {
                result = new ArrayList<Field>();
                for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
                    Field[] declaredFields;
                    for (Field field : declaredFields = c.getDeclaredFields()) {
                        result.add(field);
                    }
                }
                ((ArrayList)result).trimToSize();
                class2AllDeclaredFields.put(clazz, new WeakReference<List<Field>>(result));
            }
            return result;
        }
    }

    public static Map<Field, Object> getAllDeclaredFieldValues(Object object) {
        AssertUtil.assertNotNull(object, "object");
        List<Field> allDeclaredFields = ReflectionUtil.getAllDeclaredFields(object.getClass());
        HashMap<Field, Object> result = new HashMap<Field, Object>(allDeclaredFields.size());
        for (Field field : allDeclaredFields) {
            field.setAccessible(true);
            try {
                Object fieldValue = field.get(object);
                result.put(field, fieldValue);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static <V> V getFieldValue(Object object, String fieldName) {
        AssertUtil.assertNotNull(object, "object");
        AssertUtil.assertNotNull(fieldName, "fieldName");
        String className = null;
        String simpleFieldName = fieldName;
        int lastDotIndex = fieldName.lastIndexOf(46);
        if (lastDotIndex >= 0) {
            className = fieldName.substring(0, lastDotIndex);
            simpleFieldName = fieldName.substring(lastDotIndex + 1);
        }
        List<Field> declaredFields = ReflectionUtil.getAllDeclaredFields(object.getClass());
        for (Field field : declaredFields) {
            if (className != null && !className.equals(field.getDeclaringClass().getName()) || !simpleFieldName.equals(field.getName())) continue;
            field.setAccessible(true);
            try {
                Object value = field.get(object);
                return (V)value;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException(String.format("object's class %s does not have this field: %s", object.getClass(), fieldName));
    }

    public static void setFieldValue(Object object, String fieldName, Object value) {
        AssertUtil.assertNotNull(object, "object");
        AssertUtil.assertNotNull(fieldName, "fieldName");
        String className = null;
        String simpleFieldName = fieldName;
        int lastDotIndex = fieldName.lastIndexOf(46);
        if (lastDotIndex >= 0) {
            className = fieldName.substring(0, lastDotIndex);
            simpleFieldName = fieldName.substring(lastDotIndex + 1);
        }
        List<Field> declaredFields = ReflectionUtil.getAllDeclaredFields(object.getClass());
        for (Field field : declaredFields) {
            if (className != null && !className.equals(field.getDeclaringClass().getName()) || !simpleFieldName.equals(field.getName())) continue;
            field.setAccessible(true);
            try {
                field.set(object, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        throw new IllegalArgumentException(String.format("object's class %s does not have this field: %s", object.getClass(), fieldName));
    }

    public static Set<Class<?>> getAllInterfaces(Class<?> clazz) {
        AssertUtil.assertNotNull(clazz, "clazz");
        LinkedHashSet interfaces = new LinkedHashSet();
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            ReflectionUtil.populateInterfaces(interfaces, c);
        }
        return interfaces;
    }

    private static void populateInterfaces(Collection<Class<?>> interfaces, Class<?> clazz) {
        for (Class<?> iface : clazz.getInterfaces()) {
            interfaces.add(iface);
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            ReflectionUtil.populateInterfaces(interfaces, iface);
        }
    }

    public static final <T> Type[] resolveActualTypeArguments(Class<T> baseClass, T concreteObject) {
        AssertUtil.assertNotNull(baseClass, "baseClass");
        AssertUtil.assertNotNull(concreteObject, "concreteObject");
        Class<?> concreteClass = concreteObject.getClass();
        return ReflectionUtil.resolveActualTypeArguments(baseClass, concreteClass);
    }

    public static final <T> Type[] resolveActualTypeArguments(Class<T> baseClass, Class<? extends T> concreteClass) {
        return ReflectionUtil._resolveActualTypeArgs(baseClass, concreteClass, new Type[0]);
    }

    private static final <T> Type[] _resolveActualTypeArgs(Class<T> baseClass, Class<? extends T> concreteClass, Type ... actualArgs) {
        AssertUtil.assertNotNull(baseClass, "baseClass");
        AssertUtil.assertNotNull(concreteClass, "concreteClass");
        AssertUtil.assertNotNull(actualArgs, "actualArgs");
        if (actualArgs.length != 0 && actualArgs.length != concreteClass.getTypeParameters().length) {
            throw new IllegalArgumentException("actualArgs.length != 0 && actualArgs.length != concreteClass.typeParameters.length");
        }
        Type[] _actualArgs = actualArgs.length == 0 ? concreteClass.getTypeParameters() : actualArgs;
        HashMap<String, Type> typeVariables = new HashMap<String, Type>();
        for (int i = 0; i < _actualArgs.length; ++i) {
            TypeVariable<Class<T>> typeVariable = concreteClass.getTypeParameters()[i];
            typeVariables.put(typeVariable.getName(), _actualArgs[i]);
        }
        LinkedList<Type> ancestors = new LinkedList<Type>();
        if (concreteClass.getGenericSuperclass() != null) {
            ancestors.add(concreteClass.getGenericSuperclass());
        }
        for (Type t : concreteClass.getGenericInterfaces()) {
            ancestors.add(t);
        }
        for (Type type : ancestors) {
            Class rawTypeClass;
            ParameterizedType parameterizedType;
            Type rawType;
            Type[] result;
            Class ancestorClass;
            if (type instanceof Class && baseClass.isAssignableFrom(ancestorClass = (Class)type) && (result = ReflectionUtil._resolveActualTypeArgs(baseClass, ancestorClass, new Type[0])) != null) {
                return result;
            }
            if (!(type instanceof ParameterizedType) || !((rawType = (parameterizedType = (ParameterizedType)type).getRawType()) instanceof Class) || !baseClass.isAssignableFrom(rawTypeClass = (Class)rawType)) continue;
            LinkedList<Type> resolvedTypes = new LinkedList<Type>();
            for (Type t : parameterizedType.getActualTypeArguments()) {
                if (t instanceof TypeVariable) {
                    Type resolvedType = (Type)typeVariables.get(((TypeVariable)t).getName());
                    resolvedTypes.add(resolvedType != null ? resolvedType : t);
                    continue;
                }
                resolvedTypes.add(t);
            }
            Type[] result2 = ReflectionUtil._resolveActualTypeArgs(baseClass, rawTypeClass, resolvedTypes.toArray(new Type[0]));
            if (result2 == null) continue;
            return result2;
        }
        return concreteClass.equals(baseClass) ? _actualArgs : null;
    }
}

